/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers.samediff;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.shade.jackson.annotation.JsonIgnore;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"paramsList", "weightParamsList", "biasParamsList"})
public class SDLayerParams
implements Serializable {
    private Map<String, int[]> weightParams = new LinkedHashMap<String, int[]>();
    private Map<String, int[]> biasParams = new LinkedHashMap<String, int[]>();
    @JsonIgnore
    private List<String> paramsList;
    @JsonIgnore
    private List<String> weightParamsList;
    @JsonIgnore
    private List<String> biasParamsList;

    public SDLayerParams(@JsonProperty(value="weightParams") Map<String, int[]> weightParams, @JsonProperty(value="biasParams") Map<String, int[]> biasParams) {
        this.weightParams = weightParams;
        this.biasParams = biasParams;
    }

    public void addWeightParam(@NonNull String paramKey, int ... paramShape) {
        if (paramKey == null) {
            throw new NullPointerException("paramKey");
        }
        if (paramShape == null) {
            throw new NullPointerException("paramShape");
        }
        Preconditions.checkArgument((paramShape.length > 0 ? 1 : 0) != 0, (Object)("Provided weight parameter shape is invalid: length 0 provided for shape. Parameter: " + paramKey));
        this.weightParams.put(paramKey, paramShape);
        this.paramsList = null;
        this.weightParamsList = null;
        this.biasParamsList = null;
    }

    public void addBiasParam(@NonNull String paramKey, @NonNull int[] paramShape) {
        if (paramKey == null) {
            throw new NullPointerException("paramKey");
        }
        if (paramShape == null) {
            throw new NullPointerException("paramShape");
        }
        Preconditions.checkArgument((paramShape.length > 0 ? 1 : 0) != 0, (Object)("Provided mia- parameter shape is invalid: length 0 provided for shape. Parameter: " + paramKey));
        this.biasParams.put(paramKey, paramShape);
        this.paramsList = null;
        this.weightParamsList = null;
        this.biasParamsList = null;
    }

    @JsonIgnore
    public List<String> getParameterKeys() {
        if (this.paramsList == null) {
            ArrayList<String> out = new ArrayList<String>();
            out.addAll(this.getWeightParameterKeys());
            out.addAll(this.getBiasParameterKeys());
            this.paramsList = Collections.unmodifiableList(out);
        }
        return this.paramsList;
    }

    @JsonIgnore
    public List<String> getWeightParameterKeys() {
        if (this.weightParamsList == null) {
            this.weightParamsList = Collections.unmodifiableList(new ArrayList<String>(this.weightParams.keySet()));
        }
        return this.weightParamsList;
    }

    @JsonIgnore
    public List<String> getBiasParameterKeys() {
        if (this.biasParamsList == null) {
            this.biasParamsList = Collections.unmodifiableList(new ArrayList<String>(this.biasParams.keySet()));
        }
        return this.biasParamsList;
    }

    @JsonIgnore
    public Map<String, int[]> getParamShapes() {
        LinkedHashMap<String, int[]> map = new LinkedHashMap<String, int[]>();
        map.putAll(this.weightParams);
        map.putAll(this.biasParams);
        return map;
    }

    public void clear() {
        this.weightParams.clear();
        this.biasParams.clear();
        this.paramsList = null;
        this.weightParamsList = null;
        this.biasParamsList = null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SDLayerParams)) {
            return false;
        }
        SDLayerParams s = (SDLayerParams)o;
        return SDLayerParams.equals(this.weightParams, s.weightParams) && SDLayerParams.equals(this.biasParams, s.biasParams);
    }

    private static boolean equals(Map<String, int[]> first, Map<String, int[]> second) {
        if (!first.keySet().equals(second.keySet())) {
            return false;
        }
        for (Map.Entry<String, int[]> e : first.entrySet()) {
            if (Arrays.equals(e.getValue(), second.get(e.getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.weightParams.hashCode() ^ this.biasParams.hashCode();
    }

    public SDLayerParams() {
    }

    public Map<String, int[]> getWeightParams() {
        return this.weightParams;
    }

    public Map<String, int[]> getBiasParams() {
        return this.biasParams;
    }

    public List<String> getParamsList() {
        return this.paramsList;
    }

    public List<String> getWeightParamsList() {
        return this.weightParamsList;
    }

    public List<String> getBiasParamsList() {
        return this.biasParamsList;
    }

    public void setWeightParams(Map<String, int[]> weightParams) {
        this.weightParams = weightParams;
    }

    public void setBiasParams(Map<String, int[]> biasParams) {
        this.biasParams = biasParams;
    }

    public void setParamsList(List<String> paramsList) {
        this.paramsList = paramsList;
    }

    public void setWeightParamsList(List<String> weightParamsList) {
        this.weightParamsList = weightParamsList;
    }

    public void setBiasParamsList(List<String> biasParamsList) {
        this.biasParamsList = biasParamsList;
    }

    public String toString() {
        return "SDLayerParams(weightParams=" + this.getWeightParams() + ", biasParams=" + this.getBiasParams() + ", paramsList=" + this.getParamsList() + ", weightParamsList=" + this.getWeightParamsList() + ", biasParamsList=" + this.getBiasParamsList() + ")";
    }
}

