/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers.samediff;

import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.samediff.SDLayerParams;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.params.SameDiffParamInitializer;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.nn.weights.WeightInitUtil;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.learning.config.IUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSameDiffLayer
extends Layer {
    private static final Logger log = LoggerFactory.getLogger(AbstractSameDiffLayer.class);
    protected double l1;
    protected double l2;
    protected double l1Bias;
    protected double l2Bias;
    protected IUpdater updater;
    protected IUpdater biasUpdater;
    private SDLayerParams layerParams;

    protected AbstractSameDiffLayer(Builder builder) {
        super(builder);
        this.l1 = builder.l1;
        this.l2 = builder.l2;
        this.l1Bias = builder.l1Bias;
        this.l2Bias = builder.l2Bias;
        this.updater = builder.updater;
        this.biasUpdater = builder.biasUpdater;
        try {
            this.getClass().getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            log.warn("***SameDiff layer {} does not have a zero argument (no-arg) constructor.***\nA no-arg constructor is required for JSON deserialization, which is used for both model saving and distributed (Spark) training.\nA no-arg constructor (private, protected or public) as well as setters (or simply a Lombok @Data annotation) should be added to avoid JSON errors later.", (Object)this.getClass().getName());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    protected AbstractSameDiffLayer() {
    }

    public SDLayerParams getLayerParams() {
        if (this.layerParams == null) {
            this.layerParams = new SDLayerParams();
            this.defineParameters(this.layerParams);
        }
        return this.layerParams;
    }

    @Override
    public abstract InputType getOutputType(int var1, InputType var2);

    @Override
    public abstract void setNIn(InputType var1, boolean var2);

    @Override
    public abstract InputPreProcessor getPreProcessorForInputType(InputType var1);

    public abstract void defineParameters(SDLayerParams var1);

    public abstract void initializeParameters(Map<String, INDArray> var1);

    public abstract void applyGlobalConfigToLayer(NeuralNetConfiguration.Builder var1);

    @Override
    public abstract org.deeplearning4j.nn.api.Layer instantiate(NeuralNetConfiguration var1, Collection<TrainingListener> var2, int var3, INDArray var4, boolean var5);

    @Override
    public ParamInitializer initializer() {
        return SameDiffParamInitializer.getInstance();
    }

    @Override
    public double getL1ByParam(String paramName) {
        return this.initializer().isWeightParam(this, paramName) ? this.l1 : this.l1Bias;
    }

    @Override
    public double getL2ByParam(String paramName) {
        return this.initializer().isWeightParam(this, paramName) ? this.l2 : this.l2Bias;
    }

    @Override
    public IUpdater getUpdaterByParam(String paramName) {
        if (this.biasUpdater != null && this.initializer().isBiasParam(this, paramName)) {
            return this.biasUpdater;
        }
        if (this.initializer().isBiasParam(this, paramName) || this.initializer().isWeightParam(this, paramName)) {
            return this.updater;
        }
        throw new IllegalStateException("Unknown parameter key: " + paramName);
    }

    @Override
    public boolean isPretrainParam(String paramName) {
        return false;
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        return new LayerMemoryReport();
    }

    public char paramReshapeOrder(String param) {
        return 'c';
    }

    protected void initWeights(int fanIn, int fanOut, WeightInit weightInit, INDArray array) {
        WeightInitUtil.initWeights(fanIn, fanOut, array.shape(), weightInit, null, this.paramReshapeOrder(null), array);
    }

    public void applyGlobalConfig(NeuralNetConfiguration.Builder b) {
        if (Double.isNaN(this.l1)) {
            this.l1 = b.getL1();
        }
        if (Double.isNaN(this.l2)) {
            this.l2 = b.getL2();
        }
        if (Double.isNaN(this.l1Bias)) {
            this.l1Bias = b.getL1Bias();
        }
        if (Double.isNaN(this.l2Bias)) {
            this.l2Bias = b.getL2Bias();
        }
        if (this.updater == null) {
            this.updater = b.getIUpdater();
        }
        if (this.biasUpdater == null) {
            this.biasUpdater = b.getBiasUpdater();
        }
        this.applyGlobalConfigToLayer(b);
    }

    public double getL1() {
        return this.l1;
    }

    public double getL2() {
        return this.l2;
    }

    public double getL1Bias() {
        return this.l1Bias;
    }

    public double getL2Bias() {
        return this.l2Bias;
    }

    public IUpdater getUpdater() {
        return this.updater;
    }

    public IUpdater getBiasUpdater() {
        return this.biasUpdater;
    }

    public void setL1(double l1) {
        this.l1 = l1;
    }

    public void setL2(double l2) {
        this.l2 = l2;
    }

    public void setL1Bias(double l1Bias) {
        this.l1Bias = l1Bias;
    }

    public void setL2Bias(double l2Bias) {
        this.l2Bias = l2Bias;
    }

    public void setUpdater(IUpdater updater) {
        this.updater = updater;
    }

    public void setBiasUpdater(IUpdater biasUpdater) {
        this.biasUpdater = biasUpdater;
    }

    public void setLayerParams(SDLayerParams layerParams) {
        this.layerParams = layerParams;
    }

    @Override
    public String toString() {
        return "AbstractSameDiffLayer(l1=" + this.getL1() + ", l2=" + this.getL2() + ", l1Bias=" + this.getL1Bias() + ", l2Bias=" + this.getL2Bias() + ", updater=" + this.getUpdater() + ", biasUpdater=" + this.getBiasUpdater() + ", layerParams=" + this.getLayerParams() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractSameDiffLayer)) {
            return false;
        }
        AbstractSameDiffLayer other = (AbstractSameDiffLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (Double.compare(this.getL1(), other.getL1()) != 0) {
            return false;
        }
        if (Double.compare(this.getL2(), other.getL2()) != 0) {
            return false;
        }
        if (Double.compare(this.getL1Bias(), other.getL1Bias()) != 0) {
            return false;
        }
        if (Double.compare(this.getL2Bias(), other.getL2Bias()) != 0) {
            return false;
        }
        IUpdater this$updater = this.getUpdater();
        IUpdater other$updater = other.getUpdater();
        if (this$updater == null ? other$updater != null : !this$updater.equals(other$updater)) {
            return false;
        }
        IUpdater this$biasUpdater = this.getBiasUpdater();
        IUpdater other$biasUpdater = other.getBiasUpdater();
        if (this$biasUpdater == null ? other$biasUpdater != null : !this$biasUpdater.equals(other$biasUpdater)) {
            return false;
        }
        SDLayerParams this$layerParams = this.getLayerParams();
        SDLayerParams other$layerParams = other.getLayerParams();
        return !(this$layerParams == null ? other$layerParams != null : !((Object)this$layerParams).equals(other$layerParams));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractSameDiffLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $l1 = Double.doubleToLongBits(this.getL1());
        result = result * 59 + (int)($l1 >>> 32 ^ $l1);
        long $l2 = Double.doubleToLongBits(this.getL2());
        result = result * 59 + (int)($l2 >>> 32 ^ $l2);
        long $l1Bias = Double.doubleToLongBits(this.getL1Bias());
        result = result * 59 + (int)($l1Bias >>> 32 ^ $l1Bias);
        long $l2Bias = Double.doubleToLongBits(this.getL2Bias());
        result = result * 59 + (int)($l2Bias >>> 32 ^ $l2Bias);
        IUpdater $updater = this.getUpdater();
        result = result * 59 + ($updater == null ? 43 : $updater.hashCode());
        IUpdater $biasUpdater = this.getBiasUpdater();
        result = result * 59 + ($biasUpdater == null ? 43 : $biasUpdater.hashCode());
        SDLayerParams $layerParams = this.getLayerParams();
        result = result * 59 + ($layerParams == null ? 43 : ((Object)$layerParams).hashCode());
        return result;
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Layer.Builder<T> {
        protected double l1 = Double.NaN;
        protected double l2 = Double.NaN;
        protected double l1Bias = Double.NaN;
        protected double l2Bias = Double.NaN;
        protected IUpdater updater = null;
        protected IUpdater biasUpdater = null;

        public T l1(double l1) {
            this.l1 = l1;
            return (T)this;
        }

        public T l2(double l2) {
            this.l2 = l2;
            return (T)this;
        }

        public T l1Bias(double l1Bias) {
            this.l1Bias = l1Bias;
            return (T)this;
        }

        public T l2Bias(double l2Bias) {
            this.l2Bias = l2Bias;
            return (T)this;
        }

        public T updater(IUpdater updater) {
            this.updater = updater;
            return (T)this;
        }

        public T biasUpdater(IUpdater biasUpdater) {
            this.biasUpdater = biasUpdater;
            return (T)this;
        }
    }
}

