/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.params.EmptyParamInitializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.deeplearning4j.util.Convolution3DUtils;
import org.deeplearning4j.util.ConvolutionUtils;
import org.nd4j.linalg.api.ndarray.INDArray;

public class Subsampling3DLayer
extends Layer {
    protected ConvolutionMode convolutionMode = ConvolutionMode.Truncate;
    protected org.deeplearning4j.nn.conf.layers.PoolingType poolingType;
    protected int[] kernelSize;
    protected int[] stride;
    protected int[] padding;
    protected boolean cudnnAllowFallback = true;

    protected Subsampling3DLayer(BaseSubsamplingBuilder builder) {
        super(builder);
        this.poolingType = builder.poolingType;
        if (builder.kernelSize.length != 3) {
            throw new IllegalArgumentException("Kernel size must be length 3");
        }
        this.kernelSize = builder.kernelSize;
        if (builder.stride.length != 3) {
            throw new IllegalArgumentException("Invalid stride, must be length 3");
        }
        this.stride = builder.stride;
        this.padding = builder.padding;
        this.convolutionMode = builder.convolutionMode;
        this.cudnnAllowFallback = builder.cudnnAllowFallback;
    }

    @Override
    public Subsampling3DLayer clone() {
        Subsampling3DLayer clone = (Subsampling3DLayer)super.clone();
        if (clone.kernelSize != null) {
            clone.kernelSize = (int[])clone.kernelSize.clone();
        }
        if (clone.stride != null) {
            clone.stride = (int[])clone.stride.clone();
        }
        if (clone.padding != null) {
            clone.padding = (int[])clone.padding.clone();
        }
        return clone;
    }

    @Override
    public org.deeplearning4j.nn.api.Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> iterationListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        org.deeplearning4j.nn.layers.convolution.subsampling.Subsampling3DLayer ret = new org.deeplearning4j.nn.layers.convolution.subsampling.Subsampling3DLayer(conf);
        ret.setListeners(iterationListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return EmptyParamInitializer.getInstance();
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN3D) {
            throw new IllegalStateException("Invalid input for Subsampling 3D layer (layer name=\"" + this.getLayerName() + "\"): Expected CNN input, got " + inputType);
        }
        return InputTypeUtil.getOutputTypeCnn3DLayers(inputType, this.kernelSize, this.stride, this.padding, new int[]{1, 1, 1}, this.convolutionMode, ((InputType.InputTypeConvolutional3D)inputType).getChannels(), layerIndex, this.getLayerName(), Subsampling3DLayer.class);
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for Subsampling 3D layer (layer name=\"" + this.getLayerName() + "\"): input is null");
        }
        return InputTypeUtil.getPreProcessorForInputTypeCnn3DLayers(inputType, this.getLayerName());
    }

    @Override
    public double getL1ByParam(String paramName) {
        return 0.0;
    }

    @Override
    public double getL2ByParam(String paramName) {
        return 0.0;
    }

    @Override
    public boolean isPretrainParam(String paramName) {
        throw new UnsupportedOperationException("SubsamplingLayer does not contain parameters");
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        int im2colSizePerEx;
        InputType.InputTypeConvolutional3D c = (InputType.InputTypeConvolutional3D)inputType;
        InputType.InputTypeConvolutional3D outputType = (InputType.InputTypeConvolutional3D)this.getOutputType(-1, inputType);
        int actElementsPerEx = outputType.arrayElementsPerExample();
        int trainingWorkingSizePerEx = im2colSizePerEx = c.getChannels() * outputType.getHeight() * outputType.getWidth() * outputType.getDepth() * this.kernelSize[0] * this.kernelSize[1];
        if (this.getIDropout() != null) {
            trainingWorkingSizePerEx += inputType.arrayElementsPerExample();
        }
        return new LayerMemoryReport.Builder(this.layerName, Subsampling3DLayer.class, inputType, outputType).standardMemory(0L, 0L).workingMemory(0L, (long)im2colSizePerEx, 0L, trainingWorkingSizePerEx).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    public ConvolutionMode getConvolutionMode() {
        return this.convolutionMode;
    }

    public org.deeplearning4j.nn.conf.layers.PoolingType getPoolingType() {
        return this.poolingType;
    }

    public int[] getKernelSize() {
        return this.kernelSize;
    }

    public int[] getStride() {
        return this.stride;
    }

    public int[] getPadding() {
        return this.padding;
    }

    public boolean isCudnnAllowFallback() {
        return this.cudnnAllowFallback;
    }

    public void setConvolutionMode(ConvolutionMode convolutionMode) {
        this.convolutionMode = convolutionMode;
    }

    public void setPoolingType(org.deeplearning4j.nn.conf.layers.PoolingType poolingType) {
        this.poolingType = poolingType;
    }

    public void setKernelSize(int[] kernelSize) {
        this.kernelSize = kernelSize;
    }

    public void setStride(int[] stride) {
        this.stride = stride;
    }

    public void setPadding(int[] padding) {
        this.padding = padding;
    }

    public void setCudnnAllowFallback(boolean cudnnAllowFallback) {
        this.cudnnAllowFallback = cudnnAllowFallback;
    }

    public Subsampling3DLayer() {
    }

    @Override
    public String toString() {
        return "Subsampling3DLayer(super=" + super.toString() + ", convolutionMode=" + (Object)((Object)this.getConvolutionMode()) + ", poolingType=" + (Object)((Object)this.getPoolingType()) + ", kernelSize=" + Arrays.toString(this.getKernelSize()) + ", stride=" + Arrays.toString(this.getStride()) + ", padding=" + Arrays.toString(this.getPadding()) + ", cudnnAllowFallback=" + this.isCudnnAllowFallback() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Subsampling3DLayer)) {
            return false;
        }
        Subsampling3DLayer other = (Subsampling3DLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConvolutionMode this$convolutionMode = this.getConvolutionMode();
        ConvolutionMode other$convolutionMode = other.getConvolutionMode();
        if (this$convolutionMode == null ? other$convolutionMode != null : !((Object)((Object)this$convolutionMode)).equals((Object)other$convolutionMode)) {
            return false;
        }
        org.deeplearning4j.nn.conf.layers.PoolingType this$poolingType = this.getPoolingType();
        org.deeplearning4j.nn.conf.layers.PoolingType other$poolingType = other.getPoolingType();
        if (this$poolingType == null ? other$poolingType != null : !((Object)((Object)this$poolingType)).equals((Object)other$poolingType)) {
            return false;
        }
        if (!Arrays.equals(this.getKernelSize(), other.getKernelSize())) {
            return false;
        }
        if (!Arrays.equals(this.getStride(), other.getStride())) {
            return false;
        }
        if (!Arrays.equals(this.getPadding(), other.getPadding())) {
            return false;
        }
        return this.isCudnnAllowFallback() == other.isCudnnAllowFallback();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Subsampling3DLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ConvolutionMode $convolutionMode = this.getConvolutionMode();
        result = result * 59 + ($convolutionMode == null ? 43 : ((Object)((Object)$convolutionMode)).hashCode());
        org.deeplearning4j.nn.conf.layers.PoolingType $poolingType = this.getPoolingType();
        result = result * 59 + ($poolingType == null ? 43 : ((Object)((Object)$poolingType)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getKernelSize());
        result = result * 59 + Arrays.hashCode(this.getStride());
        result = result * 59 + Arrays.hashCode(this.getPadding());
        result = result * 59 + (this.isCudnnAllowFallback() ? 79 : 97);
        return result;
    }

    protected static abstract class BaseSubsamplingBuilder<T extends BaseSubsamplingBuilder<T>>
    extends Layer.Builder<T> {
        protected org.deeplearning4j.nn.conf.layers.PoolingType poolingType = org.deeplearning4j.nn.conf.layers.PoolingType.MAX;
        protected int[] kernelSize = new int[]{1, 1, 1};
        protected int[] stride = new int[]{2, 2, 2};
        protected int[] padding = new int[]{0, 0, 0};
        protected ConvolutionMode convolutionMode = null;
        protected boolean cudnnAllowFallback = true;

        protected BaseSubsamplingBuilder(PoolingType poolingType, int[] kernelSize, int[] stride) {
            this.poolingType = poolingType.toPoolingType();
            this.kernelSize = kernelSize;
            this.stride = stride;
        }

        protected BaseSubsamplingBuilder(PoolingType poolingType, int[] kernelSize) {
            this.poolingType = poolingType.toPoolingType();
            this.kernelSize = kernelSize;
        }

        protected BaseSubsamplingBuilder(PoolingType poolingType, int[] kernelSize, int[] stride, int[] padding) {
            this.poolingType = poolingType.toPoolingType();
            this.kernelSize = kernelSize;
            this.stride = stride;
            this.padding = padding;
        }

        protected BaseSubsamplingBuilder(org.deeplearning4j.nn.conf.layers.PoolingType poolingType, int[] kernelSize) {
            this.poolingType = poolingType;
            this.kernelSize = kernelSize;
        }

        protected BaseSubsamplingBuilder(org.deeplearning4j.nn.conf.layers.PoolingType poolingType, int[] kernelSize, int[] stride, int[] padding) {
            this.poolingType = poolingType;
            this.kernelSize = kernelSize;
            this.stride = stride;
            this.padding = padding;
        }

        protected BaseSubsamplingBuilder(int[] kernelSize, int[] stride, int[] padding) {
            this.kernelSize = kernelSize;
            this.stride = stride;
            this.padding = padding;
        }

        protected BaseSubsamplingBuilder(int[] kernelSize, int[] stride) {
            this.kernelSize = kernelSize;
            this.stride = stride;
        }

        protected BaseSubsamplingBuilder(int ... kernelSize) {
            this.kernelSize = kernelSize;
        }

        protected BaseSubsamplingBuilder(PoolingType poolingType) {
            this.poolingType = poolingType.toPoolingType();
        }

        protected BaseSubsamplingBuilder(org.deeplearning4j.nn.conf.layers.PoolingType poolingType) {
            this.poolingType = poolingType;
        }

        public T convolutionMode(ConvolutionMode convolutionMode) {
            this.convolutionMode = convolutionMode;
            return (T)this;
        }

        public T poolingType(PoolingType poolingType) {
            this.poolingType = poolingType.toPoolingType();
            return (T)this;
        }

        public T cudnnAllowFallback(boolean allowFallback) {
            this.cudnnAllowFallback = allowFallback;
            return (T)this;
        }

        public BaseSubsamplingBuilder() {
        }
    }

    public static class Builder
    extends BaseSubsamplingBuilder<Builder> {
        public Builder(PoolingType poolingType, int[] kernelSize, int[] stride) {
            super(poolingType, kernelSize, stride);
        }

        public Builder(PoolingType poolingType, int[] kernelSize) {
            super(poolingType, kernelSize);
        }

        public Builder(PoolingType poolingType, int[] kernelSize, int[] stride, int[] padding) {
            super(poolingType, kernelSize, stride, padding);
        }

        public Builder(org.deeplearning4j.nn.conf.layers.PoolingType poolingType, int[] kernelSize) {
            super(poolingType, kernelSize);
        }

        public Builder(org.deeplearning4j.nn.conf.layers.PoolingType poolingType, int[] kernelSize, int[] stride, int[] padding) {
            super(poolingType, kernelSize, stride, padding);
        }

        public Builder(int[] kernelSize, int[] stride, int[] padding) {
            super(kernelSize, stride, padding);
        }

        public Builder(int[] kernelSize, int[] stride) {
            super(kernelSize, stride);
        }

        public Builder(int ... kernelSize) {
            super(kernelSize);
        }

        public Builder(PoolingType poolingType) {
            super(poolingType);
        }

        public Builder(org.deeplearning4j.nn.conf.layers.PoolingType poolingType) {
            super(poolingType);
        }

        public Builder kernelSize(int ... kernelSize) {
            if (kernelSize.length != 3) {
                throw new IllegalArgumentException("Invalid input: must be length 3");
            }
            this.kernelSize = kernelSize;
            return this;
        }

        public Builder stride(int ... stride) {
            if (stride.length != 3) {
                throw new IllegalArgumentException("Invalid input: must be length 3");
            }
            this.stride = stride;
            return this;
        }

        public Builder padding(int ... padding) {
            if (padding.length != 3) {
                throw new IllegalArgumentException("Invalid input: must be length 3");
            }
            this.padding = padding;
            return this;
        }

        @Override
        public Subsampling3DLayer build() {
            ConvolutionUtils.validateConvolutionModePadding(this.convolutionMode, this.padding);
            Convolution3DUtils.validateCnn3DKernelStridePadding(this.kernelSize, this.stride, this.padding);
            return new Subsampling3DLayer(this);
        }

        public Builder() {
        }
    }

    public static enum PoolingType {
        MAX,
        AVG;


        public org.deeplearning4j.nn.conf.layers.PoolingType toPoolingType() {
            switch (this) {
                case MAX: {
                    return org.deeplearning4j.nn.conf.layers.PoolingType.MAX;
                }
                case AVG: {
                    return org.deeplearning4j.nn.conf.layers.PoolingType.AVG;
                }
            }
            throw new UnsupportedOperationException("Unknown/not supported pooling type: " + (Object)((Object)this));
        }
    }
}

