/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.PoolingType;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.deeplearning4j.util.ConvolutionUtils;
import org.nd4j.linalg.api.ndarray.INDArray;

public class Subsampling1DLayer
extends SubsamplingLayer {
    private Subsampling1DLayer(Builder builder) {
        super(builder);
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        org.deeplearning4j.nn.layers.convolution.subsampling.Subsampling1DLayer ret = new org.deeplearning4j.nn.layers.convolution.subsampling.Subsampling1DLayer(conf);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.RNN) {
            throw new IllegalStateException("Invalid input for Subsampling layer (layer name=\"" + this.getLayerName() + "\"): Expected RNN input, got " + inputType);
        }
        return inputType;
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for Subsampling1D layer (layer name=\"" + this.getLayerName() + "\"): input is null");
        }
        return InputTypeUtil.getPreprocessorForInputTypeRnnLayers(inputType, this.getLayerName());
    }

    @Override
    public Subsampling1DLayer clone() {
        Subsampling1DLayer clone = (Subsampling1DLayer)super.clone();
        if (clone.kernelSize != null) {
            clone.kernelSize = (int[])clone.kernelSize.clone();
        }
        if (clone.stride != null) {
            clone.stride = (int[])clone.stride.clone();
        }
        if (clone.padding != null) {
            clone.padding = (int[])clone.padding.clone();
        }
        return clone;
    }

    public Subsampling1DLayer() {
    }

    @Override
    public String toString() {
        return "Subsampling1DLayer(super=" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Subsampling1DLayer)) {
            return false;
        }
        Subsampling1DLayer other = (Subsampling1DLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Subsampling1DLayer;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public static class Builder
    extends SubsamplingLayer.BaseSubsamplingBuilder<Builder> {
        private static final PoolingType DEFAULT_POOLING = PoolingType.MAX;
        private static final int DEFAULT_KERNEL = 2;
        private static final int DEFAULT_STRIDE = 1;
        private static final int DEFAULT_PADDING = 0;

        public Builder(SubsamplingLayer.PoolingType poolingType, int kernelSize, int stride) {
            this(poolingType, kernelSize, stride, 0);
        }

        public Builder(SubsamplingLayer.PoolingType poolingType, int kernelSize) {
            this(poolingType, kernelSize, 1, 0);
        }

        public Builder(PoolingType poolingType, int kernelSize) {
            this(poolingType, kernelSize, 1, 0);
        }

        public Builder(int kernelSize, int stride, int padding) {
            this(DEFAULT_POOLING, kernelSize, stride, padding);
        }

        public Builder(int kernelSize, int stride) {
            this(DEFAULT_POOLING, kernelSize, stride, 0);
        }

        public Builder(int kernelSize) {
            this(DEFAULT_POOLING, kernelSize, 1, 0);
        }

        public Builder(SubsamplingLayer.PoolingType poolingType) {
            this(poolingType, 2, 1, 0);
        }

        public Builder(PoolingType poolingType) {
            this(poolingType, 2, 1, 0);
        }

        public Builder() {
            this(DEFAULT_POOLING, 2, 1, 0);
        }

        public Builder(PoolingType poolingType, int kernelSize, int stride, int padding) {
            super(poolingType, new int[]{kernelSize, 1}, new int[]{stride, 1}, new int[]{padding, 0});
        }

        public Builder(SubsamplingLayer.PoolingType poolingType, int kernelSize, int stride, int padding) {
            super(poolingType, new int[]{kernelSize, 1}, new int[]{stride, 1}, new int[]{padding, 0});
        }

        @Override
        public Subsampling1DLayer build() {
            if (this.poolingType == PoolingType.PNORM && this.pnorm <= 0) {
                throw new IllegalStateException("Incorrect Subsampling config: p-norm must be set when using PoolingType.PNORM");
            }
            ConvolutionUtils.validateConvolutionModePadding(this.convolutionMode, this.padding);
            ConvolutionUtils.validateCnnKernelStridePadding(this.kernelSize, this.stride, this.padding);
            return new Subsampling1DLayer(this);
        }

        public Builder kernelSize(int kernelSize) {
            this.kernelSize[0] = kernelSize;
            return this;
        }

        public Builder stride(int stride) {
            this.stride[0] = stride;
            return this;
        }

        public Builder padding(int padding) {
            this.padding[0] = padding;
            return this;
        }
    }
}

