/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.LayerValidation;
import org.deeplearning4j.nn.layers.convolution.DepthwiseConvolution2DLayer;
import org.deeplearning4j.nn.params.DepthwiseConvolutionParamInitializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.deeplearning4j.util.ConvolutionUtils;
import org.nd4j.linalg.api.ndarray.INDArray;

public class DepthwiseConvolution2D
extends ConvolutionLayer {
    int depthMultiplier;

    protected DepthwiseConvolution2D(Builder builder) {
        super(builder);
        this.depthMultiplier = builder.depthMultiplier;
        this.nOut = this.nIn * this.depthMultiplier;
        this.initializeConstraints(builder);
    }

    @Override
    public DepthwiseConvolution2D clone() {
        DepthwiseConvolution2D clone = (DepthwiseConvolution2D)super.clone();
        clone.depthMultiplier = this.depthMultiplier;
        return clone;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        LayerValidation.assertNInNOutSet("DepthwiseConvolution2D", this.getLayerName(), layerIndex, this.getNIn(), this.getNOut());
        DepthwiseConvolution2DLayer ret = new DepthwiseConvolution2DLayer(conf);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return DepthwiseConvolutionParamInitializer.getInstance();
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN) {
            throw new IllegalStateException("Invalid input for  depth-wise convolution layer (layer name=\"" + this.getLayerName() + "\"): Expected CNN input, got " + inputType);
        }
        return InputTypeUtil.getOutputTypeCnnLayers(inputType, this.kernelSize, this.stride, this.padding, this.dilation, this.convolutionMode, this.nOut, layerIndex, this.getLayerName(), DepthwiseConvolution2DLayer.class);
    }

    public int getDepthMultiplier() {
        return this.depthMultiplier;
    }

    public void setDepthMultiplier(int depthMultiplier) {
        this.depthMultiplier = depthMultiplier;
    }

    public DepthwiseConvolution2D() {
    }

    @Override
    public String toString() {
        return "DepthwiseConvolution2D(super=" + super.toString() + ", depthMultiplier=" + this.getDepthMultiplier() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DepthwiseConvolution2D)) {
            return false;
        }
        DepthwiseConvolution2D other = (DepthwiseConvolution2D)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getDepthMultiplier() == other.getDepthMultiplier();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DepthwiseConvolution2D;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getDepthMultiplier();
        return result;
    }

    public static class Builder
    extends ConvolutionLayer.BaseConvBuilder<Builder> {
        public int depthMultiplier = 1;

        public Builder(int[] kernelSize, int[] stride, int[] padding) {
            super(kernelSize, stride, padding);
        }

        public Builder(int[] kernelSize, int[] stride) {
            super(kernelSize, stride);
        }

        public Builder(int ... kernelSize) {
            super(kernelSize);
        }

        public Builder() {
        }

        public Builder depthMultiplier(int depthMultiplier) {
            this.depthMultiplier = depthMultiplier;
            return this;
        }

        public Builder kernelSize(int ... kernelSize) {
            this.kernelSize = kernelSize;
            return this;
        }

        public Builder stride(int ... stride) {
            this.stride = stride;
            return this;
        }

        public Builder padding(int ... padding) {
            this.padding = padding;
            return this;
        }

        @Override
        public DepthwiseConvolution2D build() {
            ConvolutionUtils.validateConvolutionModePadding(this.convolutionMode, this.padding);
            ConvolutionUtils.validateCnnKernelStridePadding(this.kernelSize, this.stride, this.padding);
            return new DepthwiseConvolution2D(this);
        }
    }
}

