/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.layers.LayerValidation;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.params.DefaultParamInitializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.api.ndarray.INDArray;

public class DenseLayer
extends FeedForwardLayer {
    private boolean hasBias = true;

    private DenseLayer(Builder builder) {
        super(builder);
        this.hasBias = builder.hasBias;
        this.initializeConstraints(builder);
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        LayerValidation.assertNInNOutSet("DenseLayer", this.getLayerName(), layerIndex, this.getNIn(), this.getNOut());
        org.deeplearning4j.nn.layers.feedforward.dense.DenseLayer ret = new org.deeplearning4j.nn.layers.feedforward.dense.DenseLayer(conf);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return DefaultParamInitializer.getInstance();
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        InputType outputType = this.getOutputType(-1, inputType);
        int numParams = this.initializer().numParams(this);
        int updaterStateSize = (int)this.getIUpdater().stateSize((long)numParams);
        int trainSizeFixed = 0;
        int trainSizeVariable = 0;
        if (this.getIDropout() != null) {
            trainSizeVariable += inputType.arrayElementsPerExample();
        }
        return new LayerMemoryReport.Builder(this.layerName, DenseLayer.class, inputType, outputType).standardMemory(numParams, updaterStateSize).workingMemory(0L, 0L, trainSizeFixed, trainSizeVariable += outputType.arrayElementsPerExample()).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    public boolean hasBias() {
        return this.hasBias;
    }

    public boolean isHasBias() {
        return this.hasBias;
    }

    public void setHasBias(boolean hasBias) {
        this.hasBias = hasBias;
    }

    public DenseLayer() {
    }

    @Override
    public String toString() {
        return "DenseLayer(super=" + super.toString() + ", hasBias=" + this.isHasBias() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DenseLayer)) {
            return false;
        }
        DenseLayer other = (DenseLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.isHasBias() == other.isHasBias();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DenseLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isHasBias() ? 79 : 97);
        return result;
    }

    public static class Builder
    extends FeedForwardLayer.Builder<Builder> {
        private boolean hasBias = true;

        public Builder hasBias(boolean hasBias) {
            this.hasBias = hasBias;
            return this;
        }

        @Override
        public DenseLayer build() {
            return new DenseLayer(this);
        }
    }
}

