/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.layers.OutputLayer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.lossfunctions.LossFunctions;
import org.nd4j.linalg.lossfunctions.impl.LossMCXENT;

public abstract class BaseOutputLayer
extends FeedForwardLayer {
    protected ILossFunction lossFn;
    protected boolean hasBias = true;

    protected BaseOutputLayer(Builder builder) {
        super(builder);
        this.lossFn = builder.lossFn;
        this.hasBias = builder.hasBias;
    }

    public boolean hasBias() {
        return this.hasBias;
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        InputType outputType = this.getOutputType(-1, inputType);
        int numParams = this.initializer().numParams(this);
        int updaterStateSize = (int)this.getIUpdater().stateSize((long)numParams);
        int trainSizeFixed = 0;
        int trainSizeVariable = 0;
        if (this.getIDropout() != null) {
            trainSizeVariable += inputType.arrayElementsPerExample();
        }
        return new LayerMemoryReport.Builder(this.layerName, OutputLayer.class, inputType, outputType).standardMemory(numParams, updaterStateSize).workingMemory(0L, 0L, trainSizeFixed, trainSizeVariable += outputType.arrayElementsPerExample()).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    public ILossFunction getLossFn() {
        return this.lossFn;
    }

    public boolean isHasBias() {
        return this.hasBias;
    }

    public void setLossFn(ILossFunction lossFn) {
        this.lossFn = lossFn;
    }

    public void setHasBias(boolean hasBias) {
        this.hasBias = hasBias;
    }

    public BaseOutputLayer() {
    }

    @Override
    public String toString() {
        return "BaseOutputLayer(super=" + super.toString() + ", lossFn=" + this.getLossFn() + ", hasBias=" + this.isHasBias() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseOutputLayer)) {
            return false;
        }
        BaseOutputLayer other = (BaseOutputLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ILossFunction this$lossFn = this.getLossFn();
        ILossFunction other$lossFn = other.getLossFn();
        if (this$lossFn == null ? other$lossFn != null : !this$lossFn.equals(other$lossFn)) {
            return false;
        }
        return this.isHasBias() == other.isHasBias();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseOutputLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ILossFunction $lossFn = this.getLossFn();
        result = result * 59 + ($lossFn == null ? 43 : $lossFn.hashCode());
        result = result * 59 + (this.isHasBias() ? 79 : 97);
        return result;
    }

    public static abstract class Builder<T extends Builder<T>>
    extends FeedForwardLayer.Builder<T> {
        protected ILossFunction lossFn = new LossMCXENT();
        private boolean hasBias = true;

        public Builder() {
        }

        public Builder(LossFunctions.LossFunction lossFunction) {
            this.lossFunction(lossFunction);
        }

        public Builder(ILossFunction lossFunction) {
            this.lossFn = lossFunction;
        }

        public T lossFunction(LossFunctions.LossFunction lossFunction) {
            return this.lossFunction(lossFunction.getILossFunction());
        }

        public T hasBias(boolean hasBias) {
            this.hasBias = hasBias;
            return (T)this;
        }

        public T lossFunction(ILossFunction lossFunction) {
            this.lossFn = lossFunction;
            return (T)this;
        }
    }
}

