/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.dropout;

import lombok.NonNull;
import org.deeplearning4j.nn.conf.dropout.IDropout;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.RandomOp;
import org.nd4j.linalg.api.ops.random.impl.DropOutInverted;
import org.nd4j.linalg.factory.Broadcast;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class SpatialDropout
implements IDropout {
    private double p;
    private ISchedule pSchedule;

    public SpatialDropout(double activationRetainProbability) {
        this(activationRetainProbability, null);
        if (activationRetainProbability < 0.0) {
            throw new IllegalArgumentException("Activation retain probability must be > 0. Got: " + activationRetainProbability);
        }
        if (activationRetainProbability == 0.0) {
            throw new IllegalArgumentException("Invalid probability value: Dropout with 0.0 probability of retaining activations is not supported");
        }
    }

    public SpatialDropout(ISchedule activationRetainProbabilitySchedule) {
        this(Double.NaN, activationRetainProbabilitySchedule);
    }

    protected SpatialDropout(@JsonProperty(value="p") double activationRetainProbability, @JsonProperty(value="pSchedule") ISchedule activationRetainProbabilitySchedule) {
        this.p = activationRetainProbability;
        this.pSchedule = activationRetainProbabilitySchedule;
    }

    @Override
    public INDArray applyDropout(@NonNull INDArray inputActivations, int iteration, int epoch, boolean inPlace) {
        if (inputActivations == null) {
            throw new NullPointerException("inputActivations");
        }
        Preconditions.checkArgument((inputActivations.rank() == 5 || inputActivations.rank() == 4 || inputActivations.rank() == 3 ? 1 : 0) != 0, (String)"Cannot apply spatial dropout to activations of rank %s: spatial dropout can only be used for rank 3, 4 or 5 activations (input activations shape: %s)", (Object)inputActivations.rank(), (Object)inputActivations.shape());
        double currP = this.pSchedule != null ? this.pSchedule.valueAt(iteration, epoch) : this.p;
        int minibatch = inputActivations.size(0);
        int dim1 = inputActivations.size(1);
        INDArray mask = Nd4j.ones((int)minibatch, (int)dim1);
        Nd4j.getExecutioner().exec((RandomOp)new DropOutInverted(mask, currP));
        INDArray result = inPlace ? inputActivations : Nd4j.createUninitialized((int[])inputActivations.shape(), (char)'c');
        Broadcast.mul((INDArray)inputActivations, (INDArray)mask, (INDArray)result, (int[])new int[]{0, 1});
        return result;
    }

    @Override
    public IDropout clone() {
        return new SpatialDropout(this.p, this.pSchedule);
    }

    public double getP() {
        return this.p;
    }

    public ISchedule getPSchedule() {
        return this.pSchedule;
    }

    public void setP(double p) {
        this.p = p;
    }

    public void setPSchedule(ISchedule pSchedule) {
        this.pSchedule = pSchedule;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpatialDropout)) {
            return false;
        }
        SpatialDropout other = (SpatialDropout)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getP(), other.getP()) != 0) {
            return false;
        }
        ISchedule this$pSchedule = this.getPSchedule();
        ISchedule other$pSchedule = other.getPSchedule();
        return !(this$pSchedule == null ? other$pSchedule != null : !this$pSchedule.equals(other$pSchedule));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpatialDropout;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $p = Double.doubleToLongBits(this.getP());
        result = result * 59 + (int)($p >>> 32 ^ $p);
        ISchedule $pSchedule = this.getPSchedule();
        result = result * 59 + ($pSchedule == null ? 43 : $pSchedule.hashCode());
        return result;
    }

    public String toString() {
        return "SpatialDropout(p=" + this.getP() + ", pSchedule=" + this.getPSchedule() + ")";
    }
}

