/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.dropout;

import org.deeplearning4j.nn.conf.dropout.IDropout;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.RandomOp;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.OldMulOp;
import org.nd4j.linalg.api.ops.random.impl.GaussianDistribution;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class GaussianDropout
implements IDropout {
    private final double rate;
    private final ISchedule rateSchedule;

    public GaussianDropout(double rate) {
        this(rate, null);
    }

    public GaussianDropout(ISchedule rateSchedule) {
        this(Double.NaN, rateSchedule);
    }

    protected GaussianDropout(@JsonProperty(value="rate") double rate, @JsonProperty(value="rateSchedule") ISchedule rateSchedule) {
        this.rate = rate;
        this.rateSchedule = rateSchedule;
    }

    @Override
    public INDArray applyDropout(INDArray inputActivations, int iteration, int epoch, boolean inPlace) {
        double r = this.rateSchedule != null ? this.rateSchedule.valueAt(iteration, epoch) : this.rate;
        double stdev = Math.sqrt(r / (1.0 - r));
        INDArray noise = Nd4j.createUninitialized((int[])inputActivations.shape(), (char)inputActivations.ordering());
        Nd4j.getExecutioner().exec((RandomOp)new GaussianDistribution(noise, 1.0, stdev));
        if (inPlace) {
            return inputActivations.muli(noise);
        }
        INDArray result = Nd4j.createUninitialized((int[])inputActivations.shape(), (char)inputActivations.ordering());
        return Nd4j.getExecutioner().execAndReturn((TransformOp)new OldMulOp(inputActivations, noise, result));
    }

    @Override
    public GaussianDropout clone() {
        return new GaussianDropout(this.rate, this.rateSchedule == null ? null : this.rateSchedule.clone());
    }

    public double getRate() {
        return this.rate;
    }

    public ISchedule getRateSchedule() {
        return this.rateSchedule;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GaussianDropout)) {
            return false;
        }
        GaussianDropout other = (GaussianDropout)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getRate(), other.getRate()) != 0) {
            return false;
        }
        ISchedule this$rateSchedule = this.getRateSchedule();
        ISchedule other$rateSchedule = other.getRateSchedule();
        return !(this$rateSchedule == null ? other$rateSchedule != null : !this$rateSchedule.equals(other$rateSchedule));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GaussianDropout;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $rate = Double.doubleToLongBits(this.getRate());
        result = result * 59 + (int)($rate >>> 32 ^ $rate);
        ISchedule $rateSchedule = this.getRateSchedule();
        result = result * 59 + ($rateSchedule == null ? 43 : $rateSchedule.hashCode());
        return result;
    }

    public String toString() {
        return "GaussianDropout(rate=" + this.getRate() + ", rateSchedule=" + this.getRateSchedule() + ")";
    }
}

