/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.BaseUpsamplingLayer;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.deeplearning4j.util.ValidationUtils;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;

public class Upsampling1D
extends BaseUpsamplingLayer {
    protected int[] size;

    protected Upsampling1D(BaseUpsamplingLayer.UpsamplingBuilder builder) {
        super(builder);
        this.size = builder.size;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams, DataType networkDataType) {
        org.deeplearning4j.nn.layers.convolution.upsampling.Upsampling1D ret = new org.deeplearning4j.nn.layers.convolution.upsampling.Upsampling1D(conf, networkDataType);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public Upsampling1D clone() {
        Upsampling1D clone = (Upsampling1D)super.clone();
        return clone;
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.RNN) {
            throw new IllegalStateException("Invalid input for 1D Upsampling layer (layer index = " + layerIndex + ", layer name = \"" + this.getLayerName() + "\"): expect RNN input type with size > 0. Got: " + inputType);
        }
        InputType.InputTypeRecurrent recurrent = (InputType.InputTypeRecurrent)inputType;
        long outLength = recurrent.getTimeSeriesLength();
        if (outLength > 0L) {
            outLength *= (long)this.size[0];
        }
        return InputType.recurrent(recurrent.getSize(), outLength);
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for Upsampling layer (layer name=\"" + this.getLayerName() + "\"): input is null");
        }
        return InputTypeUtil.getPreProcessorForInputTypeCnnLayers(inputType, this.getLayerName());
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        long im2colSizePerEx;
        InputType.InputTypeRecurrent recurrent = (InputType.InputTypeRecurrent)inputType;
        InputType.InputTypeRecurrent outputType = (InputType.InputTypeRecurrent)this.getOutputType(-1, inputType);
        long trainingWorkingSizePerEx = im2colSizePerEx = recurrent.getSize() * outputType.getTimeSeriesLength() * (long)this.size[0];
        if (this.getIDropout() != null) {
            trainingWorkingSizePerEx += inputType.arrayElementsPerExample();
        }
        return new LayerMemoryReport.Builder(this.layerName, Upsampling1D.class, inputType, outputType).standardMemory(0L, 0L).workingMemory(0L, im2colSizePerEx, 0L, trainingWorkingSizePerEx).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    @Override
    public int[] getSize() {
        return this.size;
    }

    @Override
    public void setSize(int[] size) {
        this.size = size;
    }

    public Upsampling1D() {
    }

    @Override
    public String toString() {
        return "Upsampling1D(super=" + super.toString() + ", size=" + Arrays.toString(this.getSize()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Upsampling1D)) {
            return false;
        }
        Upsampling1D other = (Upsampling1D)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.equals(this.getSize(), other.getSize());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Upsampling1D;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getSize());
        return result;
    }

    public static class Builder
    extends BaseUpsamplingLayer.UpsamplingBuilder<Builder> {
        public Builder(int size) {
            super(new int[]{size, size});
        }

        public Builder size(int size) {
            this.setSize(size);
            return this;
        }

        public Builder size(int[] size) {
            this.setSize(size);
            return this;
        }

        @Override
        public Upsampling1D build() {
            return new Upsampling1D(this);
        }

        @Override
        public void setSize(int ... size) {
            if (size.length == 2) {
                if (size[0] == size[1]) {
                    this.setSize(size[0]);
                    return;
                }
                Preconditions.checkArgument((boolean)false, (String)("When given a length 2 array for size, the values must be equal.  Got: " + Arrays.toString(size)));
            }
            int[] temp = ValidationUtils.validate1NonNegative(size, "size");
            this.size = new int[]{temp[0], temp[0]};
        }

        public Builder() {
        }
    }
}

