/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.constraint;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.nd4j.linalg.api.ndarray.INDArray;

public abstract class BaseConstraint
implements LayerConstraint {
    public static final double DEFAULT_EPSILON = 1.0E-6;
    protected Set<String> params = new HashSet<String>();
    protected double epsilon = 1.0E-6;
    protected int[] dimensions;

    protected BaseConstraint() {
    }

    protected BaseConstraint(Set<String> paramNames, int ... dimensions) {
        this(paramNames, 1.0E-6, dimensions);
    }

    @Override
    public void applyConstraint(Layer layer, int iteration, int epoch) {
        Map<String, INDArray> paramTable = layer.paramTable();
        if (paramTable == null || paramTable.isEmpty()) {
            return;
        }
        ParamInitializer i = layer.conf().getLayer().initializer();
        for (Map.Entry<String, INDArray> e : paramTable.entrySet()) {
            if (this.params.contains(e.getKey())) {
                this.apply(e.getValue());
            }
            if (this.params == null || !this.params.contains(e.getKey())) continue;
            this.apply(e.getValue());
        }
    }

    public abstract void apply(INDArray var1);

    @Override
    public abstract BaseConstraint clone();

    public static int[] getBroadcastDims(int[] reduceDimensions, int rank) {
        int[] out = new int[rank - reduceDimensions.length];
        int outPos = 0;
        for (int i = 0; i < rank; ++i) {
            if (ArrayUtils.contains((int[])reduceDimensions, (int)i)) continue;
            out[outPos++] = i;
        }
        return out;
    }

    public BaseConstraint(Set<String> params, double epsilon, int[] dimensions) {
        this.params = params;
        this.epsilon = epsilon;
        this.dimensions = dimensions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseConstraint)) {
            return false;
        }
        BaseConstraint other = (BaseConstraint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getEpsilon(), other.getEpsilon()) != 0) {
            return false;
        }
        Set<String> this$params = this.getParams();
        Set<String> other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        return Arrays.equals(this.getDimensions(), other.getDimensions());
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseConstraint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $epsilon = Double.doubleToLongBits(this.getEpsilon());
        result = result * 59 + (int)($epsilon >>> 32 ^ $epsilon);
        Set<String> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        result = result * 59 + Arrays.hashCode(this.getDimensions());
        return result;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public void setDimensions(int[] dimensions) {
        this.dimensions = dimensions;
    }

    public String toString() {
        return "BaseConstraint(params=" + this.getParams() + ", epsilon=" + this.getEpsilon() + ", dimensions=" + Arrays.toString(this.getDimensions()) + ")";
    }

    @Override
    public void setParams(Set<String> params) {
        this.params = params;
    }

    @Override
    public Set<String> getParams() {
        return this.params;
    }
}

