/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.samediff;

import org.nd4j.autodiff.samediff.internal.memory.AbstractMemoryMgr;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.memory.conf.WorkspaceConfiguration;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.factory.Nd4j;

public class DL4JSameDiffMemoryMgr
extends AbstractMemoryMgr {
    private final String workingMemoryWs;
    private final String outputWs;
    private final WorkspaceConfiguration confWorking;
    private final WorkspaceConfiguration confOutput;

    public DL4JSameDiffMemoryMgr(String workingMemoryWs, String outputWs, WorkspaceConfiguration confWorking, WorkspaceConfiguration confOutput) {
        this.workingMemoryWs = workingMemoryWs;
        this.outputWs = outputWs;
        this.confWorking = confWorking;
        this.confOutput = confOutput;
    }

    public INDArray allocate(boolean detached, DataType dataType, long ... shape) {
        WorkspaceConfiguration wsConf;
        String wsName = detached ? this.outputWs : this.workingMemoryWs;
        WorkspaceConfiguration workspaceConfiguration = wsConf = detached ? this.confOutput : this.confWorking;
        if (wsName == null) {
            INDArray ret = Nd4j.createUninitializedDetached((DataType)dataType, (long[])shape);
            Preconditions.checkState((!ret.isAttached() ? 1 : 0) != 0, (String)"Returned array should be detached");
            return ret;
        }
        MemoryWorkspace ws = Nd4j.getWorkspaceManager().getWorkspaceForCurrentThread(wsConf, wsName);
        try (MemoryWorkspace mw = ws.notifyScopeBorrowed();){
            INDArray iNDArray = Nd4j.createUninitialized((DataType)dataType, (long[])shape);
            return iNDArray;
        }
    }

    public INDArray allocate(boolean detached, LongShapeDescriptor descriptor) {
        if (descriptor.isEmpty()) {
            INDArray ret = Nd4j.create((LongShapeDescriptor)descriptor);
            if (detached) {
                ret = ret.detach();
            }
            return ret;
        }
        return this.allocate(detached, descriptor.dataType(), descriptor.getShape());
    }

    public void release(INDArray array) {
    }

    public void close() {
    }
}

