/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.convolutional.Cropping1D;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.AbstractLayer;
import org.deeplearning4j.nn.layers.convolution.Cropping2DLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class Cropping1DLayer
extends AbstractLayer<Cropping1D> {
    private int[] cropping;

    public Cropping1DLayer(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
        this.cropping = ((Cropping1D)conf.getLayer()).getCropping();
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public void clearNoiseWeightParams() {
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.CONVOLUTIONAL;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        long[] inShape = this.input.shape();
        INDArray epsNext = workspaceMgr.create(ArrayType.ACTIVATION_GRAD, this.dataType, inShape, 'c');
        INDArray epsNextSubset = epsNext.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval((long)this.cropping[0], (long)(epsNext.size(2) - (long)this.cropping[1]))});
        epsNextSubset.assign(epsilon);
        return new Pair((Object)new DefaultGradient(), (Object)epsNext);
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        return this.inputSubset(this.input, ArrayType.ACTIVATIONS, workspaceMgr);
    }

    public Layer clone() {
        return new Cropping2DLayer(this.conf.clone(), this.dataType);
    }

    @Override
    public double calcRegularizationScore(boolean backpropParamsOnly) {
        return 0.0;
    }

    private INDArray inputSubset(INDArray from, ArrayType arrayType, LayerWorkspaceMgr workspaceMgr) {
        try (MemoryWorkspace ws = workspaceMgr.notifyScopeBorrowed(arrayType);){
            if (from.dataType() == this.dataType) {
                INDArray iNDArray = from.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval((long)this.cropping[0], (long)(from.size(2) - (long)this.cropping[1]))}).dup(from.ordering());
                return iNDArray;
            }
            INDArray iNDArray = from.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval((long)this.cropping[0], (long)(from.size(2) - (long)this.cropping[1]))}).castTo(this.dataType);
            return iNDArray;
        }
    }
}

