/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.serde;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.graph.LayerVertex;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.serde.BaseNetConfigDeserializer;
import org.nd4j.shade.jackson.core.JsonParser;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.nd4j.shade.jackson.databind.DeserializationContext;
import org.nd4j.shade.jackson.databind.JsonDeserializer;

public class ComputationGraphConfigurationDeserializer
extends BaseNetConfigDeserializer<ComputationGraphConfiguration> {
    public ComputationGraphConfigurationDeserializer(JsonDeserializer<?> defaultDeserializer) {
        super(defaultDeserializer, ComputationGraphConfiguration.class);
    }

    @Override
    public ComputationGraphConfiguration deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ComputationGraphConfiguration conf = (ComputationGraphConfiguration)this.defaultDeserializer.deserialize(jp, ctxt);
        ArrayList<Layer> layerList = new ArrayList<Layer>();
        Map<String, GraphVertex> vertices = conf.getVertices();
        for (Map.Entry<String, GraphVertex> entry : vertices.entrySet()) {
            if (!(entry.getValue() instanceof LayerVertex)) continue;
            LayerVertex lv = (LayerVertex)entry.getValue();
            layerList.add(lv.getLayerConf().getLayer());
        }
        Layer[] layers = layerList.toArray(new Layer[layerList.size()]);
        this.handleUpdaterBackwardCompatibility(layers);
        return conf;
    }
}

