/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.params.EmptyParamInitializer;
import org.deeplearning4j.optimize.api.IterationListener;
import org.nd4j.linalg.api.ndarray.INDArray;

public class ZeroPaddingLayer
extends Layer {
    private int[] padding;

    private ZeroPaddingLayer(Builder builder) {
        super(builder);
        this.padding = builder.padding;
    }

    @Override
    public org.deeplearning4j.nn.api.Layer instantiate(NeuralNetConfiguration conf, Collection<IterationListener> iterationListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        org.deeplearning4j.nn.layers.convolution.ZeroPaddingLayer ret = new org.deeplearning4j.nn.layers.convolution.ZeroPaddingLayer(conf);
        ret.setListeners(iterationListeners);
        ret.setIndex(layerIndex);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return EmptyParamInitializer.getInstance();
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        int inDepth;
        int inW;
        int inH;
        InputType conv;
        if (inputType instanceof InputType.InputTypeConvolutional) {
            conv = (InputType.InputTypeConvolutional)inputType;
            inH = ((InputType.InputTypeConvolutional)conv).getHeight();
            inW = ((InputType.InputTypeConvolutional)conv).getWidth();
            inDepth = ((InputType.InputTypeConvolutional)conv).getDepth();
        } else if (inputType instanceof InputType.InputTypeConvolutionalFlat) {
            conv = (InputType.InputTypeConvolutionalFlat)inputType;
            inH = ((InputType.InputTypeConvolutionalFlat)conv).getHeight();
            inW = ((InputType.InputTypeConvolutionalFlat)conv).getWidth();
            inDepth = ((InputType.InputTypeConvolutionalFlat)conv).getDepth();
        } else {
            throw new IllegalStateException("Invalid input type: expected InputTypeConvolutional or InputTypeConvolutionalFlat. Got: " + inputType);
        }
        int outH = inH + this.padding[0] + this.padding[1];
        int outW = inW + this.padding[2] + this.padding[3];
        return InputType.convolutional(outH, outW, inDepth);
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for ZeroPaddingLayer layer (layer name=\"" + this.getLayerName() + "\"): input is null");
        }
        return InputTypeUtil.getPreProcessorForInputTypeCnnLayers(inputType, this.getLayerName());
    }

    @Override
    public double getL1ByParam(String paramName) {
        return 0.0;
    }

    @Override
    public double getL2ByParam(String paramName) {
        return 0.0;
    }

    @Override
    public double getLearningRateByParam(String paramName) {
        return 0.0;
    }

    @Override
    public boolean isPretrainParam(String paramName) {
        throw new UnsupportedOperationException("ZeroPaddingLayer does not contain parameters");
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        InputType outputType = this.getOutputType(-1, inputType);
        return new LayerMemoryReport.Builder(this.layerName, ZeroPaddingLayer.class, inputType, outputType).standardMemory(0L, 0L).workingMemory(0L, 0L, MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    public int[] getPadding() {
        return this.padding;
    }

    public void setPadding(int[] padding) {
        this.padding = padding;
    }

    @Override
    public String toString() {
        return "ZeroPaddingLayer(padding=" + Arrays.toString(this.getPadding()) + ")";
    }

    public ZeroPaddingLayer() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZeroPaddingLayer)) {
            return false;
        }
        ZeroPaddingLayer other = (ZeroPaddingLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.equals(this.getPadding(), other.getPadding());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ZeroPaddingLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getPadding());
        return result;
    }

    public static class Builder
    extends Layer.Builder<Builder> {
        private int[] padding = new int[]{0, 0, 0, 0};

        public Builder(int padHeight, int padWidth) {
            this(padHeight, padHeight, padWidth, padWidth);
        }

        public Builder(int padTop, int padBottom, int padLeft, int padRight) {
            this(new int[]{padTop, padBottom, padLeft, padRight});
        }

        public Builder(int[] padding) {
            this.padding = padding;
        }

        @Override
        public ZeroPaddingLayer build() {
            for (int p : this.padding) {
                if (p >= 0) continue;
                throw new IllegalStateException("Invalid zero padding layer config: padding [top, bottom, left, right] must be > 0 for all elements. Got: " + Arrays.toString(this.padding));
            }
            return new ZeroPaddingLayer(this);
        }
    }
}

