/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.LearningRatePolicy;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.params.ConvolutionParamInitializer;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.util.ConvolutionUtils;
import org.deeplearning4j.util.LayerValidation;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.api.ndarray.INDArray;

public class ConvolutionLayer
extends FeedForwardLayer {
    protected ConvolutionMode convolutionMode = ConvolutionMode.Truncate;
    protected int[] kernelSize;
    protected int[] stride;
    protected int[] padding;
    protected AlgoMode cudnnAlgoMode = AlgoMode.PREFER_FASTEST;
    protected FwdAlgo cudnnFwdAlgo;
    protected BwdFilterAlgo cudnnBwdFilterAlgo;
    protected BwdDataAlgo cudnnBwdDataAlgo;

    protected ConvolutionLayer(BaseConvBuilder<?> builder) {
        super(builder);
        this.convolutionMode = builder.convolutionMode;
        if (builder.kernelSize.length != 2) {
            throw new IllegalArgumentException("Kernel size of should be rows x columns (a 2d array)");
        }
        this.kernelSize = builder.kernelSize;
        if (builder.stride.length != 2) {
            throw new IllegalArgumentException("Stride should include stride for rows and columns (a 2d array)");
        }
        this.stride = builder.stride;
        if (builder.padding.length != 2) {
            throw new IllegalArgumentException("Padding should include padding for rows and columns (a 2d array)");
        }
        this.padding = builder.padding;
        this.cudnnAlgoMode = builder.cudnnAlgoMode;
        this.cudnnFwdAlgo = builder.cudnnFwdAlgo;
        this.cudnnBwdFilterAlgo = builder.cudnnBwdFilterAlgo;
        this.cudnnBwdDataAlgo = builder.cudnnBwdDataAlgo;
    }

    @Override
    public ConvolutionLayer clone() {
        ConvolutionLayer clone = (ConvolutionLayer)super.clone();
        if (clone.kernelSize != null) {
            clone.kernelSize = (int[])clone.kernelSize.clone();
        }
        if (clone.stride != null) {
            clone.stride = (int[])clone.stride.clone();
        }
        if (clone.padding != null) {
            clone.padding = (int[])clone.padding.clone();
        }
        return clone;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<IterationListener> iterationListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        LayerValidation.assertNInNOutSet("ConvolutionLayer", this.getLayerName(), layerIndex, this.getNIn(), this.getNOut());
        org.deeplearning4j.nn.layers.convolution.ConvolutionLayer ret = new org.deeplearning4j.nn.layers.convolution.ConvolutionLayer(conf);
        ret.setListeners(iterationListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return ConvolutionParamInitializer.getInstance();
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN) {
            throw new IllegalStateException("Invalid input for Convolution layer (layer name=\"" + this.getLayerName() + "\"): Expected CNN input, got " + inputType);
        }
        return InputTypeUtil.getOutputTypeCnnLayers(inputType, this.kernelSize, this.stride, this.padding, this.convolutionMode, this.nOut, layerIndex, this.getLayerName(), ConvolutionLayer.class);
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN) {
            throw new IllegalStateException("Invalid input for Convolution layer (layer name=\"" + this.getLayerName() + "\"): Expected CNN input, got " + inputType);
        }
        if (this.nIn <= 0 || override) {
            InputType.InputTypeConvolutional c = (InputType.InputTypeConvolutional)inputType;
            this.nIn = c.getDepth();
        }
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for Convolution layer (layer name=\"" + this.getLayerName() + "\"): input is null");
        }
        return InputTypeUtil.getPreProcessorForInputTypeCnnLayers(inputType, this.getLayerName());
    }

    @Override
    public double getL1ByParam(String paramName) {
        switch (paramName) {
            case "W": {
                return this.l1;
            }
            case "b": {
                return this.l1Bias;
            }
        }
        throw new IllegalArgumentException("Unknown parameter name: \"" + paramName + "\"");
    }

    @Override
    public double getL2ByParam(String paramName) {
        switch (paramName) {
            case "W": {
                return this.l2;
            }
            case "b": {
                return this.l2Bias;
            }
        }
        throw new IllegalArgumentException("Unknown parameter name: \"" + paramName + "\"");
    }

    @Override
    public double getLearningRateByParam(String paramName) {
        switch (paramName) {
            case "W": {
                return this.learningRate;
            }
            case "b": {
                if (!Double.isNaN(this.biasLearningRate)) {
                    return this.biasLearningRate;
                }
                return this.learningRate;
            }
        }
        throw new IllegalArgumentException("Unknown parameter name: \"" + paramName + "\"");
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        int paramSize = this.initializer().numParams(this);
        int updaterStateSize = (int)this.getIUpdater().stateSize((long)paramSize);
        InputType.InputTypeConvolutional c = (InputType.InputTypeConvolutional)inputType;
        InputType.InputTypeConvolutional outputType = (InputType.InputTypeConvolutional)this.getOutputType(-1, inputType);
        int im2colSizePerEx = c.getDepth() * outputType.getHeight() * outputType.getWidth() * this.kernelSize[0] * this.kernelSize[1];
        HashMap<CacheMode, Long> trainWorkingMemoryPerEx = new HashMap<CacheMode, Long>();
        HashMap<CacheMode, Long> cachedPerEx = new HashMap<CacheMode, Long>();
        for (CacheMode cm : CacheMode.values()) {
            long trainWorkingSizePerEx;
            long cacheMemSizePerEx = 0L;
            if (cm == CacheMode.NONE) {
                trainWorkingSizePerEx = 2 * im2colSizePerEx;
            } else {
                cacheMemSizePerEx = im2colSizePerEx;
                trainWorkingSizePerEx = im2colSizePerEx;
            }
            if (this.getDropOut() > 0.0) {
                trainWorkingSizePerEx += (long)inputType.arrayElementsPerExample();
            }
            trainWorkingMemoryPerEx.put(cm, trainWorkingSizePerEx);
            cachedPerEx.put(cm, cacheMemSizePerEx);
        }
        return new LayerMemoryReport.Builder(this.layerName, ConvolutionLayer.class, inputType, outputType).standardMemory(paramSize, updaterStateSize).workingMemory(0L, (long)im2colSizePerEx, MemoryReport.CACHE_MODE_ALL_ZEROS, trainWorkingMemoryPerEx).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, cachedPerEx).build();
    }

    public ConvolutionMode getConvolutionMode() {
        return this.convolutionMode;
    }

    public int[] getKernelSize() {
        return this.kernelSize;
    }

    public int[] getStride() {
        return this.stride;
    }

    public int[] getPadding() {
        return this.padding;
    }

    public AlgoMode getCudnnAlgoMode() {
        return this.cudnnAlgoMode;
    }

    public FwdAlgo getCudnnFwdAlgo() {
        return this.cudnnFwdAlgo;
    }

    public BwdFilterAlgo getCudnnBwdFilterAlgo() {
        return this.cudnnBwdFilterAlgo;
    }

    public BwdDataAlgo getCudnnBwdDataAlgo() {
        return this.cudnnBwdDataAlgo;
    }

    public void setConvolutionMode(ConvolutionMode convolutionMode) {
        this.convolutionMode = convolutionMode;
    }

    public void setKernelSize(int[] kernelSize) {
        this.kernelSize = kernelSize;
    }

    public void setStride(int[] stride) {
        this.stride = stride;
    }

    public void setPadding(int[] padding) {
        this.padding = padding;
    }

    public void setCudnnAlgoMode(AlgoMode cudnnAlgoMode) {
        this.cudnnAlgoMode = cudnnAlgoMode;
    }

    public void setCudnnFwdAlgo(FwdAlgo cudnnFwdAlgo) {
        this.cudnnFwdAlgo = cudnnFwdAlgo;
    }

    public void setCudnnBwdFilterAlgo(BwdFilterAlgo cudnnBwdFilterAlgo) {
        this.cudnnBwdFilterAlgo = cudnnBwdFilterAlgo;
    }

    public void setCudnnBwdDataAlgo(BwdDataAlgo cudnnBwdDataAlgo) {
        this.cudnnBwdDataAlgo = cudnnBwdDataAlgo;
    }

    public ConvolutionLayer() {
    }

    @Override
    public String toString() {
        return "ConvolutionLayer(super=" + super.toString() + ", convolutionMode=" + (Object)((Object)this.getConvolutionMode()) + ", kernelSize=" + Arrays.toString(this.getKernelSize()) + ", stride=" + Arrays.toString(this.getStride()) + ", padding=" + Arrays.toString(this.getPadding()) + ", cudnnAlgoMode=" + (Object)((Object)this.getCudnnAlgoMode()) + ", cudnnFwdAlgo=" + (Object)((Object)this.getCudnnFwdAlgo()) + ", cudnnBwdFilterAlgo=" + (Object)((Object)this.getCudnnBwdFilterAlgo()) + ", cudnnBwdDataAlgo=" + (Object)((Object)this.getCudnnBwdDataAlgo()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConvolutionLayer)) {
            return false;
        }
        ConvolutionLayer other = (ConvolutionLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConvolutionMode this$convolutionMode = this.getConvolutionMode();
        ConvolutionMode other$convolutionMode = other.getConvolutionMode();
        if (this$convolutionMode == null ? other$convolutionMode != null : !((Object)((Object)this$convolutionMode)).equals((Object)other$convolutionMode)) {
            return false;
        }
        if (!Arrays.equals(this.getKernelSize(), other.getKernelSize())) {
            return false;
        }
        if (!Arrays.equals(this.getStride(), other.getStride())) {
            return false;
        }
        if (!Arrays.equals(this.getPadding(), other.getPadding())) {
            return false;
        }
        AlgoMode this$cudnnAlgoMode = this.getCudnnAlgoMode();
        AlgoMode other$cudnnAlgoMode = other.getCudnnAlgoMode();
        if (this$cudnnAlgoMode == null ? other$cudnnAlgoMode != null : !((Object)((Object)this$cudnnAlgoMode)).equals((Object)other$cudnnAlgoMode)) {
            return false;
        }
        FwdAlgo this$cudnnFwdAlgo = this.getCudnnFwdAlgo();
        FwdAlgo other$cudnnFwdAlgo = other.getCudnnFwdAlgo();
        if (this$cudnnFwdAlgo == null ? other$cudnnFwdAlgo != null : !((Object)((Object)this$cudnnFwdAlgo)).equals((Object)other$cudnnFwdAlgo)) {
            return false;
        }
        BwdFilterAlgo this$cudnnBwdFilterAlgo = this.getCudnnBwdFilterAlgo();
        BwdFilterAlgo other$cudnnBwdFilterAlgo = other.getCudnnBwdFilterAlgo();
        if (this$cudnnBwdFilterAlgo == null ? other$cudnnBwdFilterAlgo != null : !((Object)((Object)this$cudnnBwdFilterAlgo)).equals((Object)other$cudnnBwdFilterAlgo)) {
            return false;
        }
        BwdDataAlgo this$cudnnBwdDataAlgo = this.getCudnnBwdDataAlgo();
        BwdDataAlgo other$cudnnBwdDataAlgo = other.getCudnnBwdDataAlgo();
        return !(this$cudnnBwdDataAlgo == null ? other$cudnnBwdDataAlgo != null : !((Object)((Object)this$cudnnBwdDataAlgo)).equals((Object)other$cudnnBwdDataAlgo));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ConvolutionLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        ConvolutionMode $convolutionMode = this.getConvolutionMode();
        result = result * 59 + ($convolutionMode == null ? 43 : ((Object)((Object)$convolutionMode)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getKernelSize());
        result = result * 59 + Arrays.hashCode(this.getStride());
        result = result * 59 + Arrays.hashCode(this.getPadding());
        AlgoMode $cudnnAlgoMode = this.getCudnnAlgoMode();
        result = result * 59 + ($cudnnAlgoMode == null ? 43 : ((Object)((Object)$cudnnAlgoMode)).hashCode());
        FwdAlgo $cudnnFwdAlgo = this.getCudnnFwdAlgo();
        result = result * 59 + ($cudnnFwdAlgo == null ? 43 : ((Object)((Object)$cudnnFwdAlgo)).hashCode());
        BwdFilterAlgo $cudnnBwdFilterAlgo = this.getCudnnBwdFilterAlgo();
        result = result * 59 + ($cudnnBwdFilterAlgo == null ? 43 : ((Object)((Object)$cudnnBwdFilterAlgo)).hashCode());
        BwdDataAlgo $cudnnBwdDataAlgo = this.getCudnnBwdDataAlgo();
        result = result * 59 + ($cudnnBwdDataAlgo == null ? 43 : ((Object)((Object)$cudnnBwdDataAlgo)).hashCode());
        return result;
    }

    protected static abstract class BaseConvBuilder<T extends BaseConvBuilder<T>>
    extends FeedForwardLayer.Builder<T> {
        protected ConvolutionMode convolutionMode = null;
        protected int[] kernelSize = new int[]{5, 5};
        protected int[] stride = new int[]{1, 1};
        protected int[] padding = new int[]{0, 0};
        protected AlgoMode cudnnAlgoMode = AlgoMode.PREFER_FASTEST;
        protected FwdAlgo cudnnFwdAlgo;
        protected BwdFilterAlgo cudnnBwdFilterAlgo;
        protected BwdDataAlgo cudnnBwdDataAlgo;

        protected BaseConvBuilder(int[] kernelSize, int[] stride, int[] padding) {
            this.kernelSize = kernelSize;
            this.stride = stride;
            this.padding = padding;
        }

        protected BaseConvBuilder(int[] kernelSize, int[] stride) {
            this.kernelSize = kernelSize;
            this.stride = stride;
        }

        protected BaseConvBuilder(int ... kernelSize) {
            this.kernelSize = kernelSize;
        }

        protected BaseConvBuilder() {
        }

        public T convolutionMode(ConvolutionMode convolutionMode) {
            this.convolutionMode = convolutionMode;
            return (T)this;
        }

        public T cudnnAlgoMode(AlgoMode cudnnAlgoMode) {
            this.cudnnAlgoMode = cudnnAlgoMode;
            return (T)this;
        }

        public T cudnnFwdMode(FwdAlgo cudnnFwdAlgo) {
            this.cudnnFwdAlgo = cudnnFwdAlgo;
            return (T)this;
        }

        public T cudnnBwdFilterMode(BwdFilterAlgo cudnnBwdFilterAlgo) {
            this.cudnnBwdFilterAlgo = cudnnBwdFilterAlgo;
            return (T)this;
        }

        public T cudnnBwdDataMode(BwdDataAlgo cudnnBwdDataAlgo) {
            this.cudnnBwdDataAlgo = cudnnBwdDataAlgo;
            return (T)this;
        }
    }

    public static class Builder
    extends BaseConvBuilder<Builder> {
        public Builder(int[] kernelSize, int[] stride, int[] padding) {
            super(kernelSize, stride, padding);
        }

        public Builder(int[] kernelSize, int[] stride) {
            super(kernelSize, stride);
        }

        public Builder(int ... kernelSize) {
            super(kernelSize);
        }

        public Builder() {
        }

        @Override
        public Builder convolutionMode(ConvolutionMode convolutionMode) {
            this.convolutionMode = convolutionMode;
            return this;
        }

        @Override
        public Builder nIn(int nIn) {
            super.nIn(nIn);
            return this;
        }

        @Override
        public Builder nOut(int nOut) {
            super.nOut(nOut);
            return this;
        }

        @Override
        public Builder cudnnAlgoMode(AlgoMode cudnnAlgoMode) {
            super.cudnnAlgoMode(cudnnAlgoMode);
            return this;
        }

        @Override
        public Builder name(String layerName) {
            super.name(layerName);
            return this;
        }

        @Override
        public Builder activation(IActivation activationFunction) {
            super.activation(activationFunction);
            return this;
        }

        @Override
        public Builder activation(Activation activation) {
            super.activation(activation);
            return this;
        }

        @Override
        public Builder weightInit(WeightInit weightInit) {
            super.weightInit(weightInit);
            return this;
        }

        @Override
        public Builder biasInit(double biasInit) {
            super.biasInit(biasInit);
            return this;
        }

        @Override
        public Builder dist(Distribution dist) {
            super.dist(dist);
            return this;
        }

        @Override
        public Builder learningRate(double learningRate) {
            return (Builder)super.learningRate(learningRate);
        }

        @Override
        public Builder biasLearningRate(double biasLearningRate) {
            return (Builder)super.biasLearningRate(biasLearningRate);
        }

        @Override
        public Builder learningRateSchedule(Map<Integer, Double> learningRateSchedule) {
            return (Builder)super.learningRateSchedule(learningRateSchedule);
        }

        @Override
        public Builder l1(double l1) {
            return (Builder)super.l1(l1);
        }

        @Override
        public Builder l2(double l2) {
            return (Builder)super.l2(l2);
        }

        @Override
        public Builder l1Bias(double l1Bias) {
            return (Builder)super.l1Bias(l1Bias);
        }

        @Override
        public Builder l2Bias(double l2Bias) {
            return (Builder)super.l2Bias(l2Bias);
        }

        @Override
        public Builder dropOut(double dropOut) {
            return (Builder)super.dropOut(dropOut);
        }

        @Override
        public Builder momentum(double momentum) {
            return (Builder)super.momentum(momentum);
        }

        @Override
        public Builder momentumAfter(Map<Integer, Double> momentumAfter) {
            return (Builder)super.momentumAfter(momentumAfter);
        }

        @Override
        public Builder updater(Updater updater) {
            return (Builder)super.updater(updater);
        }

        @Override
        public Builder rho(double rho) {
            return (Builder)super.rho(rho);
        }

        @Override
        public Builder rmsDecay(double rmsDecay) {
            return (Builder)super.rmsDecay(rmsDecay);
        }

        @Override
        public Builder epsilon(double epsilon) {
            return (Builder)super.epsilon(epsilon);
        }

        @Override
        public Builder adamMeanDecay(double adamMeanDecay) {
            return (Builder)super.adamMeanDecay(adamMeanDecay);
        }

        @Override
        public Builder adamVarDecay(double adamVarDecay) {
            super.adamVarDecay(adamVarDecay);
            return this;
        }

        @Override
        public Builder gradientNormalization(GradientNormalization gradientNormalization) {
            super.gradientNormalization(gradientNormalization);
            return this;
        }

        @Override
        public Builder gradientNormalizationThreshold(double threshold) {
            super.gradientNormalizationThreshold(threshold);
            return this;
        }

        @Override
        public Builder learningRateDecayPolicy(LearningRatePolicy policy) {
            super.learningRateDecayPolicy(policy);
            return this;
        }

        public Builder kernelSize(int ... kernelSize) {
            this.kernelSize = kernelSize;
            return this;
        }

        public Builder stride(int ... stride) {
            this.stride = stride;
            return this;
        }

        public Builder padding(int ... padding) {
            this.padding = padding;
            return this;
        }

        @Override
        public ConvolutionLayer build() {
            ConvolutionUtils.validateCnnKernelStridePadding(this.kernelSize, this.stride, this.padding);
            return new ConvolutionLayer(this);
        }
    }

    public static enum BwdDataAlgo {
        ALGO_0,
        ALGO_1,
        FFT,
        FFT_TILING,
        WINOGRAD,
        WINOGRAD_NONFUSED,
        COUNT;

    }

    public static enum BwdFilterAlgo {
        ALGO_0,
        ALGO_1,
        FFT,
        ALGO_3,
        WINOGRAD,
        WINOGRAD_NONFUSED,
        FFT_TILING,
        COUNT;

    }

    public static enum FwdAlgo {
        IMPLICIT_GEMM,
        IMPLICIT_PRECOMP_GEMM,
        GEMM,
        DIRECT,
        FFT,
        FFT_TILING,
        WINOGRAD,
        WINOGRAD_NONFUSED,
        COUNT;

    }

    public static enum AlgoMode {
        NO_WORKSPACE,
        PREFER_FASTEST,
        USER_SPECIFIED;

    }
}

