/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.listeners;

import java.util.concurrent.atomic.AtomicLong;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.optimize.api.IterationListener;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceListener
implements IterationListener {
    private final int frequency;
    private static final Logger logger = LoggerFactory.getLogger(PerformanceListener.class);
    private double samplesPerSec = 0.0;
    private double batchesPerSec = 0.0;
    private long lastTime;
    private AtomicLong iterationCount = new AtomicLong(0L);
    private boolean reportScore;
    private boolean reportSample = true;
    private boolean reportBatch = true;
    private boolean reportIteration = true;
    private boolean reportTime = true;

    public PerformanceListener(int frequency) {
        this(frequency, false);
    }

    public PerformanceListener(int frequency, boolean reportScore) {
        this.frequency = frequency;
        this.reportScore = reportScore;
        this.lastTime = System.currentTimeMillis();
    }

    @Override
    public boolean invoked() {
        return false;
    }

    @Override
    public void invoke() {
    }

    @Override
    public void iterationDone(Model model, int iteration) {
        if (this.iterationCount.getAndIncrement() % (long)this.frequency == 0L) {
            long currentTime = System.currentTimeMillis();
            long timeSpent = currentTime - this.lastTime;
            float timeSec = (float)timeSpent / 1000.0f;
            INDArray input = model.input();
            long tadLength = Shape.getTADLength((int[])input.shape(), (int[])ArrayUtil.range((int)1, (int)input.rank()));
            long numSamples = input.lengthLong() / tadLength;
            this.samplesPerSec = (float)numSamples / timeSec;
            this.batchesPerSec = 1.0f / timeSec;
            StringBuilder builder = new StringBuilder();
            if (this.reportIteration) {
                builder.append("iteration ").append(this.iterationCount.get()).append("; ");
            }
            if (this.reportTime) {
                builder.append("iteration time: ").append(timeSpent).append(" ms; ");
            }
            if (this.reportSample) {
                builder.append("samples/sec: ").append(String.format("%.3f", this.samplesPerSec)).append("; ");
            }
            if (this.reportBatch) {
                builder.append("batches/sec: ").append(String.format("%.3f", this.batchesPerSec)).append("; ");
            }
            if (this.reportScore) {
                builder.append("score: ").append(model.score()).append(";");
            }
            logger.info(builder.toString());
        }
        this.lastTime = System.currentTimeMillis();
    }

    public static class Builder {
        private int frequency = 1;
        private boolean reportScore;
        private boolean reportSample = true;
        private boolean reportBatch = true;
        private boolean reportIteration = true;
        private boolean reportTime = true;

        public Builder reportIteration(boolean reallyReport) {
            this.reportIteration = reallyReport;
            return this;
        }

        public Builder reportTime(boolean reallyReport) {
            this.reportTime = reallyReport;
            return this;
        }

        public Builder reportSample(boolean reallyReport) {
            this.reportSample = reallyReport;
            return this;
        }

        public Builder reportBatch(boolean reallyReport) {
            this.reportBatch = reallyReport;
            return this;
        }

        public Builder reportScore(boolean reallyReport) {
            this.reportScore = reallyReport;
            return this;
        }

        public Builder setFrequency(int frequency) {
            this.frequency = frequency;
            return this;
        }

        public PerformanceListener build() {
            PerformanceListener listener = new PerformanceListener(this.frequency, this.reportScore);
            listener.reportIteration = this.reportIteration;
            listener.reportTime = this.reportTime;
            listener.reportBatch = this.reportBatch;
            listener.reportSample = this.reportSample;
            return listener;
        }
    }
}

