/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers.variational;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.BasePretrainNetwork;
import org.deeplearning4j.nn.conf.layers.variational.GaussianReconstructionDistribution;
import org.deeplearning4j.nn.conf.layers.variational.LossFunctionWrapper;
import org.deeplearning4j.nn.conf.layers.variational.ReconstructionDistribution;
import org.deeplearning4j.nn.params.VariationalAutoencoderParamInitializer;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.util.LayerValidation;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.activations.impl.ActivationIdentity;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class VariationalAutoencoder
extends BasePretrainNetwork {
    private int[] encoderLayerSizes;
    private int[] decoderLayerSizes;
    private ReconstructionDistribution outputDistribution;
    private IActivation pzxActivationFn;
    private int numSamples;

    private VariationalAutoencoder(Builder builder) {
        super(builder);
        this.encoderLayerSizes = builder.encoderLayerSizes;
        this.decoderLayerSizes = builder.decoderLayerSizes;
        this.outputDistribution = builder.outputDistribution;
        this.pzxActivationFn = builder.pzxActivationFn;
        this.numSamples = builder.numSamples;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<IterationListener> iterationListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        LayerValidation.assertNInNOutSet("VariationalAutoencoder", this.getLayerName(), layerIndex, this.getNIn(), this.getNOut());
        org.deeplearning4j.nn.layers.variational.VariationalAutoencoder ret = new org.deeplearning4j.nn.layers.variational.VariationalAutoencoder(conf);
        ret.setListeners(iterationListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return VariationalAutoencoderParamInitializer.getInstance();
    }

    @Override
    public double getLearningRateByParam(String paramName) {
        if (paramName.endsWith("b")) {
            if (!Double.isNaN(this.biasLearningRate)) {
                return this.biasLearningRate;
            }
            return this.learningRate;
        }
        return this.learningRate;
    }

    @Override
    public double getL1ByParam(String paramName) {
        if (paramName.endsWith("b")) {
            return 0.0;
        }
        return this.l1;
    }

    @Override
    public double getL2ByParam(String paramName) {
        if (paramName.endsWith("b")) {
            return 0.0;
        }
        return this.l2;
    }

    public int[] getEncoderLayerSizes() {
        return this.encoderLayerSizes;
    }

    public int[] getDecoderLayerSizes() {
        return this.decoderLayerSizes;
    }

    public ReconstructionDistribution getOutputDistribution() {
        return this.outputDistribution;
    }

    public IActivation getPzxActivationFn() {
        return this.pzxActivationFn;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setEncoderLayerSizes(int[] encoderLayerSizes) {
        this.encoderLayerSizes = encoderLayerSizes;
    }

    public void setDecoderLayerSizes(int[] decoderLayerSizes) {
        this.decoderLayerSizes = decoderLayerSizes;
    }

    public void setOutputDistribution(ReconstructionDistribution outputDistribution) {
        this.outputDistribution = outputDistribution;
    }

    public void setPzxActivationFn(IActivation pzxActivationFn) {
        this.pzxActivationFn = pzxActivationFn;
    }

    public void setNumSamples(int numSamples) {
        this.numSamples = numSamples;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VariationalAutoencoder)) {
            return false;
        }
        VariationalAutoencoder other = (VariationalAutoencoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getEncoderLayerSizes(), other.getEncoderLayerSizes())) {
            return false;
        }
        if (!Arrays.equals(this.getDecoderLayerSizes(), other.getDecoderLayerSizes())) {
            return false;
        }
        ReconstructionDistribution this$outputDistribution = this.getOutputDistribution();
        ReconstructionDistribution other$outputDistribution = other.getOutputDistribution();
        if (this$outputDistribution == null ? other$outputDistribution != null : !this$outputDistribution.equals(other$outputDistribution)) {
            return false;
        }
        IActivation this$pzxActivationFn = this.getPzxActivationFn();
        IActivation other$pzxActivationFn = other.getPzxActivationFn();
        if (this$pzxActivationFn == null ? other$pzxActivationFn != null : !this$pzxActivationFn.equals(other$pzxActivationFn)) {
            return false;
        }
        return this.getNumSamples() == other.getNumSamples();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VariationalAutoencoder;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getEncoderLayerSizes());
        result = result * 59 + Arrays.hashCode(this.getDecoderLayerSizes());
        ReconstructionDistribution $outputDistribution = this.getOutputDistribution();
        result = result * 59 + ($outputDistribution == null ? 43 : $outputDistribution.hashCode());
        IActivation $pzxActivationFn = this.getPzxActivationFn();
        result = result * 59 + ($pzxActivationFn == null ? 43 : $pzxActivationFn.hashCode());
        result = result * 59 + this.getNumSamples();
        return result;
    }

    @Override
    public String toString() {
        return "VariationalAutoencoder(encoderLayerSizes=" + Arrays.toString(this.getEncoderLayerSizes()) + ", decoderLayerSizes=" + Arrays.toString(this.getDecoderLayerSizes()) + ", outputDistribution=" + this.getOutputDistribution() + ", pzxActivationFn=" + this.getPzxActivationFn() + ", numSamples=" + this.getNumSamples() + ")";
    }

    public VariationalAutoencoder() {
    }

    public static class Builder
    extends BasePretrainNetwork.Builder<Builder> {
        private int[] encoderLayerSizes = new int[]{100};
        private int[] decoderLayerSizes = new int[]{100};
        private ReconstructionDistribution outputDistribution = new GaussianReconstructionDistribution("tanh");
        private IActivation pzxActivationFn = new ActivationIdentity();
        private int numSamples = 1;

        public Builder encoderLayerSizes(int ... encoderLayerSizes) {
            if (encoderLayerSizes == null || encoderLayerSizes.length < 1) {
                throw new IllegalArgumentException("Encoder layer sizes array must have length > 0");
            }
            this.encoderLayerSizes = encoderLayerSizes;
            return this;
        }

        public Builder decoderLayerSizes(int ... decoderLayerSizes) {
            if (this.encoderLayerSizes == null || this.encoderLayerSizes.length < 1) {
                throw new IllegalArgumentException("Decoder layer sizes array must have length > 0");
            }
            this.decoderLayerSizes = decoderLayerSizes;
            return this;
        }

        public Builder reconstructionDistribution(ReconstructionDistribution distribution) {
            this.outputDistribution = distribution;
            return this;
        }

        public Builder lossFunction(IActivation outputActivationFn, LossFunctions.LossFunction lossFunction) {
            return this.lossFunction(outputActivationFn, lossFunction.getILossFunction());
        }

        public Builder lossFunction(IActivation outputActivationFn, ILossFunction lossFunction) {
            return this.reconstructionDistribution(new LossFunctionWrapper(outputActivationFn, lossFunction));
        }

        public Builder pzxActivationFn(IActivation activationFunction) {
            this.pzxActivationFn = activationFunction;
            return this;
        }

        public Builder pzxActivationFunction(String activationFunction) {
            return this.pzxActivationFn(Activation.fromString((String)activationFunction).getActivationFunction());
        }

        @Override
        public Builder nOut(int nOut) {
            super.nOut(nOut);
            return this;
        }

        public Builder numSamples(int numSamples) {
            this.numSamples = numSamples;
            return this;
        }

        @Override
        public VariationalAutoencoder build() {
            return new VariationalAutoencoder(this);
        }
    }
}

