/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.terminations;

import org.deeplearning4j.optimize.api.TerminationCondition;
import org.nd4j.linalg.api.ndarray.INDArray;

public class Norm2Termination
implements TerminationCondition {
    private double gradientTolerance = 0.001;

    public Norm2Termination(double gradientTolerance) {
        this.gradientTolerance = gradientTolerance;
    }

    @Override
    public boolean terminate(double cost, double oldCost, Object[] otherParams) {
        INDArray line = (INDArray)otherParams[0];
        double norm2 = line.norm2(new int[]{Integer.MAX_VALUE}).getDouble(0);
        return norm2 < this.gradientTolerance;
    }
}

