/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.LearningRatePolicy;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.distribution.NormalDistribution;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.conf.stepfunctions.StepFunction;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.util.reflections.DL4JSubTypesScanner;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.shade.jackson.core.JsonFactory;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.nd4j.shade.jackson.databind.AnnotationIntrospector;
import org.nd4j.shade.jackson.databind.DeserializationFeature;
import org.nd4j.shade.jackson.databind.MapperFeature;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.databind.SerializationFeature;
import org.nd4j.shade.jackson.databind.cfg.MapperConfig;
import org.nd4j.shade.jackson.databind.introspect.AnnotatedClass;
import org.nd4j.shade.jackson.databind.jsontype.NamedType;
import org.nd4j.shade.jackson.dataformat.yaml.YAMLFactory;
import org.reflections.Configuration;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.Store;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeuralNetConfiguration
implements Serializable,
Cloneable {
    private static final Logger log = LoggerFactory.getLogger(NeuralNetConfiguration.class);
    public static final String CUSTOM_FUNCTIONALITY = "org.deeplearning4j.config.custom.enabled";
    protected Layer layer;
    protected double leakyreluAlpha;
    protected boolean miniBatch = true;
    protected int numIterations;
    protected int maxNumLineSearchIterations;
    protected long seed;
    protected OptimizationAlgorithm optimizationAlgo;
    protected List<String> variables = new ArrayList<String>();
    protected StepFunction stepFunction;
    protected boolean useRegularization = false;
    protected boolean useDropConnect = false;
    protected boolean minimize = true;
    protected Map<String, Double> learningRateByParam = new HashMap<String, Double>();
    protected Map<String, Double> l1ByParam = new HashMap<String, Double>();
    protected Map<String, Double> l2ByParam = new HashMap<String, Double>();
    protected LearningRatePolicy learningRatePolicy = LearningRatePolicy.None;
    protected double lrPolicyDecayRate;
    protected double lrPolicySteps;
    protected double lrPolicyPower;
    private static ObjectMapper mapper = NeuralNetConfiguration.initMapper();
    private static final ObjectMapper mapperYaml = NeuralNetConfiguration.initMapperYaml();
    private static Set<Class<?>> subtypesClassCache = null;

    public NeuralNetConfiguration clone() {
        try {
            NeuralNetConfiguration clone = (NeuralNetConfiguration)super.clone();
            if (clone.layer != null) {
                clone.layer = clone.layer.clone();
            }
            if (clone.stepFunction != null) {
                clone.stepFunction = clone.stepFunction.clone();
            }
            if (clone.variables != null) {
                clone.variables = new ArrayList<String>(clone.variables);
            }
            if (clone.learningRateByParam != null) {
                clone.learningRateByParam = new HashMap<String, Double>(clone.learningRateByParam);
            }
            if (clone.l1ByParam != null) {
                clone.l1ByParam = new HashMap<String, Double>(clone.l1ByParam);
            }
            if (clone.l2ByParam != null) {
                clone.l2ByParam = new HashMap<String, Double>(clone.l2ByParam);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> variables() {
        return new ArrayList<String>(this.variables);
    }

    public List<String> variables(boolean copy) {
        if (copy) {
            return this.variables();
        }
        return this.variables;
    }

    public void addVariable(String variable) {
        if (!this.variables.contains(variable)) {
            this.variables.add(variable);
            this.setLayerParamLR(variable);
        }
    }

    public void clearVariables() {
        this.variables.clear();
    }

    public void setLayerParamLR(String variable) {
        double l2;
        double lr = this.layer.getLearningRateByParam(variable);
        double l1 = this.layer.getL1ByParam(variable);
        if (Double.isNaN(l1)) {
            l1 = 0.0;
        }
        if (Double.isNaN(l2 = this.layer.getL2ByParam(variable))) {
            l2 = 0.0;
        }
        this.learningRateByParam.put(variable, lr);
        this.l1ByParam.put(variable, l1);
        this.l2ByParam.put(variable, l2);
    }

    public double getLearningRateByParam(String variable) {
        return this.learningRateByParam.get(variable);
    }

    public void setLearningRateByParam(String variable, double rate) {
        this.learningRateByParam.put(variable, rate);
    }

    public double getL1ByParam(String variable) {
        return this.l1ByParam.get(variable);
    }

    public double getL2ByParam(String variable) {
        return this.l2ByParam.get(variable);
    }

    public String toYaml() {
        ObjectMapper mapper = NeuralNetConfiguration.mapperYaml();
        try {
            String ret = mapper.writeValueAsString((Object)this);
            return ret;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static NeuralNetConfiguration fromYaml(String json) {
        ObjectMapper mapper = NeuralNetConfiguration.mapperYaml();
        try {
            NeuralNetConfiguration ret = (NeuralNetConfiguration)mapper.readValue(json, NeuralNetConfiguration.class);
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toJson() {
        ObjectMapper mapper = NeuralNetConfiguration.mapper();
        try {
            String ret = mapper.writeValueAsString((Object)this);
            return ret;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static NeuralNetConfiguration fromJson(String json) {
        ObjectMapper mapper = NeuralNetConfiguration.mapper();
        try {
            NeuralNetConfiguration ret = (NeuralNetConfiguration)mapper.readValue(json, NeuralNetConfiguration.class);
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ObjectMapper mapperYaml() {
        return mapperYaml;
    }

    private static ObjectMapper initMapperYaml() {
        ObjectMapper ret = new ObjectMapper((JsonFactory)new YAMLFactory());
        NeuralNetConfiguration.configureMapper(ret);
        return ret;
    }

    public static ObjectMapper mapper() {
        return mapper;
    }

    public static ObjectMapper reinitMapperWithSubtypes(Collection<NamedType> additionalTypes) {
        mapper.registerSubtypes(additionalTypes.toArray(new NamedType[additionalTypes.size()]));
        mapper = mapper.copy();
        return mapper;
    }

    private static ObjectMapper initMapper() {
        ObjectMapper ret = new ObjectMapper();
        NeuralNetConfiguration.configureMapper(ret);
        return ret;
    }

    private static void configureMapper(ObjectMapper ret) {
        ret.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ret.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        ret.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        ret.enable(SerializationFeature.INDENT_OUTPUT);
        NeuralNetConfiguration.registerSubtypes(ret);
    }

    private static synchronized void registerSubtypes(ObjectMapper mapper) {
        List<Class> classes = Arrays.asList(InputPreProcessor.class, ILossFunction.class, Layer.class, GraphVertex.class);
        ArrayList<String> classNames = new ArrayList<String>(4);
        for (Class c : classes) {
            classNames.add(c.getName());
        }
        if (subtypesClassCache == null) {
            String prop = System.getProperty(CUSTOM_FUNCTIONALITY);
            if (prop != null && !Boolean.parseBoolean(prop)) {
                subtypesClassCache = Collections.emptySet();
            } else {
                List<Class> interfaces = Arrays.asList(InputPreProcessor.class, ILossFunction.class);
                List<Class<?>> classesList = Arrays.asList(Layer.class, GraphVertex.class);
                Collection urls = ClasspathHelper.forClassLoader();
                ArrayList<URL> scanUrls = new ArrayList<URL>();
                for (URL u : urls) {
                    String path = u.getPath();
                    if (path.matches(".*/jre/lib/.*jar")) continue;
                    scanUrls.add(u);
                }
                Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().filterInputsBy((Predicate)new FilterBuilder().exclude("^(?!.*\\.class$).*$").exclude("^org.nd4j.*").exclude("^org.datavec.*").exclude("^org.bytedeco.*").exclude("^com.fasterxml.*").exclude("^org.apache.*").exclude("^org.projectlombok.*").exclude("^com.twelvemonkeys.*").exclude("^org.joda.*").exclude("^org.slf4j.*").exclude("^com.google.*").exclude("^org.reflections.*").exclude("^ch.qos.*")).addUrls(scanUrls).setScanners(new Scanner[]{new DL4JSubTypesScanner(interfaces, classesList)}));
                Store store = reflections.getStore();
                Iterable subtypesByName = store.getAll(DL4JSubTypesScanner.class.getSimpleName(), classNames);
                HashSet subtypeClasses = Sets.newHashSet((Iterable)ReflectionUtils.forNames((Iterable)subtypesByName, (ClassLoader[])new ClassLoader[0]));
                subtypesClassCache = new HashSet();
                for (Class c : subtypeClasses) {
                    if (Modifier.isAbstract(c.getModifiers()) || Modifier.isInterface(c.getModifiers())) continue;
                    subtypesClassCache.add(c);
                }
            }
        }
        HashSet<Class> registeredSubtypes = new HashSet<Class>();
        for (Class c : classes) {
            AnnotatedClass ac = AnnotatedClass.construct((Class)c, (AnnotationIntrospector)mapper.getSerializationConfig().getAnnotationIntrospector(), null);
            Collection types = mapper.getSubtypeResolver().collectAndResolveSubtypes(ac, (MapperConfig)mapper.getSerializationConfig(), mapper.getSerializationConfig().getAnnotationIntrospector());
            for (NamedType nt : types) {
                registeredSubtypes.add(nt.getType());
            }
        }
        ArrayList<NamedType> toRegister = new ArrayList<NamedType>();
        block5: for (Class<?> c : subtypesClassCache) {
            String name;
            if (Modifier.isAbstract(c.getModifiers()) || Modifier.isInterface(c.getModifiers()) || registeredSubtypes.contains(c)) continue;
            if (ClassUtils.isInnerClass(c)) {
                Class<?> c2 = c.getDeclaringClass();
                name = c2.getSimpleName() + "$" + c.getSimpleName();
            } else {
                name = c.getSimpleName();
            }
            toRegister.add(new NamedType(c, name));
            if (!log.isDebugEnabled()) continue;
            for (Class baseClass : classes) {
                if (!baseClass.isAssignableFrom(c)) continue;
                log.debug("Registering class for JSON serialization: {} as subtype of {}", (Object)c.getName(), (Object)baseClass.getName());
                continue block5;
            }
        }
        mapper.registerSubtypes(toRegister.toArray(new NamedType[toRegister.size()]));
    }

    public Object[] getExtraArgs() {
        if (this.layer == null || this.layer.getActivationFunction() == null) {
            return new Object[0];
        }
        switch (this.layer.getActivationFunction()) {
            case "leakyrelu": {
                return new Object[]{this.leakyreluAlpha};
            }
            case "relu": {
                return new Object[]{0};
            }
        }
        return new Object[0];
    }

    public Layer getLayer() {
        return this.layer;
    }

    public double getLeakyreluAlpha() {
        return this.leakyreluAlpha;
    }

    public boolean isMiniBatch() {
        return this.miniBatch;
    }

    public int getNumIterations() {
        return this.numIterations;
    }

    public int getMaxNumLineSearchIterations() {
        return this.maxNumLineSearchIterations;
    }

    public long getSeed() {
        return this.seed;
    }

    public OptimizationAlgorithm getOptimizationAlgo() {
        return this.optimizationAlgo;
    }

    public List<String> getVariables() {
        return this.variables;
    }

    public StepFunction getStepFunction() {
        return this.stepFunction;
    }

    public boolean isUseRegularization() {
        return this.useRegularization;
    }

    public boolean isUseDropConnect() {
        return this.useDropConnect;
    }

    public boolean isMinimize() {
        return this.minimize;
    }

    public Map<String, Double> getLearningRateByParam() {
        return this.learningRateByParam;
    }

    public Map<String, Double> getL1ByParam() {
        return this.l1ByParam;
    }

    public Map<String, Double> getL2ByParam() {
        return this.l2ByParam;
    }

    public LearningRatePolicy getLearningRatePolicy() {
        return this.learningRatePolicy;
    }

    public double getLrPolicyDecayRate() {
        return this.lrPolicyDecayRate;
    }

    public double getLrPolicySteps() {
        return this.lrPolicySteps;
    }

    public double getLrPolicyPower() {
        return this.lrPolicyPower;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    public void setLeakyreluAlpha(double leakyreluAlpha) {
        this.leakyreluAlpha = leakyreluAlpha;
    }

    public void setMiniBatch(boolean miniBatch) {
        this.miniBatch = miniBatch;
    }

    public void setNumIterations(int numIterations) {
        this.numIterations = numIterations;
    }

    public void setMaxNumLineSearchIterations(int maxNumLineSearchIterations) {
        this.maxNumLineSearchIterations = maxNumLineSearchIterations;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public void setOptimizationAlgo(OptimizationAlgorithm optimizationAlgo) {
        this.optimizationAlgo = optimizationAlgo;
    }

    public void setVariables(List<String> variables) {
        this.variables = variables;
    }

    public void setStepFunction(StepFunction stepFunction) {
        this.stepFunction = stepFunction;
    }

    public void setUseRegularization(boolean useRegularization) {
        this.useRegularization = useRegularization;
    }

    public void setUseDropConnect(boolean useDropConnect) {
        this.useDropConnect = useDropConnect;
    }

    public void setMinimize(boolean minimize) {
        this.minimize = minimize;
    }

    public void setLearningRateByParam(Map<String, Double> learningRateByParam) {
        this.learningRateByParam = learningRateByParam;
    }

    public void setL1ByParam(Map<String, Double> l1ByParam) {
        this.l1ByParam = l1ByParam;
    }

    public void setL2ByParam(Map<String, Double> l2ByParam) {
        this.l2ByParam = l2ByParam;
    }

    public void setLearningRatePolicy(LearningRatePolicy learningRatePolicy) {
        this.learningRatePolicy = learningRatePolicy;
    }

    public void setLrPolicyDecayRate(double lrPolicyDecayRate) {
        this.lrPolicyDecayRate = lrPolicyDecayRate;
    }

    public void setLrPolicySteps(double lrPolicySteps) {
        this.lrPolicySteps = lrPolicySteps;
    }

    public void setLrPolicyPower(double lrPolicyPower) {
        this.lrPolicyPower = lrPolicyPower;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NeuralNetConfiguration)) {
            return false;
        }
        NeuralNetConfiguration other = (NeuralNetConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Layer this$layer = this.getLayer();
        Layer other$layer = other.getLayer();
        if (this$layer == null ? other$layer != null : !((Object)this$layer).equals(other$layer)) {
            return false;
        }
        if (Double.compare(this.getLeakyreluAlpha(), other.getLeakyreluAlpha()) != 0) {
            return false;
        }
        if (this.isMiniBatch() != other.isMiniBatch()) {
            return false;
        }
        if (this.getNumIterations() != other.getNumIterations()) {
            return false;
        }
        if (this.getMaxNumLineSearchIterations() != other.getMaxNumLineSearchIterations()) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        OptimizationAlgorithm this$optimizationAlgo = this.getOptimizationAlgo();
        OptimizationAlgorithm other$optimizationAlgo = other.getOptimizationAlgo();
        if (this$optimizationAlgo == null ? other$optimizationAlgo != null : !((Object)((Object)this$optimizationAlgo)).equals((Object)other$optimizationAlgo)) {
            return false;
        }
        List<String> this$variables = this.getVariables();
        List<String> other$variables = other.getVariables();
        if (this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables)) {
            return false;
        }
        StepFunction this$stepFunction = this.getStepFunction();
        StepFunction other$stepFunction = other.getStepFunction();
        if (this$stepFunction == null ? other$stepFunction != null : !this$stepFunction.equals(other$stepFunction)) {
            return false;
        }
        if (this.isUseRegularization() != other.isUseRegularization()) {
            return false;
        }
        if (this.isUseDropConnect() != other.isUseDropConnect()) {
            return false;
        }
        if (this.isMinimize() != other.isMinimize()) {
            return false;
        }
        Map<String, Double> this$learningRateByParam = this.getLearningRateByParam();
        Map<String, Double> other$learningRateByParam = other.getLearningRateByParam();
        if (this$learningRateByParam == null ? other$learningRateByParam != null : !((Object)this$learningRateByParam).equals(other$learningRateByParam)) {
            return false;
        }
        Map<String, Double> this$l1ByParam = this.getL1ByParam();
        Map<String, Double> other$l1ByParam = other.getL1ByParam();
        if (this$l1ByParam == null ? other$l1ByParam != null : !((Object)this$l1ByParam).equals(other$l1ByParam)) {
            return false;
        }
        Map<String, Double> this$l2ByParam = this.getL2ByParam();
        Map<String, Double> other$l2ByParam = other.getL2ByParam();
        if (this$l2ByParam == null ? other$l2ByParam != null : !((Object)this$l2ByParam).equals(other$l2ByParam)) {
            return false;
        }
        LearningRatePolicy this$learningRatePolicy = this.getLearningRatePolicy();
        LearningRatePolicy other$learningRatePolicy = other.getLearningRatePolicy();
        if (this$learningRatePolicy == null ? other$learningRatePolicy != null : !((Object)((Object)this$learningRatePolicy)).equals((Object)other$learningRatePolicy)) {
            return false;
        }
        if (Double.compare(this.getLrPolicyDecayRate(), other.getLrPolicyDecayRate()) != 0) {
            return false;
        }
        if (Double.compare(this.getLrPolicySteps(), other.getLrPolicySteps()) != 0) {
            return false;
        }
        return Double.compare(this.getLrPolicyPower(), other.getLrPolicyPower()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof NeuralNetConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Layer $layer = this.getLayer();
        result = result * 59 + ($layer == null ? 43 : ((Object)$layer).hashCode());
        long $leakyreluAlpha = Double.doubleToLongBits(this.getLeakyreluAlpha());
        result = result * 59 + (int)($leakyreluAlpha >>> 32 ^ $leakyreluAlpha);
        result = result * 59 + (this.isMiniBatch() ? 79 : 97);
        result = result * 59 + this.getNumIterations();
        result = result * 59 + this.getMaxNumLineSearchIterations();
        long $seed = this.getSeed();
        result = result * 59 + (int)($seed >>> 32 ^ $seed);
        OptimizationAlgorithm $optimizationAlgo = this.getOptimizationAlgo();
        result = result * 59 + ($optimizationAlgo == null ? 43 : ((Object)((Object)$optimizationAlgo)).hashCode());
        List<String> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        StepFunction $stepFunction = this.getStepFunction();
        result = result * 59 + ($stepFunction == null ? 43 : $stepFunction.hashCode());
        result = result * 59 + (this.isUseRegularization() ? 79 : 97);
        result = result * 59 + (this.isUseDropConnect() ? 79 : 97);
        result = result * 59 + (this.isMinimize() ? 79 : 97);
        Map<String, Double> $learningRateByParam = this.getLearningRateByParam();
        result = result * 59 + ($learningRateByParam == null ? 43 : ((Object)$learningRateByParam).hashCode());
        Map<String, Double> $l1ByParam = this.getL1ByParam();
        result = result * 59 + ($l1ByParam == null ? 43 : ((Object)$l1ByParam).hashCode());
        Map<String, Double> $l2ByParam = this.getL2ByParam();
        result = result * 59 + ($l2ByParam == null ? 43 : ((Object)$l2ByParam).hashCode());
        LearningRatePolicy $learningRatePolicy = this.getLearningRatePolicy();
        result = result * 59 + ($learningRatePolicy == null ? 43 : ((Object)((Object)$learningRatePolicy)).hashCode());
        long $lrPolicyDecayRate = Double.doubleToLongBits(this.getLrPolicyDecayRate());
        result = result * 59 + (int)($lrPolicyDecayRate >>> 32 ^ $lrPolicyDecayRate);
        long $lrPolicySteps = Double.doubleToLongBits(this.getLrPolicySteps());
        result = result * 59 + (int)($lrPolicySteps >>> 32 ^ $lrPolicySteps);
        long $lrPolicyPower = Double.doubleToLongBits(this.getLrPolicyPower());
        result = result * 59 + (int)($lrPolicyPower >>> 32 ^ $lrPolicyPower);
        return result;
    }

    public String toString() {
        return "NeuralNetConfiguration(layer=" + this.getLayer() + ", leakyreluAlpha=" + this.getLeakyreluAlpha() + ", miniBatch=" + this.isMiniBatch() + ", numIterations=" + this.getNumIterations() + ", maxNumLineSearchIterations=" + this.getMaxNumLineSearchIterations() + ", seed=" + this.getSeed() + ", optimizationAlgo=" + (Object)((Object)this.getOptimizationAlgo()) + ", variables=" + this.getVariables() + ", stepFunction=" + this.getStepFunction() + ", useRegularization=" + this.isUseRegularization() + ", useDropConnect=" + this.isUseDropConnect() + ", minimize=" + this.isMinimize() + ", learningRateByParam=" + this.getLearningRateByParam() + ", l1ByParam=" + this.getL1ByParam() + ", l2ByParam=" + this.getL2ByParam() + ", learningRatePolicy=" + (Object)((Object)this.getLearningRatePolicy()) + ", lrPolicyDecayRate=" + this.getLrPolicyDecayRate() + ", lrPolicySteps=" + this.getLrPolicySteps() + ", lrPolicyPower=" + this.getLrPolicyPower() + ")";
    }

    public static class Builder
    implements Cloneable {
        protected String activationFunction = "sigmoid";
        protected WeightInit weightInit = WeightInit.XAVIER;
        protected double biasInit = 0.0;
        protected Distribution dist = null;
        protected double learningRate = 0.1;
        protected double biasLearningRate = Double.NaN;
        protected Map<Integer, Double> learningRateSchedule = null;
        protected double lrScoreBasedDecay;
        protected double l1 = Double.NaN;
        protected double l2 = Double.NaN;
        protected double dropOut = 0.0;
        protected Updater updater = Updater.SGD;
        protected double momentum = Double.NaN;
        protected Map<Integer, Double> momentumSchedule = null;
        protected double epsilon = Double.NaN;
        protected double rho = Double.NaN;
        protected double rmsDecay = Double.NaN;
        protected double adamMeanDecay = Double.NaN;
        protected double adamVarDecay = Double.NaN;
        protected Layer layer;
        protected double leakyreluAlpha = 0.01;
        protected boolean miniBatch = true;
        protected int numIterations = 1;
        protected int maxNumLineSearchIterations = 5;
        protected long seed = System.currentTimeMillis();
        protected boolean useRegularization = false;
        protected OptimizationAlgorithm optimizationAlgo = OptimizationAlgorithm.STOCHASTIC_GRADIENT_DESCENT;
        protected StepFunction stepFunction = null;
        protected boolean useDropConnect = false;
        protected boolean minimize = true;
        protected GradientNormalization gradientNormalization = GradientNormalization.None;
        protected double gradientNormalizationThreshold = 1.0;
        protected LearningRatePolicy learningRatePolicy = LearningRatePolicy.None;
        protected double lrPolicyDecayRate = Double.NaN;
        protected double lrPolicySteps = Double.NaN;
        protected double lrPolicyPower = Double.NaN;
        protected ConvolutionMode convolutionMode = ConvolutionMode.Truncate;

        public Builder miniBatch(boolean miniBatch) {
            this.miniBatch = miniBatch;
            return this;
        }

        public Builder useDropConnect(boolean useDropConnect) {
            this.useDropConnect = useDropConnect;
            return this;
        }

        public Builder minimize(boolean minimize) {
            this.minimize = minimize;
            return this;
        }

        public Builder maxNumLineSearchIterations(int maxNumLineSearchIterations) {
            this.maxNumLineSearchIterations = maxNumLineSearchIterations;
            return this;
        }

        public Builder layer(Layer layer) {
            this.layer = layer;
            return this;
        }

        public Builder stepFunction(StepFunction stepFunction) {
            this.stepFunction = stepFunction;
            return this;
        }

        public ListBuilder list() {
            return new ListBuilder(this);
        }

        public ListBuilder list(Layer ... layers) {
            if (layers == null || layers.length == 0) {
                throw new IllegalArgumentException("Cannot create network with no layers");
            }
            HashMap<Integer, Builder> layerMap = new HashMap<Integer, Builder>();
            for (int i = 0; i < layers.length; ++i) {
                Builder b = this.clone();
                b.layer(layers[i]);
                layerMap.put(i, b);
            }
            return new ListBuilder(this, layerMap);
        }

        public ComputationGraphConfiguration.GraphBuilder graphBuilder() {
            return new ComputationGraphConfiguration.GraphBuilder(this);
        }

        public Builder iterations(int numIterations) {
            this.numIterations = numIterations;
            return this;
        }

        public Builder seed(int seed) {
            this.seed = seed;
            Nd4j.getRandom().setSeed(seed);
            return this;
        }

        public Builder seed(long seed) {
            this.seed = seed;
            Nd4j.getRandom().setSeed(seed);
            return this;
        }

        public Builder optimizationAlgo(OptimizationAlgorithm optimizationAlgo) {
            this.optimizationAlgo = optimizationAlgo;
            return this;
        }

        public Builder regularization(boolean useRegularization) {
            this.useRegularization = useRegularization;
            return this;
        }

        public Builder clone() {
            try {
                Builder clone = (Builder)super.clone();
                if (clone.layer != null) {
                    clone.layer = clone.layer.clone();
                }
                if (clone.stepFunction != null) {
                    clone.stepFunction = clone.stepFunction.clone();
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public Builder activation(String activationFunction) {
            this.activationFunction = activationFunction;
            return this;
        }

        public Builder leakyreluAlpha(double leakyreluAlpha) {
            this.leakyreluAlpha = leakyreluAlpha;
            return this;
        }

        public Builder weightInit(WeightInit weightInit) {
            this.weightInit = weightInit;
            return this;
        }

        public Builder biasInit(double biasInit) {
            this.biasInit = biasInit;
            return this;
        }

        public Builder dist(Distribution dist) {
            this.dist = dist;
            return this;
        }

        public Builder learningRate(double learningRate) {
            this.learningRate = learningRate;
            return this;
        }

        public Builder biasLearningRate(double biasLearningRate) {
            this.biasLearningRate = biasLearningRate;
            return this;
        }

        public Builder learningRateSchedule(Map<Integer, Double> learningRateSchedule) {
            this.learningRateSchedule = learningRateSchedule;
            return this;
        }

        public Builder learningRateScoreBasedDecayRate(double lrScoreBasedDecay) {
            this.lrScoreBasedDecay = lrScoreBasedDecay;
            return this;
        }

        public Builder l1(double l1) {
            this.l1 = l1;
            return this;
        }

        public Builder l2(double l2) {
            this.l2 = l2;
            return this;
        }

        public Builder dropOut(double dropOut) {
            this.dropOut = dropOut;
            return this;
        }

        public Builder momentum(double momentum) {
            this.momentum = momentum;
            return this;
        }

        public Builder momentumAfter(Map<Integer, Double> momentumAfter) {
            this.momentumSchedule = momentumAfter;
            return this;
        }

        public Builder updater(Updater updater) {
            this.updater = updater;
            return this;
        }

        public Builder rho(double rho) {
            this.rho = rho;
            return this;
        }

        public Builder epsilon(double epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        public Builder rmsDecay(double rmsDecay) {
            this.rmsDecay = rmsDecay;
            return this;
        }

        public Builder adamMeanDecay(double adamMeanDecay) {
            this.adamMeanDecay = adamMeanDecay;
            return this;
        }

        public Builder adamVarDecay(double adamVarDecay) {
            this.adamVarDecay = adamVarDecay;
            return this;
        }

        public Builder gradientNormalization(GradientNormalization gradientNormalization) {
            this.gradientNormalization = gradientNormalization;
            return this;
        }

        public Builder gradientNormalizationThreshold(double threshold) {
            this.gradientNormalizationThreshold = threshold;
            return this;
        }

        public Builder learningRateDecayPolicy(LearningRatePolicy policy) {
            this.learningRatePolicy = policy;
            return this;
        }

        public Builder lrPolicyDecayRate(double lrPolicyDecayRate) {
            this.lrPolicyDecayRate = lrPolicyDecayRate;
            return this;
        }

        public Builder lrPolicySteps(double lrPolicySteps) {
            this.lrPolicySteps = lrPolicySteps;
            return this;
        }

        public Builder lrPolicyPower(double lrPolicyPower) {
            this.lrPolicyPower = lrPolicyPower;
            return this;
        }

        public Builder convolutionMode(ConvolutionMode convolutionMode) {
            this.convolutionMode = convolutionMode;
            return this;
        }

        private void updaterValidation(String layerName) {
            if (!(Double.isNaN(this.momentum) && Double.isNaN(this.layer.getMomentum()) || this.layer.getUpdater() == Updater.NESTEROVS)) {
                log.warn("Layer \"" + layerName + "\" momentum has been set but will not be applied unless the updater is set to NESTEROVS.");
            }
            if ((this.momentumSchedule != null || this.layer.getMomentumSchedule() != null) && this.layer.getUpdater() != Updater.NESTEROVS) {
                log.warn("Layer \"" + layerName + "\" momentum schedule has been set but will not be applied unless the updater is set to NESTEROVS.");
            }
            if (!(Double.isNaN(this.adamVarDecay) && Double.isNaN(this.layer.getAdamVarDecay()) || this.layer.getUpdater() == Updater.ADAM)) {
                log.warn("Layer \"" + layerName + "\" adamVarDecay is set but will not be applied unless the updater is set to Adam.");
            }
            if (!(Double.isNaN(this.adamMeanDecay) && Double.isNaN(this.layer.getAdamMeanDecay()) || this.layer.getUpdater() == Updater.ADAM)) {
                log.warn("Layer \"" + layerName + "\" adamMeanDecay is set but will not be applied unless the updater is set to Adam.");
            }
            if (!(Double.isNaN(this.rho) && Double.isNaN(this.layer.getRho()) || this.layer.getUpdater() == Updater.ADADELTA)) {
                log.warn("Layer \"" + layerName + "\" rho is set but will not be applied unless the updater is set to ADADELTA.");
            }
            if (!(Double.isNaN(this.rmsDecay) && Double.isNaN(this.layer.getRmsDecay()) || this.layer.getUpdater() == Updater.RMSPROP)) {
                log.warn("Layer \"" + layerName + "\" rmsdecay is set but will not be applied unless the updater is set to RMSPROP.");
            }
            switch (this.layer.getUpdater()) {
                case NESTEROVS: {
                    if (Double.isNaN(this.momentum) && Double.isNaN(this.layer.getMomentum())) {
                        this.layer.setMomentum(0.9);
                        log.warn("Layer \"" + layerName + "\" momentum is automatically set to 0.9. Add momentum to configuration to change the value.");
                    } else if (Double.isNaN(this.layer.getMomentum())) {
                        this.layer.setMomentum(this.momentum);
                    }
                    if (this.momentumSchedule != null && this.layer.getMomentumSchedule() == null) {
                        this.layer.setMomentumSchedule(this.momentumSchedule);
                        break;
                    }
                    if (this.momentumSchedule != null || this.layer.getMomentumSchedule() != null) break;
                    this.layer.setMomentumSchedule(new HashMap<Integer, Double>());
                    break;
                }
                case ADAM: {
                    if (Double.isNaN(this.adamMeanDecay) && Double.isNaN(this.layer.getAdamMeanDecay())) {
                        this.layer.setAdamMeanDecay(0.9);
                        log.warn("Layer \"" + layerName + "\" adamMeanDecay is automatically set to 0.9. Add adamVarDecay to configuration to change the value.");
                    } else if (Double.isNaN(this.layer.getAdamMeanDecay())) {
                        this.layer.setAdamMeanDecay(this.adamMeanDecay);
                    }
                    if (Double.isNaN(this.adamVarDecay) && Double.isNaN(this.layer.getAdamVarDecay())) {
                        this.layer.setAdamVarDecay(0.999);
                        log.warn("Layer \"" + layerName + "\" adamVarDecay is automatically set to 0.999. Add adamVarDecay to configuration to change the value.");
                        break;
                    }
                    if (!Double.isNaN(this.layer.getAdamVarDecay())) break;
                    this.layer.setAdamVarDecay(this.adamVarDecay);
                    break;
                }
                case ADADELTA: {
                    if (Double.isNaN(this.layer.getRho())) {
                        this.layer.setRho(this.rho);
                    }
                    if (Double.isNaN(this.epsilon) && Double.isNaN(this.layer.getEpsilon())) {
                        this.layer.setEpsilon(1.0E-6);
                        log.warn("Layer \"" + layerName + "\" AdaDelta epsilon is automatically set to 1e-6. Add epsilon to configuration to change the value.");
                        break;
                    }
                    if (!Double.isNaN(this.layer.getEpsilon())) break;
                    this.layer.setEpsilon(this.epsilon);
                    break;
                }
                case ADAGRAD: {
                    if (Double.isNaN(this.epsilon) && Double.isNaN(this.layer.getEpsilon())) {
                        this.layer.setEpsilon(1.0E-6);
                        break;
                    }
                    if (!Double.isNaN(this.layer.getEpsilon())) break;
                    this.layer.setEpsilon(this.epsilon);
                    break;
                }
                case RMSPROP: {
                    if (Double.isNaN(this.rmsDecay) && Double.isNaN(this.layer.getRmsDecay())) {
                        this.layer.setRmsDecay(0.95);
                        log.warn("Layer \"" + layerName + "\" rmsDecay is automatically set to 0.95. Add rmsDecay to configuration to change the value.");
                        break;
                    }
                    if (!Double.isNaN(this.layer.getRmsDecay())) break;
                    this.layer.setRmsDecay(this.rmsDecay);
                }
            }
        }

        private void learningRateValidation(String layerName) {
            if (this.learningRatePolicy != LearningRatePolicy.None && Double.isNaN(this.lrPolicyDecayRate) && (this.learningRatePolicy != LearningRatePolicy.Schedule || this.learningRateSchedule == null) && (this.learningRatePolicy != LearningRatePolicy.Poly || Double.isNaN(this.lrPolicyPower))) {
                throw new IllegalStateException("Layer \"" + layerName + "\" learning rate policy decay rate (lrPolicyDecayRate) must be set to use learningRatePolicy.");
            }
            switch (this.learningRatePolicy) {
                case Inverse: 
                case Poly: {
                    if (!Double.isNaN(this.lrPolicyPower)) break;
                    throw new IllegalStateException("Layer \"" + layerName + "\" learning rate policy power (lrPolicyPower) must be set to use " + (Object)((Object)this.learningRatePolicy));
                }
                case Step: 
                case Sigmoid: {
                    if (!Double.isNaN(this.lrPolicySteps)) break;
                    throw new IllegalStateException("Layer \"" + layerName + "\" learning rate policy steps (lrPolicySteps) must be set to use " + (Object)((Object)this.learningRatePolicy));
                }
                case Schedule: {
                    if (this.learningRateSchedule != null) break;
                    throw new IllegalStateException("Layer \"" + layerName + "\" learning rate policy schedule (learningRateSchedule) must be set to use " + (Object)((Object)this.learningRatePolicy));
                }
            }
            if (!Double.isNaN(this.lrPolicyPower) && this.learningRatePolicy != LearningRatePolicy.Inverse && this.learningRatePolicy != LearningRatePolicy.Poly) {
                throw new IllegalStateException("Layer \"" + layerName + "\" power has been set but will not be applied unless the learning rate policy is set to Inverse or Poly.");
            }
            if (!Double.isNaN(this.lrPolicySteps) && this.learningRatePolicy != LearningRatePolicy.Step && this.learningRatePolicy != LearningRatePolicy.Sigmoid && this.learningRatePolicy != LearningRatePolicy.TorchStep) {
                throw new IllegalStateException("Layer \"" + layerName + "\" steps have been set but will not be applied unless the learning rate policy is set to Step or Sigmoid.");
            }
            if (this.learningRateSchedule != null && this.learningRatePolicy != LearningRatePolicy.Schedule) {
                throw new IllegalStateException("Layer \"" + layerName + "\" learning rate schedule has been set but will not be applied unless the learning rate policy is set to Schedule.");
            }
        }

        private void generalValidation(String layerName) {
            if (this.useDropConnect && Double.isNaN(this.dropOut) && Double.isNaN(this.layer.getDropOut())) {
                log.warn("Layer \"" + layerName + "\" dropConnect is set to true but dropout rate has not been added to configuration.");
            }
            if (this.useDropConnect && this.dropOut == 0.0) {
                log.warn("Layer \"" + layerName + " dropConnect is set to true but dropout rate is set to 0.0");
            }
            if (this.useRegularization && Double.isNaN(this.l1) && this.layer != null && Double.isNaN(this.layer.getL1()) && Double.isNaN(this.l2) && Double.isNaN(this.layer.getL2()) && (Double.isNaN(this.dropOut) || this.dropOut == 0.0) && (Double.isNaN(this.layer.getDropOut()) || this.layer.getDropOut() == 0.0)) {
                log.warn("Layer \"" + layerName + "\" regularization is set to true but l1, l2 or dropout has not been added to configuration.");
            }
            if (this.layer != null) {
                if (this.useRegularization) {
                    if (!Double.isNaN(this.l1) && Double.isNaN(this.layer.getL1())) {
                        this.layer.setL1(this.l1);
                    }
                    if (!Double.isNaN(this.l2) && Double.isNaN(this.layer.getL2())) {
                        this.layer.setL2(this.l2);
                    }
                } else if (!this.useRegularization && (!Double.isNaN(this.l1) && this.l1 > 0.0 || !Double.isNaN(this.layer.getL1()) && this.layer.getL1() > 0.0 || !Double.isNaN(this.l2) && this.l2 > 0.0 || !Double.isNaN(this.layer.getL2()) && this.layer.getL2() > 0.0)) {
                    log.warn("Layer \"" + layerName + "\" l1 or l2 has been added to configuration but useRegularization is set to false.");
                }
                if (Double.isNaN(this.l2) && Double.isNaN(this.layer.getL2())) {
                    this.layer.setL2(0.0);
                }
                if (Double.isNaN(this.l1) && Double.isNaN(this.layer.getL1())) {
                    this.layer.setL1(0.0);
                }
                if (this.layer.getWeightInit() == WeightInit.DISTRIBUTION) {
                    if (this.dist != null && this.layer.getDist() == null) {
                        this.layer.setDist(this.dist);
                    } else if (this.dist == null && this.layer.getDist() == null) {
                        this.layer.setDist(new NormalDistribution(0.001, 1.0));
                        log.warn("Layer \"" + layerName + "\" distribution is automatically set to normalize distribution with mean 1e-3 and variance 1.");
                    }
                } else if (this.dist != null || this.layer.getDist() != null) {
                    log.warn("Layer \"" + layerName + "\" distribution is set but will not be applied unless weight init is set to WeighInit.DISTRIBUTION.");
                }
            }
        }

        public NeuralNetConfiguration build() {
            NeuralNetConfiguration conf = new NeuralNetConfiguration();
            conf.minimize = this.minimize;
            conf.maxNumLineSearchIterations = this.maxNumLineSearchIterations;
            conf.layer = this.layer;
            conf.numIterations = this.numIterations;
            conf.useRegularization = this.useRegularization;
            conf.optimizationAlgo = this.optimizationAlgo;
            conf.seed = this.seed;
            conf.stepFunction = this.stepFunction;
            conf.useDropConnect = this.useDropConnect;
            conf.miniBatch = this.miniBatch;
            conf.learningRatePolicy = this.learningRatePolicy;
            conf.lrPolicyDecayRate = this.lrPolicyDecayRate;
            conf.lrPolicySteps = this.lrPolicySteps;
            conf.lrPolicyPower = this.lrPolicyPower;
            String layerName = this.layer == null || this.layer.getLayerName() == null ? "Layer not named" : "Layer " + this.layer.getLayerName();
            this.learningRateValidation(layerName);
            if (this.layer != null) {
                SubsamplingLayer sl;
                ConvolutionLayer cl;
                if (Double.isNaN(this.layer.getLearningRate())) {
                    this.layer.setLearningRate(this.learningRate);
                }
                if (Double.isNaN(this.layer.getBiasLearningRate())) {
                    this.layer.setBiasLearningRate(this.layer.getLearningRate());
                }
                if (this.layer.getLearningRateSchedule() == null) {
                    this.layer.setLearningRateSchedule(this.learningRateSchedule);
                }
                if (Double.isNaN(this.layer.getL1())) {
                    this.layer.setL1(this.l1);
                }
                if (Double.isNaN(this.layer.getL2())) {
                    this.layer.setL2(this.l2);
                }
                if (this.layer.getActivationFunction() == null) {
                    this.layer.setActivationFunction(this.activationFunction);
                }
                if (this.layer.getWeightInit() == null) {
                    this.layer.setWeightInit(this.weightInit);
                }
                if (Double.isNaN(this.layer.getBiasInit())) {
                    this.layer.setBiasInit(this.biasInit);
                }
                if (Double.isNaN(this.layer.getDropOut())) {
                    this.layer.setDropOut(this.dropOut);
                }
                if (this.layer.getUpdater() == null) {
                    this.layer.setUpdater(this.updater);
                }
                this.updaterValidation(layerName);
                if (this.layer.getGradientNormalization() == null) {
                    this.layer.setGradientNormalization(this.gradientNormalization);
                }
                if (Double.isNaN(this.layer.getGradientNormalizationThreshold())) {
                    this.layer.setGradientNormalizationThreshold(this.gradientNormalizationThreshold);
                }
                if (this.layer instanceof ConvolutionLayer && (cl = (ConvolutionLayer)this.layer).getConvolutionMode() == null) {
                    cl.setConvolutionMode(this.convolutionMode);
                }
                if (this.layer instanceof SubsamplingLayer && (sl = (SubsamplingLayer)this.layer).getConvolutionMode() == null) {
                    sl.setConvolutionMode(this.convolutionMode);
                }
            }
            this.generalValidation(layerName);
            return conf;
        }

        public String getActivationFunction() {
            return this.activationFunction;
        }

        public WeightInit getWeightInit() {
            return this.weightInit;
        }

        public double getBiasInit() {
            return this.biasInit;
        }

        public Distribution getDist() {
            return this.dist;
        }

        public double getLearningRate() {
            return this.learningRate;
        }

        public double getBiasLearningRate() {
            return this.biasLearningRate;
        }

        public Map<Integer, Double> getLearningRateSchedule() {
            return this.learningRateSchedule;
        }

        public double getLrScoreBasedDecay() {
            return this.lrScoreBasedDecay;
        }

        public double getL1() {
            return this.l1;
        }

        public double getL2() {
            return this.l2;
        }

        public double getDropOut() {
            return this.dropOut;
        }

        public Updater getUpdater() {
            return this.updater;
        }

        public double getMomentum() {
            return this.momentum;
        }

        public Map<Integer, Double> getMomentumSchedule() {
            return this.momentumSchedule;
        }

        public double getEpsilon() {
            return this.epsilon;
        }

        public double getRho() {
            return this.rho;
        }

        public double getRmsDecay() {
            return this.rmsDecay;
        }

        public double getAdamMeanDecay() {
            return this.adamMeanDecay;
        }

        public double getAdamVarDecay() {
            return this.adamVarDecay;
        }

        public Layer getLayer() {
            return this.layer;
        }

        public double getLeakyreluAlpha() {
            return this.leakyreluAlpha;
        }

        public boolean isMiniBatch() {
            return this.miniBatch;
        }

        public int getNumIterations() {
            return this.numIterations;
        }

        public int getMaxNumLineSearchIterations() {
            return this.maxNumLineSearchIterations;
        }

        public long getSeed() {
            return this.seed;
        }

        public boolean isUseRegularization() {
            return this.useRegularization;
        }

        public OptimizationAlgorithm getOptimizationAlgo() {
            return this.optimizationAlgo;
        }

        public StepFunction getStepFunction() {
            return this.stepFunction;
        }

        public boolean isUseDropConnect() {
            return this.useDropConnect;
        }

        public boolean isMinimize() {
            return this.minimize;
        }

        public GradientNormalization getGradientNormalization() {
            return this.gradientNormalization;
        }

        public double getGradientNormalizationThreshold() {
            return this.gradientNormalizationThreshold;
        }

        public LearningRatePolicy getLearningRatePolicy() {
            return this.learningRatePolicy;
        }

        public double getLrPolicyDecayRate() {
            return this.lrPolicyDecayRate;
        }

        public double getLrPolicySteps() {
            return this.lrPolicySteps;
        }

        public double getLrPolicyPower() {
            return this.lrPolicyPower;
        }

        public ConvolutionMode getConvolutionMode() {
            return this.convolutionMode;
        }

        public void setActivationFunction(String activationFunction) {
            this.activationFunction = activationFunction;
        }

        public void setWeightInit(WeightInit weightInit) {
            this.weightInit = weightInit;
        }

        public void setBiasInit(double biasInit) {
            this.biasInit = biasInit;
        }

        public void setDist(Distribution dist) {
            this.dist = dist;
        }

        public void setLearningRate(double learningRate) {
            this.learningRate = learningRate;
        }

        public void setBiasLearningRate(double biasLearningRate) {
            this.biasLearningRate = biasLearningRate;
        }

        public void setLearningRateSchedule(Map<Integer, Double> learningRateSchedule) {
            this.learningRateSchedule = learningRateSchedule;
        }

        public void setLrScoreBasedDecay(double lrScoreBasedDecay) {
            this.lrScoreBasedDecay = lrScoreBasedDecay;
        }

        public void setL1(double l1) {
            this.l1 = l1;
        }

        public void setL2(double l2) {
            this.l2 = l2;
        }

        public void setDropOut(double dropOut) {
            this.dropOut = dropOut;
        }

        public void setUpdater(Updater updater) {
            this.updater = updater;
        }

        public void setMomentum(double momentum) {
            this.momentum = momentum;
        }

        public void setMomentumSchedule(Map<Integer, Double> momentumSchedule) {
            this.momentumSchedule = momentumSchedule;
        }

        public void setEpsilon(double epsilon) {
            this.epsilon = epsilon;
        }

        public void setRho(double rho) {
            this.rho = rho;
        }

        public void setRmsDecay(double rmsDecay) {
            this.rmsDecay = rmsDecay;
        }

        public void setAdamMeanDecay(double adamMeanDecay) {
            this.adamMeanDecay = adamMeanDecay;
        }

        public void setAdamVarDecay(double adamVarDecay) {
            this.adamVarDecay = adamVarDecay;
        }

        public void setLayer(Layer layer) {
            this.layer = layer;
        }

        public void setLeakyreluAlpha(double leakyreluAlpha) {
            this.leakyreluAlpha = leakyreluAlpha;
        }

        public void setMiniBatch(boolean miniBatch) {
            this.miniBatch = miniBatch;
        }

        public void setNumIterations(int numIterations) {
            this.numIterations = numIterations;
        }

        public void setMaxNumLineSearchIterations(int maxNumLineSearchIterations) {
            this.maxNumLineSearchIterations = maxNumLineSearchIterations;
        }

        public void setSeed(long seed) {
            this.seed = seed;
        }

        public void setUseRegularization(boolean useRegularization) {
            this.useRegularization = useRegularization;
        }

        public void setOptimizationAlgo(OptimizationAlgorithm optimizationAlgo) {
            this.optimizationAlgo = optimizationAlgo;
        }

        public void setStepFunction(StepFunction stepFunction) {
            this.stepFunction = stepFunction;
        }

        public void setUseDropConnect(boolean useDropConnect) {
            this.useDropConnect = useDropConnect;
        }

        public void setMinimize(boolean minimize) {
            this.minimize = minimize;
        }

        public void setGradientNormalization(GradientNormalization gradientNormalization) {
            this.gradientNormalization = gradientNormalization;
        }

        public void setGradientNormalizationThreshold(double gradientNormalizationThreshold) {
            this.gradientNormalizationThreshold = gradientNormalizationThreshold;
        }

        public void setLearningRatePolicy(LearningRatePolicy learningRatePolicy) {
            this.learningRatePolicy = learningRatePolicy;
        }

        public void setLrPolicyDecayRate(double lrPolicyDecayRate) {
            this.lrPolicyDecayRate = lrPolicyDecayRate;
        }

        public void setLrPolicySteps(double lrPolicySteps) {
            this.lrPolicySteps = lrPolicySteps;
        }

        public void setLrPolicyPower(double lrPolicyPower) {
            this.lrPolicyPower = lrPolicyPower;
        }

        public void setConvolutionMode(ConvolutionMode convolutionMode) {
            this.convolutionMode = convolutionMode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$activationFunction = this.getActivationFunction();
            String other$activationFunction = other.getActivationFunction();
            if (this$activationFunction == null ? other$activationFunction != null : !this$activationFunction.equals(other$activationFunction)) {
                return false;
            }
            WeightInit this$weightInit = this.getWeightInit();
            WeightInit other$weightInit = other.getWeightInit();
            if (this$weightInit == null ? other$weightInit != null : !((Object)((Object)this$weightInit)).equals((Object)other$weightInit)) {
                return false;
            }
            if (Double.compare(this.getBiasInit(), other.getBiasInit()) != 0) {
                return false;
            }
            Distribution this$dist = this.getDist();
            Distribution other$dist = other.getDist();
            if (this$dist == null ? other$dist != null : !this$dist.equals(other$dist)) {
                return false;
            }
            if (Double.compare(this.getLearningRate(), other.getLearningRate()) != 0) {
                return false;
            }
            if (Double.compare(this.getBiasLearningRate(), other.getBiasLearningRate()) != 0) {
                return false;
            }
            Map<Integer, Double> this$learningRateSchedule = this.getLearningRateSchedule();
            Map<Integer, Double> other$learningRateSchedule = other.getLearningRateSchedule();
            if (this$learningRateSchedule == null ? other$learningRateSchedule != null : !((Object)this$learningRateSchedule).equals(other$learningRateSchedule)) {
                return false;
            }
            if (Double.compare(this.getLrScoreBasedDecay(), other.getLrScoreBasedDecay()) != 0) {
                return false;
            }
            if (Double.compare(this.getL1(), other.getL1()) != 0) {
                return false;
            }
            if (Double.compare(this.getL2(), other.getL2()) != 0) {
                return false;
            }
            if (Double.compare(this.getDropOut(), other.getDropOut()) != 0) {
                return false;
            }
            Updater this$updater = this.getUpdater();
            Updater other$updater = other.getUpdater();
            if (this$updater == null ? other$updater != null : !((Object)((Object)this$updater)).equals((Object)other$updater)) {
                return false;
            }
            if (Double.compare(this.getMomentum(), other.getMomentum()) != 0) {
                return false;
            }
            Map<Integer, Double> this$momentumSchedule = this.getMomentumSchedule();
            Map<Integer, Double> other$momentumSchedule = other.getMomentumSchedule();
            if (this$momentumSchedule == null ? other$momentumSchedule != null : !((Object)this$momentumSchedule).equals(other$momentumSchedule)) {
                return false;
            }
            if (Double.compare(this.getEpsilon(), other.getEpsilon()) != 0) {
                return false;
            }
            if (Double.compare(this.getRho(), other.getRho()) != 0) {
                return false;
            }
            if (Double.compare(this.getRmsDecay(), other.getRmsDecay()) != 0) {
                return false;
            }
            if (Double.compare(this.getAdamMeanDecay(), other.getAdamMeanDecay()) != 0) {
                return false;
            }
            if (Double.compare(this.getAdamVarDecay(), other.getAdamVarDecay()) != 0) {
                return false;
            }
            Layer this$layer = this.getLayer();
            Layer other$layer = other.getLayer();
            if (this$layer == null ? other$layer != null : !((Object)this$layer).equals(other$layer)) {
                return false;
            }
            if (Double.compare(this.getLeakyreluAlpha(), other.getLeakyreluAlpha()) != 0) {
                return false;
            }
            if (this.isMiniBatch() != other.isMiniBatch()) {
                return false;
            }
            if (this.getNumIterations() != other.getNumIterations()) {
                return false;
            }
            if (this.getMaxNumLineSearchIterations() != other.getMaxNumLineSearchIterations()) {
                return false;
            }
            if (this.getSeed() != other.getSeed()) {
                return false;
            }
            if (this.isUseRegularization() != other.isUseRegularization()) {
                return false;
            }
            OptimizationAlgorithm this$optimizationAlgo = this.getOptimizationAlgo();
            OptimizationAlgorithm other$optimizationAlgo = other.getOptimizationAlgo();
            if (this$optimizationAlgo == null ? other$optimizationAlgo != null : !((Object)((Object)this$optimizationAlgo)).equals((Object)other$optimizationAlgo)) {
                return false;
            }
            StepFunction this$stepFunction = this.getStepFunction();
            StepFunction other$stepFunction = other.getStepFunction();
            if (this$stepFunction == null ? other$stepFunction != null : !this$stepFunction.equals(other$stepFunction)) {
                return false;
            }
            if (this.isUseDropConnect() != other.isUseDropConnect()) {
                return false;
            }
            if (this.isMinimize() != other.isMinimize()) {
                return false;
            }
            GradientNormalization this$gradientNormalization = this.getGradientNormalization();
            GradientNormalization other$gradientNormalization = other.getGradientNormalization();
            if (this$gradientNormalization == null ? other$gradientNormalization != null : !((Object)((Object)this$gradientNormalization)).equals((Object)other$gradientNormalization)) {
                return false;
            }
            if (Double.compare(this.getGradientNormalizationThreshold(), other.getGradientNormalizationThreshold()) != 0) {
                return false;
            }
            LearningRatePolicy this$learningRatePolicy = this.getLearningRatePolicy();
            LearningRatePolicy other$learningRatePolicy = other.getLearningRatePolicy();
            if (this$learningRatePolicy == null ? other$learningRatePolicy != null : !((Object)((Object)this$learningRatePolicy)).equals((Object)other$learningRatePolicy)) {
                return false;
            }
            if (Double.compare(this.getLrPolicyDecayRate(), other.getLrPolicyDecayRate()) != 0) {
                return false;
            }
            if (Double.compare(this.getLrPolicySteps(), other.getLrPolicySteps()) != 0) {
                return false;
            }
            if (Double.compare(this.getLrPolicyPower(), other.getLrPolicyPower()) != 0) {
                return false;
            }
            ConvolutionMode this$convolutionMode = this.getConvolutionMode();
            ConvolutionMode other$convolutionMode = other.getConvolutionMode();
            return !(this$convolutionMode == null ? other$convolutionMode != null : !((Object)((Object)this$convolutionMode)).equals((Object)other$convolutionMode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $activationFunction = this.getActivationFunction();
            result = result * 59 + ($activationFunction == null ? 43 : $activationFunction.hashCode());
            WeightInit $weightInit = this.getWeightInit();
            result = result * 59 + ($weightInit == null ? 43 : ((Object)((Object)$weightInit)).hashCode());
            long $biasInit = Double.doubleToLongBits(this.getBiasInit());
            result = result * 59 + (int)($biasInit >>> 32 ^ $biasInit);
            Distribution $dist = this.getDist();
            result = result * 59 + ($dist == null ? 43 : $dist.hashCode());
            long $learningRate = Double.doubleToLongBits(this.getLearningRate());
            result = result * 59 + (int)($learningRate >>> 32 ^ $learningRate);
            long $biasLearningRate = Double.doubleToLongBits(this.getBiasLearningRate());
            result = result * 59 + (int)($biasLearningRate >>> 32 ^ $biasLearningRate);
            Map<Integer, Double> $learningRateSchedule = this.getLearningRateSchedule();
            result = result * 59 + ($learningRateSchedule == null ? 43 : ((Object)$learningRateSchedule).hashCode());
            long $lrScoreBasedDecay = Double.doubleToLongBits(this.getLrScoreBasedDecay());
            result = result * 59 + (int)($lrScoreBasedDecay >>> 32 ^ $lrScoreBasedDecay);
            long $l1 = Double.doubleToLongBits(this.getL1());
            result = result * 59 + (int)($l1 >>> 32 ^ $l1);
            long $l2 = Double.doubleToLongBits(this.getL2());
            result = result * 59 + (int)($l2 >>> 32 ^ $l2);
            long $dropOut = Double.doubleToLongBits(this.getDropOut());
            result = result * 59 + (int)($dropOut >>> 32 ^ $dropOut);
            Updater $updater = this.getUpdater();
            result = result * 59 + ($updater == null ? 43 : ((Object)((Object)$updater)).hashCode());
            long $momentum = Double.doubleToLongBits(this.getMomentum());
            result = result * 59 + (int)($momentum >>> 32 ^ $momentum);
            Map<Integer, Double> $momentumSchedule = this.getMomentumSchedule();
            result = result * 59 + ($momentumSchedule == null ? 43 : ((Object)$momentumSchedule).hashCode());
            long $epsilon = Double.doubleToLongBits(this.getEpsilon());
            result = result * 59 + (int)($epsilon >>> 32 ^ $epsilon);
            long $rho = Double.doubleToLongBits(this.getRho());
            result = result * 59 + (int)($rho >>> 32 ^ $rho);
            long $rmsDecay = Double.doubleToLongBits(this.getRmsDecay());
            result = result * 59 + (int)($rmsDecay >>> 32 ^ $rmsDecay);
            long $adamMeanDecay = Double.doubleToLongBits(this.getAdamMeanDecay());
            result = result * 59 + (int)($adamMeanDecay >>> 32 ^ $adamMeanDecay);
            long $adamVarDecay = Double.doubleToLongBits(this.getAdamVarDecay());
            result = result * 59 + (int)($adamVarDecay >>> 32 ^ $adamVarDecay);
            Layer $layer = this.getLayer();
            result = result * 59 + ($layer == null ? 43 : ((Object)$layer).hashCode());
            long $leakyreluAlpha = Double.doubleToLongBits(this.getLeakyreluAlpha());
            result = result * 59 + (int)($leakyreluAlpha >>> 32 ^ $leakyreluAlpha);
            result = result * 59 + (this.isMiniBatch() ? 79 : 97);
            result = result * 59 + this.getNumIterations();
            result = result * 59 + this.getMaxNumLineSearchIterations();
            long $seed = this.getSeed();
            result = result * 59 + (int)($seed >>> 32 ^ $seed);
            result = result * 59 + (this.isUseRegularization() ? 79 : 97);
            OptimizationAlgorithm $optimizationAlgo = this.getOptimizationAlgo();
            result = result * 59 + ($optimizationAlgo == null ? 43 : ((Object)((Object)$optimizationAlgo)).hashCode());
            StepFunction $stepFunction = this.getStepFunction();
            result = result * 59 + ($stepFunction == null ? 43 : $stepFunction.hashCode());
            result = result * 59 + (this.isUseDropConnect() ? 79 : 97);
            result = result * 59 + (this.isMinimize() ? 79 : 97);
            GradientNormalization $gradientNormalization = this.getGradientNormalization();
            result = result * 59 + ($gradientNormalization == null ? 43 : ((Object)((Object)$gradientNormalization)).hashCode());
            long $gradientNormalizationThreshold = Double.doubleToLongBits(this.getGradientNormalizationThreshold());
            result = result * 59 + (int)($gradientNormalizationThreshold >>> 32 ^ $gradientNormalizationThreshold);
            LearningRatePolicy $learningRatePolicy = this.getLearningRatePolicy();
            result = result * 59 + ($learningRatePolicy == null ? 43 : ((Object)((Object)$learningRatePolicy)).hashCode());
            long $lrPolicyDecayRate = Double.doubleToLongBits(this.getLrPolicyDecayRate());
            result = result * 59 + (int)($lrPolicyDecayRate >>> 32 ^ $lrPolicyDecayRate);
            long $lrPolicySteps = Double.doubleToLongBits(this.getLrPolicySteps());
            result = result * 59 + (int)($lrPolicySteps >>> 32 ^ $lrPolicySteps);
            long $lrPolicyPower = Double.doubleToLongBits(this.getLrPolicyPower());
            result = result * 59 + (int)($lrPolicyPower >>> 32 ^ $lrPolicyPower);
            ConvolutionMode $convolutionMode = this.getConvolutionMode();
            result = result * 59 + ($convolutionMode == null ? 43 : ((Object)((Object)$convolutionMode)).hashCode());
            return result;
        }

        public String toString() {
            return "NeuralNetConfiguration.Builder(activationFunction=" + this.getActivationFunction() + ", weightInit=" + (Object)((Object)this.getWeightInit()) + ", biasInit=" + this.getBiasInit() + ", dist=" + this.getDist() + ", learningRate=" + this.getLearningRate() + ", biasLearningRate=" + this.getBiasLearningRate() + ", learningRateSchedule=" + this.getLearningRateSchedule() + ", lrScoreBasedDecay=" + this.getLrScoreBasedDecay() + ", l1=" + this.getL1() + ", l2=" + this.getL2() + ", dropOut=" + this.getDropOut() + ", updater=" + (Object)((Object)this.getUpdater()) + ", momentum=" + this.getMomentum() + ", momentumSchedule=" + this.getMomentumSchedule() + ", epsilon=" + this.getEpsilon() + ", rho=" + this.getRho() + ", rmsDecay=" + this.getRmsDecay() + ", adamMeanDecay=" + this.getAdamMeanDecay() + ", adamVarDecay=" + this.getAdamVarDecay() + ", layer=" + this.getLayer() + ", leakyreluAlpha=" + this.getLeakyreluAlpha() + ", miniBatch=" + this.isMiniBatch() + ", numIterations=" + this.getNumIterations() + ", maxNumLineSearchIterations=" + this.getMaxNumLineSearchIterations() + ", seed=" + this.getSeed() + ", useRegularization=" + this.isUseRegularization() + ", optimizationAlgo=" + (Object)((Object)this.getOptimizationAlgo()) + ", stepFunction=" + this.getStepFunction() + ", useDropConnect=" + this.isUseDropConnect() + ", minimize=" + this.isMinimize() + ", gradientNormalization=" + (Object)((Object)this.getGradientNormalization()) + ", gradientNormalizationThreshold=" + this.getGradientNormalizationThreshold() + ", learningRatePolicy=" + (Object)((Object)this.getLearningRatePolicy()) + ", lrPolicyDecayRate=" + this.getLrPolicyDecayRate() + ", lrPolicySteps=" + this.getLrPolicySteps() + ", lrPolicyPower=" + this.getLrPolicyPower() + ", convolutionMode=" + (Object)((Object)this.getConvolutionMode()) + ")";
        }
    }

    public static class ListBuilder
    extends MultiLayerConfiguration.Builder {
        private Map<Integer, Builder> layerwise;
        private Builder globalConfig;

        public ListBuilder(Builder globalConfig, Map<Integer, Builder> layerMap) {
            this.globalConfig = globalConfig;
            this.layerwise = layerMap;
        }

        public ListBuilder(Builder globalConfig) {
            this(globalConfig, new HashMap<Integer, Builder>());
        }

        @Override
        public ListBuilder backprop(boolean backprop) {
            this.backprop = backprop;
            return this;
        }

        @Override
        public ListBuilder pretrain(boolean pretrain) {
            this.pretrain = pretrain;
            return this;
        }

        public ListBuilder layer(int ind, Layer layer) {
            if (this.layerwise.containsKey(ind)) {
                this.layerwise.get(ind).layer(layer);
            } else {
                this.layerwise.put(ind, this.globalConfig.clone().layer(layer));
            }
            return this;
        }

        public Map<Integer, Builder> getLayerwise() {
            return this.layerwise;
        }

        @Override
        public MultiLayerConfiguration build() {
            ArrayList<NeuralNetConfiguration> list = new ArrayList<NeuralNetConfiguration>();
            if (this.layerwise.isEmpty()) {
                throw new IllegalStateException("Invalid configuration: no layers defined");
            }
            for (int i = 0; i < this.layerwise.size(); ++i) {
                if (this.layerwise.get(i) == null) {
                    throw new IllegalStateException("Invalid configuration: layer number " + i + " not specified. Expect layer numbers to be 0 to " + (this.layerwise.size() - 1) + " inclusive (number of layers defined: " + this.layerwise.size() + ")");
                }
                if (this.layerwise.get(i).getLayer() == null) {
                    throw new IllegalStateException("Cannot construct network: Layer config forlayer with index " + i + " is not defined)");
                }
                list.add(this.layerwise.get(i).build());
            }
            return new MultiLayerConfiguration.Builder().backprop(this.backprop).inputPreProcessors(this.inputPreProcessors).pretrain(this.pretrain).backpropType(this.backpropType).tBPTTForwardLength(this.tbpttFwdLength).tBPTTBackwardLength(this.tbpttBackLength).cnnInputSize(this.cnnInputSize).setInputType(this.inputType).confs(list).build();
        }
    }
}

