/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.lossfunctions.LossFunctions;
import org.nd4j.linalg.lossfunctions.impl.LossBinaryXENT;
import org.nd4j.linalg.lossfunctions.impl.LossMCXENT;
import org.nd4j.linalg.lossfunctions.impl.LossMSE;
import org.nd4j.linalg.lossfunctions.impl.LossNegativeLogLikelihood;

public abstract class BaseOutputLayer
extends FeedForwardLayer {
    protected ILossFunction lossFn;
    @Deprecated
    protected String customLossFunction;

    protected BaseOutputLayer(Builder builder) {
        super(builder);
        this.lossFn = builder.lossFn;
        this.customLossFunction = builder.customLossFunction;
    }

    @Deprecated
    public LossFunctions.LossFunction getLossFunction() {
        if (this.lossFn instanceof LossNegativeLogLikelihood) {
            return LossFunctions.LossFunction.NEGATIVELOGLIKELIHOOD;
        }
        if (this.lossFn instanceof LossMCXENT) {
            return LossFunctions.LossFunction.MCXENT;
        }
        if (this.lossFn instanceof LossMSE) {
            return LossFunctions.LossFunction.MSE;
        }
        if (this.lossFn instanceof LossBinaryXENT) {
            return LossFunctions.LossFunction.XENT;
        }
        return null;
    }

    public ILossFunction getLossFn() {
        return this.lossFn;
    }

    @Deprecated
    public String getCustomLossFunction() {
        return this.customLossFunction;
    }

    public void setLossFn(ILossFunction lossFn) {
        this.lossFn = lossFn;
    }

    @Deprecated
    public void setCustomLossFunction(String customLossFunction) {
        this.customLossFunction = customLossFunction;
    }

    public BaseOutputLayer() {
    }

    @Override
    public String toString() {
        return "BaseOutputLayer(super=" + super.toString() + ", lossFn=" + this.getLossFn() + ", customLossFunction=" + this.getCustomLossFunction() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseOutputLayer)) {
            return false;
        }
        BaseOutputLayer other = (BaseOutputLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ILossFunction this$lossFn = this.getLossFn();
        ILossFunction other$lossFn = other.getLossFn();
        if (this$lossFn == null ? other$lossFn != null : !this$lossFn.equals(other$lossFn)) {
            return false;
        }
        String this$customLossFunction = this.getCustomLossFunction();
        String other$customLossFunction = other.getCustomLossFunction();
        return !(this$customLossFunction == null ? other$customLossFunction != null : !this$customLossFunction.equals(other$customLossFunction));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseOutputLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        ILossFunction $lossFn = this.getLossFn();
        result = result * 59 + ($lossFn == null ? 0 : $lossFn.hashCode());
        String $customLossFunction = this.getCustomLossFunction();
        result = result * 59 + ($customLossFunction == null ? 0 : $customLossFunction.hashCode());
        return result;
    }

    public static abstract class Builder<T extends Builder<T>>
    extends FeedForwardLayer.Builder<T> {
        protected ILossFunction lossFn = new LossMCXENT();
        @Deprecated
        protected String customLossFunction;

        public Builder() {
        }

        public Builder(LossFunctions.LossFunction lossFunction) {
            this.lossFunction(lossFunction);
        }

        public Builder(ILossFunction lossFunction) {
            this.lossFn = lossFunction;
        }

        public T lossFunction(LossFunctions.LossFunction lossFunction) {
            return this.lossFunction(lossFunction.getILossFunction());
        }

        public T lossFunction(ILossFunction lossFunction) {
            this.lossFn = lossFunction;
            return (T)this;
        }

        @Deprecated
        public T customLossFunction(String customLossFunction) {
            this.customLossFunction = customLossFunction;
            return (T)this;
        }
    }
}

