/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.movingwindow;

import java.util.ArrayList;
import java.util.List;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.berkeley.StringUtils;
import org.deeplearning4j.text.tokenization.tokenizer.Tokenizer;
import org.deeplearning4j.text.tokenization.tokenizerfactory.TokenizerFactory;
import org.deeplearning4j.util.MultiDimensionalMap;

public class ContextLabelRetriever {
    private static String BEGIN_LABEL = "<([A-Za-z]+|\\d+)>";
    private static String END_LABEL = "</([A-Za-z]+|\\d+)>";

    private ContextLabelRetriever() {
    }

    public static Pair<String, MultiDimensionalMap<Integer, Integer, String>> stringWithLabels(String sentence, TokenizerFactory tokenizerFactory) {
        MultiDimensionalMap map = MultiDimensionalMap.newHashBackedMap();
        Tokenizer t = tokenizerFactory.create(sentence);
        ArrayList<String> currTokens = new ArrayList<String>();
        String currLabel = null;
        String endLabel = null;
        ArrayList<Pair> tokensWithSameLabel = new ArrayList<Pair>();
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if (token.matches(BEGIN_LABEL)) {
                if (endLabel != null) {
                    throw new IllegalStateException("Tried parsing sentence; found an end label when the begin label has not been cleared");
                }
                currLabel = token;
                if (!currTokens.isEmpty()) {
                    tokensWithSameLabel.add(new Pair((Object)"NONE", new ArrayList(currTokens)));
                    currTokens.clear();
                }
            } else if (token.matches(END_LABEL)) {
                if (currLabel == null) {
                    throw new IllegalStateException("Found an ending label with no matching begin label");
                }
                endLabel = token;
            } else {
                currTokens.add(token);
            }
            if (currLabel == null || endLabel == null) continue;
            currLabel = currLabel.replaceAll("[<>/]", "");
            endLabel = endLabel.replaceAll("[<>/]", "");
            assert (!currLabel.isEmpty()) : "Current label is empty!";
            assert (!endLabel.isEmpty()) : "End label is empty!";
            assert (currLabel.equals(endLabel)) : "Current label begin and end did not match for the parse. Was: " + currLabel + " ending with " + endLabel;
            tokensWithSameLabel.add(new Pair((Object)currLabel, new ArrayList(currTokens)));
            currTokens.clear();
            currLabel = null;
            endLabel = null;
        }
        if (!currTokens.isEmpty()) {
            tokensWithSameLabel.add(new Pair((Object)"none", new ArrayList(currTokens)));
            currTokens.clear();
        }
        StringBuilder strippedSentence = new StringBuilder();
        for (Pair tokensWithLabel : tokensWithSameLabel) {
            String joinedSentence = StringUtils.join((List)((List)tokensWithLabel.getSecond()), (String)" ");
            if (strippedSentence.length() >= 1) {
                strippedSentence.append(" ");
            }
            strippedSentence.append(joinedSentence);
            int begin = strippedSentence.toString().indexOf(joinedSentence);
            int end = begin + joinedSentence.length();
            map.put((Object)begin, (Object)end, tokensWithLabel.getFirst());
        }
        return new Pair((Object)strippedSentence.toString(), (Object)map);
    }
}

