/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.tokenization.tokenizer;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.deeplearning4j.text.tokenization.tokenizer.TokenPreProcess;
import org.deeplearning4j.text.tokenization.tokenizer.Tokenizer;

public class DefaultTokenizer
implements Tokenizer {
    private StringTokenizer tokenizer;
    private TokenPreProcess tokenPreProcess;

    public DefaultTokenizer(String tokens) {
        this.tokenizer = new StringTokenizer(tokens);
    }

    @Override
    public boolean hasMoreTokens() {
        return this.tokenizer.hasMoreTokens();
    }

    @Override
    public int countTokens() {
        return this.tokenizer.countTokens();
    }

    @Override
    public String nextToken() {
        String base = this.tokenizer.nextToken();
        if (this.tokenPreProcess != null) {
            base = this.tokenPreProcess.preProcess(base);
        }
        return base;
    }

    @Override
    public List<String> getTokens() {
        ArrayList<String> tokens = new ArrayList<String>();
        while (this.hasMoreTokens()) {
            tokens.add(this.nextToken());
        }
        return tokens;
    }

    @Override
    public void setTokenPreProcessor(TokenPreProcess tokenPreProcessor) {
        this.tokenPreProcess = tokenPreProcessor;
    }
}

