/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.sentenceiterator;

import java.util.Collection;
import java.util.Iterator;
import org.deeplearning4j.text.sentenceiterator.BaseSentenceIterator;
import org.deeplearning4j.text.sentenceiterator.SentencePreProcessor;

public class CollectionSentenceIterator
extends BaseSentenceIterator {
    private Iterator<String> iter;
    private Collection<String> coll;

    public CollectionSentenceIterator(SentencePreProcessor preProcessor, Collection<String> coll) {
        super(preProcessor);
        this.coll = coll;
        this.iter = coll.iterator();
    }

    public CollectionSentenceIterator(Collection<String> coll) {
        this(null, coll);
    }

    @Override
    public String nextSentence() {
        String ret = this.iter.next();
        if (this.getPreProcessor() != null) {
            ret = this.getPreProcessor().preProcess(ret);
        }
        return ret;
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public void reset() {
        this.iter = this.coll.iterator();
    }
}

