/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.scaleout.perform.models.glove.iterator;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.deeplearning4j.bagofwords.vectorizer.TextVectorizer;
import org.deeplearning4j.models.glove.GloveWeightLookupTable;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.models.word2vec.wordstore.inmemory.InMemoryLookupCache;
import org.deeplearning4j.scaleout.api.statetracker.NewUpdateListener;
import org.deeplearning4j.scaleout.api.statetracker.StateTracker;
import org.deeplearning4j.scaleout.job.Job;
import org.deeplearning4j.scaleout.job.JobIterator;
import org.deeplearning4j.scaleout.perform.models.word2vec.Word2VecResult;
import org.deeplearning4j.scaleout.perform.models.word2vec.Word2VecWork;
import org.deeplearning4j.text.invertedindex.InvertedIndex;

public class GloveJobIterator
implements JobIterator {
    private Iterator<List<List<VocabWord>>> sentenceIterator;
    private GloveWeightLookupTable table;
    private VocabCache cache;
    private int batchSize = 100;

    public GloveJobIterator(Iterator<List<List<VocabWord>>> sentenceIterator, GloveWeightLookupTable table, VocabCache cache, StateTracker stateTracker, int batchSize) {
        this.sentenceIterator = sentenceIterator;
        this.table = table;
        this.cache = cache;
        this.addListener(stateTracker);
        this.batchSize = batchSize;
    }

    public GloveJobIterator(TextVectorizer textVectorizer, GloveWeightLookupTable table, VocabCache cache, StateTracker stateTracker, int batchSize) {
        this.sentenceIterator = textVectorizer.index().batchIter(batchSize);
        this.cache = cache;
        this.table = table;
        this.addListener(stateTracker);
        this.batchSize = batchSize;
    }

    public GloveJobIterator(Iterator<List<List<VocabWord>>> sentenceIterator, GloveWeightLookupTable table, VocabCache cache, StateTracker stateTracker) {
        this.sentenceIterator = sentenceIterator;
        this.table = table;
        this.cache = cache;
        this.addListener(stateTracker);
    }

    public GloveJobIterator(TextVectorizer textVectorizer, GloveWeightLookupTable table, VocabCache cache, StateTracker stateTracker) {
        this.sentenceIterator = textVectorizer.index().batchIter(this.batchSize);
        this.cache = cache;
        this.table = table;
        this.addListener(stateTracker);
    }

    public GloveJobIterator(InvertedIndex invertedIndex, GloveWeightLookupTable table, VocabCache cache, StateTracker stateTracker, int batchSize) {
        this.sentenceIterator = invertedIndex.batchIter(batchSize);
        this.cache = cache;
        this.table = table;
        this.batchSize = batchSize;
        this.addListener(stateTracker);
    }

    private void addListener(StateTracker stateTracker) {
        stateTracker.addUpdateListener(new NewUpdateListener(){

            public void onUpdate(Serializable update) {
                Job j = (Job)update;
                Collection work = (Collection)((Object)j.getResult());
                if (work == null || work.isEmpty()) {
                    return;
                }
                GloveWeightLookupTable l = GloveJobIterator.this.table;
                for (Word2VecResult work1 : work) {
                    for (String s : work1.getSyn0Change().keySet()) {
                        l.getSyn0().putRow(GloveJobIterator.this.cache.indexOf(s), work1.getSyn0Change().get(s));
                        l.getSyn1().putRow(GloveJobIterator.this.cache.indexOf(s), work1.getSyn1Change().get(s));
                        if (l.getSyn1Neg() == null) continue;
                        l.getSyn1Neg().putRow(GloveJobIterator.this.cache.indexOf(s), work1.getNegativeChange().get(s));
                    }
                }
            }
        });
    }

    private Word2VecWork create(List<List<VocabWord>> sentence) {
        if (this.cache == null) {
            throw new IllegalStateException("Unable to create work; no vocab found");
        }
        if (this.table == null) {
            throw new IllegalStateException("Unable to create work; no table found");
        }
        if (sentence == null) {
            throw new IllegalArgumentException("Unable to create work from null sentence");
        }
        Word2VecWork work = new Word2VecWork(this.table, (InMemoryLookupCache)this.cache, sentence);
        return work;
    }

    public Job next(String workerId) {
        List<List<VocabWord>> next = this.sentenceIterator.next();
        return new Job((Serializable)this.create(next), workerId);
    }

    public Job next() {
        List<List<VocabWord>> next = this.sentenceIterator.next();
        return new Job((Serializable)this.create(next), "");
    }

    public boolean hasNext() {
        return this.sentenceIterator.hasNext();
    }

    public void reset() {
    }
}

