/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.invertedindex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.text.invertedindex.InvertedIndex;

public class DefaultInvertedIndex
implements InvertedIndex {
    private Map<Integer, List<VocabWord>> docToWord = new ConcurrentHashMap<Integer, List<VocabWord>>();
    private Map<VocabWord, List<Integer>> wordToDocs = new ConcurrentHashMap<VocabWord, List<Integer>>();

    @Override
    public List<VocabWord> document(int index) {
        return this.docToWord.get(index);
    }

    @Override
    public List<Integer> documents(VocabWord vocabWord) {
        return this.wordToDocs.get(vocabWord);
    }

    @Override
    public int numDocuments() {
        return this.docToWord.size();
    }

    @Override
    public Collection<Integer> allDocs() {
        return this.docToWord.keySet();
    }

    @Override
    public void addWordToDoc(int doc, VocabWord word) {
        List<VocabWord> wordsForDoc = this.docToWord.get(doc);
        if (wordsForDoc == null) {
            wordsForDoc = Collections.synchronizedList(new ArrayList());
            this.docToWord.put(doc, wordsForDoc);
        }
        wordsForDoc.add(word);
        List<Integer> docList = this.wordToDocs.get(word);
        if (docList != null) {
            docList.add(doc);
        } else {
            docList = Collections.synchronizedList(new ArrayList());
            docList.add(doc);
            this.wordToDocs.put(word, docList);
        }
    }

    @Override
    public void addWordsToDoc(int doc, List<VocabWord> words) {
        List<VocabWord> wordsForDoc = this.docToWord.get(doc);
        if (wordsForDoc == null) {
            wordsForDoc = words;
            this.docToWord.put(doc, wordsForDoc);
        }
        for (VocabWord word : words) {
            List<Integer> docList = this.wordToDocs.get(word);
            if (docList != null) {
                docList.add(doc);
                continue;
            }
            docList = new CopyOnWriteArrayList<Integer>();
            docList.add(doc);
            this.wordToDocs.put(word, docList);
        }
    }

    @Override
    public void finish() {
    }
}

