/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.sentenceiterator;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.deeplearning4j.text.sentenceiterator.BaseSentenceIterator;
import org.deeplearning4j.text.sentenceiterator.SentencePreProcessor;

public class FileSentenceIterator
extends BaseSentenceIterator {
    protected volatile Iterator<File> fileIterator;
    protected volatile Queue<String> cache;
    protected volatile LineIterator currLineIterator;
    protected volatile File file;
    protected volatile File currentFile;

    public FileSentenceIterator(SentencePreProcessor preProcessor, File file) {
        super(preProcessor);
        this.file = file;
        this.cache = new ConcurrentLinkedDeque<String>();
        this.fileIterator = file.isDirectory() ? FileUtils.iterateFiles((File)file, null, (boolean)true) : Arrays.asList(file).iterator();
    }

    public FileSentenceIterator(File dir) {
        this(null, dir);
    }

    @Override
    public String nextSentence() {
        String line;
        String ret = null;
        if (!this.cache.isEmpty()) {
            ret = this.cache.poll();
            if (this.preProcessor != null) {
                ret = this.preProcessor.preProcess(ret);
            }
            return ret;
        }
        if (this.currLineIterator == null || !this.currLineIterator.hasNext()) {
            this.nextLineIter();
        }
        for (int i = 0; i < 100000 && this.currLineIterator != null && this.currLineIterator.hasNext() && (line = this.currLineIterator.nextLine()) != null; ++i) {
            this.cache.add(line);
        }
        if (!this.cache.isEmpty()) {
            ret = this.cache.poll();
            if (this.preProcessor != null) {
                ret = this.preProcessor.preProcess(ret);
            }
            return ret;
        }
        if (ret == null) {
            if (!this.cache.isEmpty()) {
                ret = this.cache.poll();
            } else {
                return null;
            }
        }
        return ret;
    }

    private void nextLineIter() {
        if (this.fileIterator.hasNext()) {
            try {
                File next;
                this.currentFile = next = this.fileIterator.next();
                if (next.getAbsolutePath().endsWith(".gz")) {
                    if (this.currLineIterator != null) {
                        this.currLineIterator.close();
                    }
                    this.currLineIterator = IOUtils.lineIterator((InputStream)new BufferedInputStream(new GZIPInputStream(new FileInputStream(next))), (String)"UTF-8");
                } else {
                    if (this.currLineIterator != null) {
                        this.currLineIterator.close();
                    }
                    this.currLineIterator = FileUtils.lineIterator((File)next);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.currLineIterator != null && this.currLineIterator.hasNext() || this.fileIterator.hasNext() || !this.cache.isEmpty();
    }

    @Override
    public void reset() {
        this.fileIterator = this.file.isFile() ? Arrays.asList(this.file).iterator() : FileUtils.iterateFiles((File)this.file, null, (boolean)true);
    }
}

