/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.invertedindex;

import com.google.common.base.Function;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.Version;
import org.deeplearning4j.berkeley.StringUtils;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.text.invertedindex.InvertedIndex;
import org.deeplearning4j.text.stopwords.StopWords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneInvertedIndex
implements InvertedIndex,
IndexReader.ReaderClosedListener,
Iterator<List<VocabWord>> {
    private transient Directory dir;
    private transient IndexReader reader;
    private transient Analyzer analyzer;
    private transient IndexSearcher searcher;
    private VocabCache vocabCache;
    public static final String WORD_FIELD = "word";
    private int numDocs = 0;
    private List<List<VocabWord>> words = new ArrayList<List<VocabWord>>();
    private boolean cache = true;
    private transient ExecutorService indexManager;
    private AtomicBoolean indexBeingCreated = new AtomicBoolean(false);
    private static Logger log = LoggerFactory.getLogger(LuceneInvertedIndex.class);
    public static final String INDEX_PATH = "word2vec-index";
    private AtomicBoolean readerClosed = new AtomicBoolean(false);
    private AtomicInteger totalWords = new AtomicInteger(0);
    private int batchSize = 1000;
    private List<List<VocabWord>> miniBatches = new CopyOnWriteArrayList<List<VocabWord>>();
    private List<VocabWord> currMiniBatch = Collections.synchronizedList(new ArrayList());
    private double sample = 0.0;
    private AtomicLong nextRandom = new AtomicLong(5L);
    private String indexPath = "word2vec-index";
    private Queue<List<VocabWord>> miniBatchDocs = new ConcurrentLinkedDeque<List<VocabWord>>();
    private AtomicBoolean miniBatchGoing = new AtomicBoolean(true);
    private boolean miniBatch = false;
    private static Map<String, IndexWriter> writer = new ConcurrentHashMap<String, IndexWriter>();
    public static final String DEFAULT_INDEX_DIR = "word2vec-index";

    public LuceneInvertedIndex(VocabCache vocabCache, boolean cache) {
        this(vocabCache, cache, "word2vec-index");
    }

    public LuceneInvertedIndex(VocabCache vocabCache, boolean cache, String indexPath) {
        this.vocabCache = vocabCache;
        this.cache = cache;
        this.indexPath = indexPath;
    }

    private LuceneInvertedIndex() {
        this(null, false, "word2vec-index");
    }

    @Override
    public double sample() {
        return this.sample;
    }

    @Override
    public Iterator<List<VocabWord>> miniBatches() {
        return this;
    }

    @Override
    public List<VocabWord> document(int index) {
        if (this.cache) {
            List<VocabWord> ret = this.words.get(index);
            ArrayList<VocabWord> ret2 = new ArrayList<VocabWord>();
            for (VocabWord word : ret) {
                if (!this.vocabCache.containsWord(word.getWord())) continue;
                ret2.add(word);
            }
            return ret2;
        }
        CopyOnWriteArrayList<VocabWord> ret = new CopyOnWriteArrayList<VocabWord>();
        try {
            String[] values;
            IndexWriter writer = this.getWriter();
            this.initReader(writer);
            Document doc = this.reader.document(index);
            for (String s : values = doc.getValues(WORD_FIELD)) {
                ret.add(this.vocabCache.wordFor(s));
            }
        }
        catch (AlreadyClosedException e1) {
            this.reader = null;
            this.readerClosed.set(false);
            return this.document(index);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public int[] documents(VocabWord vocabWord) {
        try {
            TermQuery query = new TermQuery(new Term(WORD_FIELD, vocabWord.getWord()));
            TopDocs topdocs = this.searcher.search((Query)query, Integer.MAX_VALUE);
            int[] ret = new int[topdocs.totalHits];
            for (int i = 0; i < topdocs.totalHits; ++i) {
                ret[i] = topdocs.scoreDocs[i].doc;
            }
            return ret;
        }
        catch (AlreadyClosedException e) {
            return this.documents(vocabWord);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int numDocuments() {
        int ret;
        if (this.numDocs > 0) {
            return this.numDocs;
        }
        try {
            IndexWriter writer = this.getWriter();
            this.initReader(writer);
            ret = this.reader.numDocs();
        }
        catch (Exception e) {
            return 0;
        }
        return ret;
    }

    @Override
    public int[] allDocs() {
        if (this.cache) {
            int[] ret = new int[this.words.size()];
            for (int i = 0; i < this.words.size(); ++i) {
                ret[i] = i;
            }
            return ret;
        }
        int[] docIds = new int[this.reader.maxDoc() + 1];
        int count = 0;
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)this.reader);
        for (int i = 0; i < this.reader.maxDoc(); ++i) {
            if (liveDocs != null && !liveDocs.get(i)) continue;
            if (count > docIds.length) {
                int[] newCopy = new int[docIds.length * 2];
                System.arraycopy(docIds, 0, newCopy, 0, docIds.length);
                docIds = newCopy;
                log.info("Reallocating doc ids");
            }
            docIds[count++] = i;
        }
        return docIds;
    }

    @Override
    public void addWordToDoc(int doc, VocabWord word) {
        TextField f = new TextField(WORD_FIELD, word.getWord(), Field.Store.YES);
        IndexWriter writer = this.getWriter();
        try {
            this.initReader(writer);
            Document doc2 = this.searcher.doc(doc);
            if (doc2 != null) {
                doc2.add((IndexableField)f);
            } else {
                Document d = new Document();
                d.add((IndexableField)f);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.initReader(writer);
    }

    private synchronized void initReader(IndexWriter writer) {
        if (this.reader == null) {
            try {
                writer.commit();
                this.reader = DirectoryReader.open((Directory)this.dir);
                this.searcher = new IndexSearcher(this.reader);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.readerClosed.get()) {
            try {
                this.reader = DirectoryReader.open((Directory)this.dir);
                this.searcher = new IndexSearcher(this.reader);
                this.readerClosed.set(false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void addWordsToDoc(int doc, List<VocabWord> words) {
        Document d = new Document();
        for (VocabWord word : words) {
            d.add((IndexableField)new TextField(WORD_FIELD, word.getWord(), Field.Store.YES));
        }
        IndexWriter writer = this.getWriter();
        this.initReader(writer);
        this.totalWords.set(this.totalWords.get() + words.size());
        this.addWords(words);
    }

    private void addWords(List<VocabWord> words) {
        if (!this.miniBatch) {
            return;
        }
        for (VocabWord word : words) {
            if (this.sample > 0.0) {
                double ran = (Math.sqrt(word.getWordFrequency() / (this.sample * (double)this.numDocuments())) + 1.0) * (this.sample * (double)this.numDocuments()) / word.getWordFrequency();
                if (ran < (double)(this.nextRandom.get() & 0xFFFFL) / 65536.0) continue;
                this.currMiniBatch.add(word);
                continue;
            }
            this.currMiniBatch.add(word);
            if (this.currMiniBatch.size() < this.batchSize) continue;
            this.miniBatches.add(new ArrayList<VocabWord>(this.currMiniBatch));
            this.currMiniBatch.clear();
        }
    }

    private void ensureDirExists() throws Exception {
        if (this.dir == null) {
            this.dir = FSDirectory.open((File)new File(this.indexPath));
            File dir2 = new File(this.indexPath);
            if (!dir2.exists()) {
                dir2.mkdir();
            }
        }
    }

    private synchronized IndexWriter getWriter() {
        IndexWriter writer;
        block14: {
            if (LuceneInvertedIndex.writer.containsKey(this.indexPath)) {
                return LuceneInvertedIndex.writer.get(this.indexPath);
            }
            writer = null;
            try {
                if (this.analyzer == null) {
                    this.analyzer = new StandardAnalyzer((Reader)new InputStreamReader(new ByteArrayInputStream("".getBytes())));
                }
                IndexWriterConfig iwc = new IndexWriterConfig(Version.LATEST, this.analyzer);
                this.ensureDirExists();
                if (!this.indexBeingCreated.get()) {
                    this.indexBeingCreated.set(true);
                    if (IndexWriter.isLocked((Directory)this.dir)) {
                        try {
                            IndexWriter.unlock((Directory)this.dir);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                    writer = new IndexWriter(this.dir, iwc);
                    LuceneInvertedIndex.writer.put(this.indexPath, writer);
                    break block14;
                }
                if (this.indexBeingCreated.get() && writer != null) break block14;
                this.indexBeingCreated.set(true);
                if (IndexWriter.isLocked((Directory)this.dir)) {
                    try {
                        IndexWriter.unlock((Directory)this.dir);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                iwc = new IndexWriterConfig(Version.LATEST, this.analyzer);
                writer = new IndexWriter(this.dir, iwc);
                LuceneInvertedIndex.writer.put(this.indexPath, writer);
            }
            catch (LockObtainFailedException e) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                return this.getWriter();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to created writer", e);
            }
        }
        return writer;
    }

    @Override
    public void finish() {
        this.reader = null;
        IndexWriter writer = this.getWriter();
        this.initReader(writer);
        this.numDocs = this.reader.numDocs();
    }

    @Override
    public int totalWords() {
        return this.totalWords.get();
    }

    @Override
    public int batchSize() {
        return this.batchSize;
    }

    @Override
    public void eachDoc(final Function<List<VocabWord>, Void> func, ExecutorService exec) {
        int[] docIds;
        int[] nArray = docIds = this.allDocs();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int i2;
            final int j = i2 = nArray[i];
            exec.execute(new Runnable(){

                @Override
                public void run() {
                    func.apply(LuceneInvertedIndex.this.document(j));
                }
            });
        }
    }

    public void onClose(IndexReader reader) {
        this.readerClosed.set(true);
    }

    @Override
    public boolean hasNext() {
        if (!this.miniBatch) {
            throw new IllegalStateException("Mini batch mode turned off");
        }
        return !this.miniBatchDocs.isEmpty() || this.miniBatchGoing.get();
    }

    @Override
    public List<VocabWord> next() {
        if (!this.miniBatch) {
            throw new IllegalStateException("Mini batch mode turned off");
        }
        if (!this.miniBatches.isEmpty()) {
            return this.miniBatches.remove(0);
        }
        if (this.miniBatchGoing.get()) {
            while (this.miniBatches.isEmpty()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                log.warn("Waiting on more data...");
                if (this.miniBatches.isEmpty()) continue;
                return this.miniBatches.remove(0);
            }
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class Builder {
        private File indexDir;
        private Directory dir;
        private IndexReader reader;
        private Analyzer analyzer;
        private IndexSearcher searcher;
        private IndexWriter writer;
        private IndexWriterConfig iwc;
        private VocabCache vocabCache;
        private List<String> stopWords;
        private boolean cache;
        private int batchSize;
        private double sample;
        private boolean miniBatch;

        public Builder() {
            this.iwc = new IndexWriterConfig(Version.LUCENE_4_10_0, this.analyzer);
            this.stopWords = StopWords.getStopWords();
            this.cache = true;
            this.batchSize = 1000;
            this.sample = 0.0;
            this.miniBatch = false;
        }

        public Builder miniBatch(boolean miniBatch) {
            this.miniBatch = miniBatch;
            return this;
        }

        public Builder cacheInRam(boolean cache) {
            this.cache = cache;
            return this;
        }

        public Builder sample(double sample) {
            this.sample = sample;
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder indexDir(File indexDir) {
            this.indexDir = indexDir;
            return this;
        }

        public Builder cache(VocabCache cache) {
            this.vocabCache = cache;
            return this;
        }

        public Builder stopWords(List<String> stopWords) {
            this.stopWords = stopWords;
            return this;
        }

        public Builder dir(Directory dir) {
            this.dir = dir;
            return this;
        }

        public Builder reader(IndexReader reader) {
            this.reader = reader;
            return this;
        }

        public Builder writer(IndexWriter writer) {
            this.writer = writer;
            return this;
        }

        public Builder analyzer(Analyzer analyzer) {
            this.analyzer = analyzer;
            return this;
        }

        public InvertedIndex build() {
            LuceneInvertedIndex ret = new LuceneInvertedIndex();
            try {
                if (this.analyzer == null) {
                    this.analyzer = new StandardAnalyzer((Reader)new InputStreamReader(new ByteArrayInputStream(StringUtils.join(this.stopWords, (String)"\n").getBytes())));
                }
                if (this.indexDir != null && this.dir != null) {
                    throw new IllegalStateException("Please define only a directory or a file directory");
                }
                if (this.iwc == null) {
                    this.iwc = new IndexWriterConfig(Version.LATEST, this.analyzer);
                }
                if (this.indexDir != null && !this.cache) {
                    if (!this.indexDir.exists()) {
                        this.indexDir.mkdirs();
                    }
                    this.dir = FSDirectory.open((File)this.indexDir);
                    if (this.writer == null) {
                        this.writer = new IndexWriter(this.dir, this.iwc);
                    }
                }
                if (this.vocabCache == null) {
                    throw new IllegalStateException("Vocab cache must not be null");
                }
                ret.batchSize = this.batchSize;
                ret.vocabCache = this.vocabCache;
                ret.dir = this.dir;
                ret.cache = this.cache;
                ret.miniBatch = this.miniBatch;
                ret.reader = this.reader;
                ret.searcher = this.searcher;
                ret.analyzer = this.analyzer;
                ret.vocabCache = this.vocabCache;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }
    }
}

