/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.movingwindow;

import java.util.ArrayList;
import java.util.List;
import org.deeplearning4j.models.word2vec.Word2Vec;
import org.deeplearning4j.text.movingwindow.Window;
import org.deeplearning4j.text.movingwindow.WindowConverter;
import org.deeplearning4j.text.movingwindow.Windows;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.FeatureUtil;

public class WordConverter {
    private List<String> sentences = new ArrayList<String>();
    private Word2Vec vec;
    private List<Window> windows;

    public WordConverter(List<String> sentences, Word2Vec vec) {
        this.sentences = sentences;
        this.vec = vec;
    }

    public static INDArray toInputMatrix(List<Window> windows, Word2Vec vec) {
        int columns = vec.getLayerSize() * vec.getWindow();
        int rows = windows.size();
        INDArray ret = Nd4j.create((int)rows, (int)columns);
        for (int i = 0; i < rows; ++i) {
            ret.putRow(i, Nd4j.create((double[])WindowConverter.asExample(windows.get(i), vec)));
        }
        return ret;
    }

    public INDArray toInputMatrix() {
        List<Window> windows = this.allWindowsForAllSentences();
        return WordConverter.toInputMatrix(windows, this.vec);
    }

    public static INDArray toLabelMatrix(List<String> labels, List<Window> windows) {
        int columns = labels.size();
        INDArray ret = Nd4j.create((int)windows.size(), (int)columns);
        for (int i = 0; i < ret.rows(); ++i) {
            ret.putRow(i, FeatureUtil.toOutcomeVector((int)labels.indexOf(windows.get(i).getLabel()), (int)labels.size()));
        }
        return ret;
    }

    public INDArray toLabelMatrix(List<String> labels) {
        List<Window> windows = this.allWindowsForAllSentences();
        return WordConverter.toLabelMatrix(labels, windows);
    }

    private List<Window> allWindowsForAllSentences() {
        if (this.windows != null) {
            return this.windows;
        }
        this.windows = new ArrayList<Window>();
        for (String s : this.sentences) {
            if (s.isEmpty()) continue;
            this.windows.addAll(Windows.windows(s));
        }
        return this.windows;
    }
}

