/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.movingwindow;

import java.util.List;
import org.deeplearning4j.models.word2vec.Word2Vec;
import org.deeplearning4j.text.movingwindow.Window;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class WindowConverter {
    public static INDArray asExampleArray(Window window, Word2Vec vec, boolean normalize) {
        int length = vec.getLayerSize();
        List<String> words = window.getWords();
        int windowSize = vec.getWindow();
        assert (words.size() == vec.getWindow());
        INDArray ret = Nd4j.create((int)(length * windowSize));
        for (int i = 0; i < words.size(); ++i) {
            String word = words.get(i);
            INDArray n = normalize ? vec.getWordVectorMatrixNormalized(word) : vec.getWordVectorMatrix(word);
            ret.put(new NDArrayIndex[]{NDArrayIndex.interval((int)(i * vec.getLayerSize()), (int)(i * vec.getLayerSize() + vec.getLayerSize()))}, n);
        }
        return ret;
    }

    public static double[] asExample(Window window, Word2Vec vec) {
        int length = vec.getLayerSize();
        List<String> words = window.getWords();
        int windowSize = window.getWindowSize();
        double[] example = new double[length * windowSize];
        int count = 0;
        for (int i = 0; i < words.size(); ++i) {
            double[] vec2;
            String word = words.get(i);
            INDArray n = vec.getWordVectorMatrixNormalized(word);
            double[] dArray = vec2 = n == null ? vec.getWordVectorMatrix("UNK").data().asDouble() : vec.getWordVectorMatrix(word).data().asDouble();
            if (vec2 == null) {
                vec2 = vec.getWordVectorMatrix("UNK").data().asDouble();
            }
            for (int j = 0; j < vec2.length; ++j) {
                example[count++] = vec2[j];
            }
        }
        return example;
    }

    public static INDArray asExampleMatrix(Window window, Word2Vec vec) {
        return Nd4j.create((double[])WindowConverter.asExample(window, vec));
    }
}

