/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.corpora.treeparser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.deeplearning4j.models.rntn.Tree;
import org.deeplearning4j.text.corpora.treeparser.TreeVectorizer;
import org.deeplearning4j.text.sentenceiterator.labelaware.LabelAwareSentenceIterator;

public class TreeIterator
implements Iterator<List<Tree>> {
    private LabelAwareSentenceIterator sentenceIterator;
    private List<String> labels;
    private TreeVectorizer treeVectorizer;
    private int batchSize = 3;

    public TreeIterator(LabelAwareSentenceIterator sentenceIterator, List<String> labels, TreeVectorizer treeVectorizer, int batchSize) {
        this.sentenceIterator = sentenceIterator;
        this.labels = labels;
        this.treeVectorizer = treeVectorizer;
        this.batchSize = batchSize;
    }

    public TreeIterator(LabelAwareSentenceIterator sentenceIterator, List<String> labels, TreeVectorizer treeVectorizer) {
        this.sentenceIterator = sentenceIterator;
        this.labels = labels;
        this.treeVectorizer = treeVectorizer;
        this.batchSize = labels.size();
    }

    public TreeIterator(LabelAwareSentenceIterator sentenceIterator, List<String> labels) throws Exception {
        this(sentenceIterator, labels, new TreeVectorizer());
    }

    @Override
    public boolean hasNext() {
        return this.sentenceIterator.hasNext();
    }

    @Override
    public List<Tree> next() {
        ArrayList<Tree> ret = new ArrayList<Tree>();
        try {
            for (int i = 0; i < this.batchSize; ++i) {
                if (!this.hasNext()) continue;
                ret.addAll(this.treeVectorizer.getTreesWithLabels(this.sentenceIterator.nextSentence(), this.sentenceIterator.currentLabel(), this.labels));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

