/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.recurrent;

import java.util.Map;
import org.deeplearning4j.nn.modelimport.keras.config.KerasLayerConfiguration;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils;

public class KerasRnnUtils {
    public static boolean getUnrollRecurrentLayer(KerasLayerConfiguration conf, Map<String, Object> layerConfig) throws InvalidKerasConfigurationException {
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, conf);
        if (!innerConfig.containsKey(conf.getLAYER_FIELD_UNROLL())) {
            throw new InvalidKerasConfigurationException("Keras LSTM layer config missing " + conf.getLAYER_FIELD_UNROLL() + " field");
        }
        return (Boolean)innerConfig.get(conf.getLAYER_FIELD_UNROLL());
    }

    public static double getRecurrentDropout(KerasLayerConfiguration conf, Map<String, Object> layerConfig) throws UnsupportedKerasConfigurationException, InvalidKerasConfigurationException {
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, conf);
        double dropout = 1.0;
        if (innerConfig.containsKey(conf.getLAYER_FIELD_DROPOUT_U())) {
            try {
                dropout = 1.0 - (Double)innerConfig.get(conf.getLAYER_FIELD_DROPOUT_U());
            }
            catch (Exception e) {
                int kerasDropout = (Integer)innerConfig.get(conf.getLAYER_FIELD_DROPOUT_U());
                dropout = 1.0 - (double)kerasDropout;
            }
        }
        if (dropout < 1.0) {
            throw new UnsupportedKerasConfigurationException("Dropout > 0 on recurrent connections not supported.");
        }
        return dropout;
    }
}

