/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.pooling;

import java.util.Map;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.Subsampling3DLayer;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolutionUtils;
import org.deeplearning4j.nn.modelimport.keras.layers.pooling.KerasPoolingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasPooling3D
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasPooling3D.class);

    public KerasPooling3D(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasPooling3D(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        Subsampling3DLayer.Builder builder = ((Subsampling3DLayer.Builder)((Subsampling3DLayer.Builder)((Subsampling3DLayer.Builder)new Subsampling3DLayer.Builder(KerasPoolingUtils.mapPoolingType(this.className, this.conf)).name(this.layerName)).dropOut(this.dropout)).convolutionMode(KerasConvolutionUtils.getConvolutionModeFromConfig(layerConfig, this.conf))).kernelSize(KerasConvolutionUtils.getKernelSizeFromConfig(layerConfig, 3, this.conf, this.kerasMajorVersion)).stride(KerasConvolutionUtils.getStrideFromConfig(layerConfig, 3, this.conf));
        int[] padding = KerasConvolutionUtils.getPaddingFromBorderModeConfig(layerConfig, 3, this.conf, this.kerasMajorVersion);
        if (padding != null) {
            builder.padding(padding);
        }
        this.layer = builder.build();
        this.vertex = null;
    }

    public Subsampling3DLayer getSubsampling3DLayer() {
        return (Subsampling3DLayer)this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Subsampling/Pooling 3D layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getSubsampling3DLayer().getOutputType(-1, inputType[0]);
    }
}

