/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.core;

import java.util.Map;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.preprocessor.CnnToFeedForwardPreProcessor;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.preprocessors.KerasFlattenRnnPreprocessor;
import org.deeplearning4j.nn.modelimport.keras.preprocessors.ReshapePreprocessor;
import org.deeplearning4j.nn.modelimport.keras.preprocessors.TensorFlowCnnToFeedForwardPreProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasFlatten
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasFlatten.class);

    public KerasFlatten(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasFlatten(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
    }

    @Override
    public boolean isInputPreProcessor() {
        return true;
    }

    @Override
    public InputPreProcessor getInputPreprocessor(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Flatten layer accepts only one input (received " + inputType.length + ")");
        }
        Object preprocessor = null;
        if (inputType[0] instanceof InputType.InputTypeConvolutional) {
            InputType.InputTypeConvolutional it = (InputType.InputTypeConvolutional)inputType[0];
            switch (this.getDimOrder()) {
                case NONE: 
                case THEANO: {
                    preprocessor = new CnnToFeedForwardPreProcessor(it.getHeight(), it.getWidth(), it.getChannels());
                    break;
                }
                case TENSORFLOW: {
                    preprocessor = new TensorFlowCnnToFeedForwardPreProcessor(it.getHeight(), it.getWidth(), it.getChannels());
                    break;
                }
                default: {
                    throw new InvalidKerasConfigurationException("Unknown Keras backend " + (Object)((Object)this.getDimOrder()));
                }
            }
        } else if (inputType[0] instanceof InputType.InputTypeRecurrent) {
            InputType.InputTypeRecurrent it = (InputType.InputTypeRecurrent)inputType[0];
            preprocessor = new KerasFlattenRnnPreprocessor(it.getSize(), it.getTimeSeriesLength());
        } else if (inputType[0] instanceof InputType.InputTypeFeedForward) {
            InputType.InputTypeFeedForward it = (InputType.InputTypeFeedForward)inputType[0];
            int[] inputShape = new int[]{it.getSize()};
            preprocessor = new ReshapePreprocessor(inputShape, inputShape);
        }
        return preprocessor;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Flatten layer accepts only one input (received " + inputType.length + ")");
        }
        InputPreProcessor preprocessor = this.getInputPreprocessor(inputType);
        if (preprocessor != null) {
            return preprocessor.getOutputType(inputType[0]);
        }
        return inputType[0];
    }
}

