/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.convolutional;

import java.util.HashMap;
import java.util.Map;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.SeparableConvolution2D;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolution;
import org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolutionUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasActivationUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasConstraintUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasInitilizationUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasRegularizerUtils;
import org.deeplearning4j.nn.weights.WeightInit;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasSeparableConvolution2D
extends KerasConvolution {
    private static final Logger log = LoggerFactory.getLogger(KerasSeparableConvolution2D.class);

    public KerasSeparableConvolution2D(Integer kerasVersion) throws UnsupportedKerasConfigurationException {
        super(kerasVersion);
    }

    public KerasSeparableConvolution2D(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasSeparableConvolution2D(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        this.hasBias = KerasLayerUtils.getHasBiasFromConfig(layerConfig, this.conf);
        this.numTrainableParams = this.hasBias ? 3 : 2;
        int[] dilationRate = KerasConvolutionUtils.getDilationRate(layerConfig, 2, this.conf, false);
        int depthMultiplier = KerasConvolutionUtils.getDepthMultiplier(layerConfig, this.conf);
        Pair<WeightInit, Distribution> depthWiseInit = KerasInitilizationUtils.getWeightInitFromConfig(layerConfig, this.conf.getLAYER_FIELD_DEPTH_WISE_INIT(), enforceTrainingConfig, this.conf, this.kerasMajorVersion);
        WeightInit depthWeightInit = (WeightInit)depthWiseInit.getFirst();
        Distribution depthDistribution = (Distribution)depthWiseInit.getSecond();
        Pair<WeightInit, Distribution> pointWiseInit = KerasInitilizationUtils.getWeightInitFromConfig(layerConfig, this.conf.getLAYER_FIELD_POINT_WISE_INIT(), enforceTrainingConfig, this.conf, this.kerasMajorVersion);
        WeightInit pointWeightInit = (WeightInit)pointWiseInit.getFirst();
        Distribution pointDistribution = (Distribution)pointWiseInit.getSecond();
        if (depthWeightInit != pointWeightInit || depthDistribution != pointDistribution) {
            if (enforceTrainingConfig) {
                throw new UnsupportedKerasConfigurationException("Specifying different initialization for depth- and point-wise weights not supported.");
            }
            log.warn("Specifying different initialization for depth- and point-wise  weights not supported.");
        }
        this.weightL1Regularization = KerasRegularizerUtils.getWeightRegularizerFromConfig(layerConfig, this.conf, this.conf.getLAYER_FIELD_DEPTH_WISE_REGULARIZER(), this.conf.getREGULARIZATION_TYPE_L1());
        this.weightL2Regularization = KerasRegularizerUtils.getWeightRegularizerFromConfig(layerConfig, this.conf, this.conf.getLAYER_FIELD_DEPTH_WISE_REGULARIZER(), this.conf.getREGULARIZATION_TYPE_L2());
        LayerConstraint biasConstraint = KerasConstraintUtils.getConstraintsFromConfig(layerConfig, this.conf.getLAYER_FIELD_B_CONSTRAINT(), this.conf, this.kerasMajorVersion);
        LayerConstraint depthWiseWeightConstraint = KerasConstraintUtils.getConstraintsFromConfig(layerConfig, this.conf.getLAYER_FIELD_DEPTH_WISE_CONSTRAINT(), this.conf, this.kerasMajorVersion);
        LayerConstraint pointWiseWeightConstraint = KerasConstraintUtils.getConstraintsFromConfig(layerConfig, this.conf.getLAYER_FIELD_POINT_WISE_CONSTRAINT(), this.conf, this.kerasMajorVersion);
        SeparableConvolution2D.Builder builder = ((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)((SeparableConvolution2D.Builder)new SeparableConvolution2D.Builder().name(this.layerName)).nOut(KerasLayerUtils.getNOutFromConfig(layerConfig, this.conf))).dropOut(this.dropout)).activation(KerasActivationUtils.getActivationFromConfig(layerConfig, this.conf))).weightInit(depthWeightInit)).depthMultiplier(depthMultiplier).l1(this.weightL1Regularization)).l2(this.weightL2Regularization)).convolutionMode(KerasConvolutionUtils.getConvolutionModeFromConfig(layerConfig, this.conf))).kernelSize(KerasConvolutionUtils.getKernelSizeFromConfig(layerConfig, 2, this.conf, this.kerasMajorVersion)).hasBias(this.hasBias)).stride(KerasConvolutionUtils.getStrideFromConfig(layerConfig, 2, this.conf));
        int[] padding = KerasConvolutionUtils.getPaddingFromBorderModeConfig(layerConfig, 2, this.conf, this.kerasMajorVersion);
        if (depthDistribution != null) {
            builder.dist(depthDistribution);
        }
        if (this.hasBias) {
            builder.biasInit(0.0);
        }
        if (padding != null) {
            builder.padding(padding);
        }
        if (dilationRate != null) {
            builder.dilation(dilationRate);
        }
        if (biasConstraint != null) {
            builder.constrainBias(new LayerConstraint[]{biasConstraint});
        }
        if (depthWiseWeightConstraint != null) {
            builder.constrainWeights(new LayerConstraint[]{depthWiseWeightConstraint});
        }
        if (pointWiseWeightConstraint != null) {
            builder.constrainPointWise(new LayerConstraint[]{pointWiseWeightConstraint});
        }
        this.layer = builder.build();
    }

    @Override
    public void setWeights(Map<String, INDArray> weights) throws InvalidKerasConfigurationException {
        this.weights = new HashMap();
        if (!weights.containsKey(this.conf.getLAYER_PARAM_NAME_DEPTH_WISE_KERNEL())) {
            throw new InvalidKerasConfigurationException("Keras SeparableConvolution2D layer does not contain parameter " + this.conf.getLAYER_PARAM_NAME_DEPTH_WISE_KERNEL());
        }
        INDArray dW = weights.get(this.conf.getLAYER_PARAM_NAME_DEPTH_WISE_KERNEL());
        this.weights.put("W", dW);
        if (!weights.containsKey(this.conf.getLAYER_PARAM_NAME_POINT_WISE_KERNEL())) {
            throw new InvalidKerasConfigurationException("Keras SeparableConvolution2D layer does not contain parameter " + this.conf.getLAYER_PARAM_NAME_POINT_WISE_KERNEL());
        }
        INDArray pW = weights.get(this.conf.getLAYER_PARAM_NAME_POINT_WISE_KERNEL());
        this.weights.put("pW", pW);
        if (this.hasBias) {
            INDArray bias;
            if (this.kerasMajorVersion == 2 && weights.containsKey("bias")) {
                bias = weights.get("bias");
            } else if (this.kerasMajorVersion == 1 && weights.containsKey("b")) {
                bias = weights.get("b");
            } else {
                throw new InvalidKerasConfigurationException("Keras SeparableConvolution2D layer does not contain bias parameter");
            }
            this.weights.put("b", bias);
        }
    }

    public SeparableConvolution2D getSeparableConvolution2DLayer() {
        return (SeparableConvolution2D)this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras separable convolution 2D layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getSeparableConvolution2DLayer().getOutputType(-1, inputType[0]);
    }

    @Override
    public String toString() {
        return "KerasSeparableConvolution2D()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KerasSeparableConvolution2D)) {
            return false;
        }
        KerasSeparableConvolution2D other = (KerasSeparableConvolution2D)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KerasSeparableConvolution2D;
    }

    @Override
    public int hashCode() {
        int result = 1;
        return result;
    }
}

