/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.normalization;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.BatchNormalization;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasConstraintUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils;
import org.nd4j.common.util.OneTimeLogger;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasBatchNormalization
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasBatchNormalization.class);
    private final int LAYER_BATCHNORM_MODE_1 = 1;
    private final int LAYER_BATCHNORM_MODE_2 = 2;
    private final String LAYER_FIELD_GAMMA_REGULARIZER = "gamma_regularizer";
    private final String LAYER_FIELD_BETA_REGULARIZER = "beta_regularizer";
    private final String LAYER_FIELD_MODE = "mode";
    private final String LAYER_FIELD_AXIS = "axis";
    private final String LAYER_FIELD_MOMENTUM = "momentum";
    private final String LAYER_FIELD_EPSILON = "epsilon";
    private final String LAYER_FIELD_SCALE = "scale";
    private final String LAYER_FIELD_CENTER = "center";
    private final int NUM_TRAINABLE_PARAMS = 4;
    private final String PARAM_NAME_GAMMA = "gamma";
    private final String PARAM_NAME_BETA = "beta";
    private final String PARAM_NAME_RUNNING_MEAN = "running_mean";
    private final String PARAM_NAME_RUNNING_STD = "running_std";
    private boolean scale = true;
    private boolean center = true;

    public KerasBatchNormalization(Integer kerasVersion) throws UnsupportedKerasConfigurationException {
        super(kerasVersion);
    }

    public KerasBatchNormalization(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasBatchNormalization(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        this.scale = this.getScaleParameter(layerConfig);
        this.center = this.getCenterParameter(layerConfig);
        this.getGammaRegularizerFromConfig(layerConfig, enforceTrainingConfig);
        this.getBetaRegularizerFromConfig(layerConfig, enforceTrainingConfig);
        int batchNormMode = this.getBatchNormMode(layerConfig, enforceTrainingConfig);
        if (batchNormMode != 0) {
            throw new UnsupportedKerasConfigurationException("Unsupported batch normalization mode " + batchNormMode + "Keras modes 1 and 2 have been removed from keras 2.x altogether.Try running with mode 0.");
        }
        int batchNormAxis = this.getBatchNormAxis(layerConfig);
        if (batchNormAxis != 3 && batchNormAxis != -1) {
            OneTimeLogger.warn((Logger)log, (String)("Warning: batch normalization axis " + batchNormAxis + "\n DL4J currently picks batch norm dimensions for you, according to industrystandard conventions. If your results do not match, please file an issue."), (Object[])new Object[0]);
        }
        LayerConstraint betaConstraint = KerasConstraintUtils.getConstraintsFromConfig(layerConfig, this.conf.getLAYER_FIELD_BATCHNORMALIZATION_BETA_CONSTRAINT(), this.conf, this.kerasMajorVersion);
        LayerConstraint gammaConstraint = KerasConstraintUtils.getConstraintsFromConfig(layerConfig, this.conf.getLAYER_FIELD_BATCHNORMALIZATION_GAMMA_CONSTRAINT(), this.conf, this.kerasMajorVersion);
        BatchNormalization.Builder builder = ((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder().name(this.layerName)).dropOut(this.dropout)).minibatch(true).lockGammaBeta(false).useLogStd(false).decay(this.getMomentumFromConfig(layerConfig)).eps(this.getEpsFromConfig(layerConfig));
        if (betaConstraint != null) {
            builder.constrainBeta(new LayerConstraint[]{betaConstraint});
        }
        if (gammaConstraint != null) {
            builder.constrainGamma(new LayerConstraint[]{gammaConstraint});
        }
        this.layer = builder.build();
    }

    public BatchNormalization getBatchNormalizationLayer() {
        return (BatchNormalization)this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras BatchNorm layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getBatchNormalizationLayer().getOutputType(-1, inputType[0]);
    }

    @Override
    public int getNumParams() {
        return 4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setWeights(Map<String, INDArray> weights) throws InvalidKerasConfigurationException {
        this.weights = new HashMap();
        if (this.center) {
            if (!weights.containsKey("beta")) throw new InvalidKerasConfigurationException("Parameter beta does not exist in weights");
            this.weights.put("beta", weights.get("beta"));
        } else {
            INDArray dummyBeta = Nd4j.zerosLike((INDArray)weights.get("beta"));
            this.weights.put("beta", dummyBeta);
        }
        if (this.scale) {
            if (!weights.containsKey("gamma")) throw new InvalidKerasConfigurationException("Parameter gamma does not exist in weights");
            this.weights.put("gamma", weights.get("gamma"));
        } else {
            INDArray dummyGamma = weights.containsKey("gamma") ? Nd4j.onesLike((INDArray)weights.get("gamma")) : Nd4j.onesLike((INDArray)weights.get("beta"));
            this.weights.put("gamma", dummyGamma);
        }
        if (!weights.containsKey(this.conf.getLAYER_FIELD_BATCHNORMALIZATION_MOVING_MEAN())) {
            throw new InvalidKerasConfigurationException("Parameter " + this.conf.getLAYER_FIELD_BATCHNORMALIZATION_MOVING_MEAN() + " does not exist in weights");
        }
        this.weights.put("mean", weights.get(this.conf.getLAYER_FIELD_BATCHNORMALIZATION_MOVING_MEAN()));
        if (!weights.containsKey(this.conf.getLAYER_FIELD_BATCHNORMALIZATION_MOVING_VARIANCE())) {
            throw new InvalidKerasConfigurationException("Parameter " + this.conf.getLAYER_FIELD_BATCHNORMALIZATION_MOVING_VARIANCE() + " does not exist in weights");
        }
        this.weights.put("var", weights.get(this.conf.getLAYER_FIELD_BATCHNORMALIZATION_MOVING_VARIANCE()));
        if (weights.size() <= 4) return;
        Set<String> paramNames = weights.keySet();
        paramNames.remove("beta");
        paramNames.remove("gamma");
        paramNames.remove(this.conf.getLAYER_FIELD_BATCHNORMALIZATION_MOVING_MEAN());
        paramNames.remove(this.conf.getLAYER_FIELD_BATCHNORMALIZATION_MOVING_VARIANCE());
        String unknownParamNames = paramNames.toString();
        log.warn("Attempting to set weights for unknown parameters: " + unknownParamNames.substring(1, unknownParamNames.length() - 1));
    }

    private double getEpsFromConfig(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException {
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, this.conf);
        if (!innerConfig.containsKey("epsilon")) {
            throw new InvalidKerasConfigurationException("Keras BatchNorm layer config missing epsilon field");
        }
        return (Double)innerConfig.get("epsilon");
    }

    private double getMomentumFromConfig(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException {
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, this.conf);
        if (!innerConfig.containsKey("momentum")) {
            throw new InvalidKerasConfigurationException("Keras BatchNorm layer config missing momentum field");
        }
        return (Double)innerConfig.get("momentum");
    }

    private void getGammaRegularizerFromConfig(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws UnsupportedKerasConfigurationException, InvalidKerasConfigurationException {
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, this.conf);
        if (innerConfig.get("gamma_regularizer") != null) {
            if (enforceTrainingConfig) {
                throw new UnsupportedKerasConfigurationException("Regularization for BatchNormalization gamma parameter not supported");
            }
            log.warn("Regularization for BatchNormalization gamma parameter not supported...ignoring.");
        }
    }

    private boolean getScaleParameter(Map<String, Object> layerConfig) throws UnsupportedOperationException, InvalidKerasConfigurationException {
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, this.conf);
        if (innerConfig.containsKey("scale")) {
            return (Boolean)innerConfig.get("scale");
        }
        return true;
    }

    private boolean getCenterParameter(Map<String, Object> layerConfig) throws UnsupportedOperationException, InvalidKerasConfigurationException {
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, this.conf);
        if (innerConfig.containsKey("center")) {
            return (Boolean)innerConfig.get("center");
        }
        return true;
    }

    private void getBetaRegularizerFromConfig(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws UnsupportedKerasConfigurationException, InvalidKerasConfigurationException {
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, this.conf);
        if (innerConfig.get("beta_regularizer") != null) {
            if (enforceTrainingConfig) {
                throw new UnsupportedKerasConfigurationException("Regularization for BatchNormalization beta parameter not supported");
            }
            log.warn("Regularization for BatchNormalization beta parameter not supported...ignoring.");
        }
    }

    private int getBatchNormMode(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, this.conf);
        int batchNormMode = 0;
        if (this.kerasMajorVersion == 1 & !innerConfig.containsKey("mode")) {
            throw new InvalidKerasConfigurationException("Keras BatchNorm layer config missing mode field");
        }
        if (this.kerasMajorVersion == 1) {
            batchNormMode = (Integer)innerConfig.get("mode");
        }
        switch (batchNormMode) {
            case 1: {
                throw new UnsupportedKerasConfigurationException("Keras BatchNormalization mode 1 (sample-wise) not supported");
            }
            case 2: {
                throw new UnsupportedKerasConfigurationException("Keras BatchNormalization (per-batch statistics during testing) 2 not supported");
            }
        }
        return batchNormMode;
    }

    private int getBatchNormAxis(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException {
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, this.conf);
        Object batchNormAxis = innerConfig.get("axis");
        if (batchNormAxis instanceof List) {
            return ((Number)((List)batchNormAxis).get(0)).intValue();
        }
        return ((Number)innerConfig.get("axis")).intValue();
    }

    public int getLAYER_BATCHNORM_MODE_1() {
        return this.LAYER_BATCHNORM_MODE_1;
    }

    public int getLAYER_BATCHNORM_MODE_2() {
        return this.LAYER_BATCHNORM_MODE_2;
    }

    public String getLAYER_FIELD_GAMMA_REGULARIZER() {
        return this.LAYER_FIELD_GAMMA_REGULARIZER;
    }

    public String getLAYER_FIELD_BETA_REGULARIZER() {
        return this.LAYER_FIELD_BETA_REGULARIZER;
    }

    public String getLAYER_FIELD_MODE() {
        return this.LAYER_FIELD_MODE;
    }

    public String getLAYER_FIELD_AXIS() {
        return this.LAYER_FIELD_AXIS;
    }

    public String getLAYER_FIELD_MOMENTUM() {
        return this.LAYER_FIELD_MOMENTUM;
    }

    public String getLAYER_FIELD_EPSILON() {
        return this.LAYER_FIELD_EPSILON;
    }

    public String getLAYER_FIELD_SCALE() {
        return this.LAYER_FIELD_SCALE;
    }

    public String getLAYER_FIELD_CENTER() {
        return this.LAYER_FIELD_CENTER;
    }

    public int getNUM_TRAINABLE_PARAMS() {
        return this.NUM_TRAINABLE_PARAMS;
    }

    public String getPARAM_NAME_GAMMA() {
        return this.PARAM_NAME_GAMMA;
    }

    public String getPARAM_NAME_BETA() {
        return this.PARAM_NAME_BETA;
    }

    public String getPARAM_NAME_RUNNING_MEAN() {
        return this.PARAM_NAME_RUNNING_MEAN;
    }

    public String getPARAM_NAME_RUNNING_STD() {
        return this.PARAM_NAME_RUNNING_STD;
    }

    public boolean isScale() {
        return this.scale;
    }

    public boolean isCenter() {
        return this.center;
    }

    public void setScale(boolean scale) {
        this.scale = scale;
    }

    public void setCenter(boolean center) {
        this.center = center;
    }

    public String toString() {
        return "KerasBatchNormalization(LAYER_BATCHNORM_MODE_1=" + this.getLAYER_BATCHNORM_MODE_1() + ", LAYER_BATCHNORM_MODE_2=" + this.getLAYER_BATCHNORM_MODE_2() + ", LAYER_FIELD_GAMMA_REGULARIZER=" + this.getLAYER_FIELD_GAMMA_REGULARIZER() + ", LAYER_FIELD_BETA_REGULARIZER=" + this.getLAYER_FIELD_BETA_REGULARIZER() + ", LAYER_FIELD_MODE=" + this.getLAYER_FIELD_MODE() + ", LAYER_FIELD_AXIS=" + this.getLAYER_FIELD_AXIS() + ", LAYER_FIELD_MOMENTUM=" + this.getLAYER_FIELD_MOMENTUM() + ", LAYER_FIELD_EPSILON=" + this.getLAYER_FIELD_EPSILON() + ", LAYER_FIELD_SCALE=" + this.getLAYER_FIELD_SCALE() + ", LAYER_FIELD_CENTER=" + this.getLAYER_FIELD_CENTER() + ", NUM_TRAINABLE_PARAMS=" + this.getNUM_TRAINABLE_PARAMS() + ", PARAM_NAME_GAMMA=" + this.getPARAM_NAME_GAMMA() + ", PARAM_NAME_BETA=" + this.getPARAM_NAME_BETA() + ", PARAM_NAME_RUNNING_MEAN=" + this.getPARAM_NAME_RUNNING_MEAN() + ", PARAM_NAME_RUNNING_STD=" + this.getPARAM_NAME_RUNNING_STD() + ", scale=" + this.isScale() + ", center=" + this.isCenter() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KerasBatchNormalization)) {
            return false;
        }
        KerasBatchNormalization other = (KerasBatchNormalization)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLAYER_BATCHNORM_MODE_1() != other.getLAYER_BATCHNORM_MODE_1()) {
            return false;
        }
        if (this.getLAYER_BATCHNORM_MODE_2() != other.getLAYER_BATCHNORM_MODE_2()) {
            return false;
        }
        if (this.getNUM_TRAINABLE_PARAMS() != other.getNUM_TRAINABLE_PARAMS()) {
            return false;
        }
        if (this.isScale() != other.isScale()) {
            return false;
        }
        if (this.isCenter() != other.isCenter()) {
            return false;
        }
        String this$LAYER_FIELD_GAMMA_REGULARIZER = this.getLAYER_FIELD_GAMMA_REGULARIZER();
        String other$LAYER_FIELD_GAMMA_REGULARIZER = other.getLAYER_FIELD_GAMMA_REGULARIZER();
        if (this$LAYER_FIELD_GAMMA_REGULARIZER == null ? other$LAYER_FIELD_GAMMA_REGULARIZER != null : !this$LAYER_FIELD_GAMMA_REGULARIZER.equals(other$LAYER_FIELD_GAMMA_REGULARIZER)) {
            return false;
        }
        String this$LAYER_FIELD_BETA_REGULARIZER = this.getLAYER_FIELD_BETA_REGULARIZER();
        String other$LAYER_FIELD_BETA_REGULARIZER = other.getLAYER_FIELD_BETA_REGULARIZER();
        if (this$LAYER_FIELD_BETA_REGULARIZER == null ? other$LAYER_FIELD_BETA_REGULARIZER != null : !this$LAYER_FIELD_BETA_REGULARIZER.equals(other$LAYER_FIELD_BETA_REGULARIZER)) {
            return false;
        }
        String this$LAYER_FIELD_MODE = this.getLAYER_FIELD_MODE();
        String other$LAYER_FIELD_MODE = other.getLAYER_FIELD_MODE();
        if (this$LAYER_FIELD_MODE == null ? other$LAYER_FIELD_MODE != null : !this$LAYER_FIELD_MODE.equals(other$LAYER_FIELD_MODE)) {
            return false;
        }
        String this$LAYER_FIELD_AXIS = this.getLAYER_FIELD_AXIS();
        String other$LAYER_FIELD_AXIS = other.getLAYER_FIELD_AXIS();
        if (this$LAYER_FIELD_AXIS == null ? other$LAYER_FIELD_AXIS != null : !this$LAYER_FIELD_AXIS.equals(other$LAYER_FIELD_AXIS)) {
            return false;
        }
        String this$LAYER_FIELD_MOMENTUM = this.getLAYER_FIELD_MOMENTUM();
        String other$LAYER_FIELD_MOMENTUM = other.getLAYER_FIELD_MOMENTUM();
        if (this$LAYER_FIELD_MOMENTUM == null ? other$LAYER_FIELD_MOMENTUM != null : !this$LAYER_FIELD_MOMENTUM.equals(other$LAYER_FIELD_MOMENTUM)) {
            return false;
        }
        String this$LAYER_FIELD_EPSILON = this.getLAYER_FIELD_EPSILON();
        String other$LAYER_FIELD_EPSILON = other.getLAYER_FIELD_EPSILON();
        if (this$LAYER_FIELD_EPSILON == null ? other$LAYER_FIELD_EPSILON != null : !this$LAYER_FIELD_EPSILON.equals(other$LAYER_FIELD_EPSILON)) {
            return false;
        }
        String this$LAYER_FIELD_SCALE = this.getLAYER_FIELD_SCALE();
        String other$LAYER_FIELD_SCALE = other.getLAYER_FIELD_SCALE();
        if (this$LAYER_FIELD_SCALE == null ? other$LAYER_FIELD_SCALE != null : !this$LAYER_FIELD_SCALE.equals(other$LAYER_FIELD_SCALE)) {
            return false;
        }
        String this$LAYER_FIELD_CENTER = this.getLAYER_FIELD_CENTER();
        String other$LAYER_FIELD_CENTER = other.getLAYER_FIELD_CENTER();
        if (this$LAYER_FIELD_CENTER == null ? other$LAYER_FIELD_CENTER != null : !this$LAYER_FIELD_CENTER.equals(other$LAYER_FIELD_CENTER)) {
            return false;
        }
        String this$PARAM_NAME_GAMMA = this.getPARAM_NAME_GAMMA();
        String other$PARAM_NAME_GAMMA = other.getPARAM_NAME_GAMMA();
        if (this$PARAM_NAME_GAMMA == null ? other$PARAM_NAME_GAMMA != null : !this$PARAM_NAME_GAMMA.equals(other$PARAM_NAME_GAMMA)) {
            return false;
        }
        String this$PARAM_NAME_BETA = this.getPARAM_NAME_BETA();
        String other$PARAM_NAME_BETA = other.getPARAM_NAME_BETA();
        if (this$PARAM_NAME_BETA == null ? other$PARAM_NAME_BETA != null : !this$PARAM_NAME_BETA.equals(other$PARAM_NAME_BETA)) {
            return false;
        }
        String this$PARAM_NAME_RUNNING_MEAN = this.getPARAM_NAME_RUNNING_MEAN();
        String other$PARAM_NAME_RUNNING_MEAN = other.getPARAM_NAME_RUNNING_MEAN();
        if (this$PARAM_NAME_RUNNING_MEAN == null ? other$PARAM_NAME_RUNNING_MEAN != null : !this$PARAM_NAME_RUNNING_MEAN.equals(other$PARAM_NAME_RUNNING_MEAN)) {
            return false;
        }
        String this$PARAM_NAME_RUNNING_STD = this.getPARAM_NAME_RUNNING_STD();
        String other$PARAM_NAME_RUNNING_STD = other.getPARAM_NAME_RUNNING_STD();
        return !(this$PARAM_NAME_RUNNING_STD == null ? other$PARAM_NAME_RUNNING_STD != null : !this$PARAM_NAME_RUNNING_STD.equals(other$PARAM_NAME_RUNNING_STD));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KerasBatchNormalization;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLAYER_BATCHNORM_MODE_1();
        result = result * 59 + this.getLAYER_BATCHNORM_MODE_2();
        result = result * 59 + this.getNUM_TRAINABLE_PARAMS();
        result = result * 59 + (this.isScale() ? 79 : 97);
        result = result * 59 + (this.isCenter() ? 79 : 97);
        String $LAYER_FIELD_GAMMA_REGULARIZER = this.getLAYER_FIELD_GAMMA_REGULARIZER();
        result = result * 59 + ($LAYER_FIELD_GAMMA_REGULARIZER == null ? 43 : $LAYER_FIELD_GAMMA_REGULARIZER.hashCode());
        String $LAYER_FIELD_BETA_REGULARIZER = this.getLAYER_FIELD_BETA_REGULARIZER();
        result = result * 59 + ($LAYER_FIELD_BETA_REGULARIZER == null ? 43 : $LAYER_FIELD_BETA_REGULARIZER.hashCode());
        String $LAYER_FIELD_MODE = this.getLAYER_FIELD_MODE();
        result = result * 59 + ($LAYER_FIELD_MODE == null ? 43 : $LAYER_FIELD_MODE.hashCode());
        String $LAYER_FIELD_AXIS = this.getLAYER_FIELD_AXIS();
        result = result * 59 + ($LAYER_FIELD_AXIS == null ? 43 : $LAYER_FIELD_AXIS.hashCode());
        String $LAYER_FIELD_MOMENTUM = this.getLAYER_FIELD_MOMENTUM();
        result = result * 59 + ($LAYER_FIELD_MOMENTUM == null ? 43 : $LAYER_FIELD_MOMENTUM.hashCode());
        String $LAYER_FIELD_EPSILON = this.getLAYER_FIELD_EPSILON();
        result = result * 59 + ($LAYER_FIELD_EPSILON == null ? 43 : $LAYER_FIELD_EPSILON.hashCode());
        String $LAYER_FIELD_SCALE = this.getLAYER_FIELD_SCALE();
        result = result * 59 + ($LAYER_FIELD_SCALE == null ? 43 : $LAYER_FIELD_SCALE.hashCode());
        String $LAYER_FIELD_CENTER = this.getLAYER_FIELD_CENTER();
        result = result * 59 + ($LAYER_FIELD_CENTER == null ? 43 : $LAYER_FIELD_CENTER.hashCode());
        String $PARAM_NAME_GAMMA = this.getPARAM_NAME_GAMMA();
        result = result * 59 + ($PARAM_NAME_GAMMA == null ? 43 : $PARAM_NAME_GAMMA.hashCode());
        String $PARAM_NAME_BETA = this.getPARAM_NAME_BETA();
        result = result * 59 + ($PARAM_NAME_BETA == null ? 43 : $PARAM_NAME_BETA.hashCode());
        String $PARAM_NAME_RUNNING_MEAN = this.getPARAM_NAME_RUNNING_MEAN();
        result = result * 59 + ($PARAM_NAME_RUNNING_MEAN == null ? 43 : $PARAM_NAME_RUNNING_MEAN.hashCode());
        String $PARAM_NAME_RUNNING_STD = this.getPARAM_NAME_RUNNING_STD();
        result = result * 59 + ($PARAM_NAME_RUNNING_STD == null ? 43 : $PARAM_NAME_RUNNING_STD.hashCode());
        return result;
    }
}

