/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.convolutional;

import java.util.Map;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.Upsampling2D;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolutionUtils;

public class KerasUpsampling2D
extends KerasLayer {
    public KerasUpsampling2D(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasUpsampling2D(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        int[] size = KerasConvolutionUtils.getUpsamplingSizeFromConfig(layerConfig, 2, this.conf);
        Upsampling2D.Builder builder = ((Upsampling2D.Builder)((Upsampling2D.Builder)new Upsampling2D.Builder().name(this.layerName)).dropOut(this.dropout)).size(size);
        this.layer = builder.build();
        this.vertex = null;
    }

    public Upsampling2D getUpsampling2DLayer() {
        return (Upsampling2D)this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Upsampling layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getUpsampling2DLayer().getOutputType(-1, inputType[0]);
    }
}

