/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.convolutional;

import java.util.HashMap;
import java.util.Map;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.deeplearning4j.nn.conf.CNN2DFormat;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.RNNFormat;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.Convolution1DLayer;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolution;
import org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolutionUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasActivationUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasConstraintUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasInitilizationUtils;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils;
import org.deeplearning4j.nn.weights.IWeightInit;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasConvolution1D
extends KerasConvolution {
    private static final Logger log = LoggerFactory.getLogger(KerasConvolution1D.class);

    public KerasConvolution1D(Integer kerasVersion) throws UnsupportedKerasConfigurationException {
        super(kerasVersion);
    }

    public KerasConvolution1D(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasConvolution1D(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        this.hasBias = KerasLayerUtils.getHasBiasFromConfig(layerConfig, this.conf);
        this.numTrainableParams = this.hasBias ? 2 : 1;
        int[] dilationRate = KerasConvolutionUtils.getDilationRate(layerConfig, 1, this.conf, false);
        LayerConstraint biasConstraint = KerasConstraintUtils.getConstraintsFromConfig(layerConfig, this.conf.getLAYER_FIELD_B_CONSTRAINT(), this.conf, this.kerasMajorVersion);
        LayerConstraint weightConstraint = KerasConstraintUtils.getConstraintsFromConfig(layerConfig, this.conf.getLAYER_FIELD_W_CONSTRAINT(), this.conf, this.kerasMajorVersion);
        IWeightInit init = KerasInitilizationUtils.getWeightInitFromConfig(layerConfig, this.conf.getLAYER_FIELD_INIT(), enforceTrainingConfig, this.conf, this.kerasMajorVersion);
        Convolution1DLayer.Builder builder = ((Convolution1DLayer.Builder)((Convolution1DLayer.Builder)((Convolution1DLayer.Builder)((Convolution1DLayer.Builder)((Convolution1DLayer.Builder)((Convolution1DLayer.Builder)((Convolution1DLayer.Builder)((Convolution1DLayer.Builder)((Convolution1DLayer.Builder)new Convolution1DLayer.Builder().name(this.layerName)).nOut(KerasLayerUtils.getNOutFromConfig(layerConfig, this.conf))).dropOut(this.dropout)).activation(KerasActivationUtils.getIActivationFromConfig(layerConfig, this.conf))).weightInit(init)).l1(this.weightL1Regularization)).l2(this.weightL2Regularization)).convolutionMode(KerasConvolutionUtils.getConvolutionModeFromConfig(layerConfig, this.conf))).kernelSize(KerasConvolutionUtils.getKernelSizeFromConfig(layerConfig, 1, this.conf, this.kerasMajorVersion)[0]).hasBias(this.hasBias)).stride(KerasConvolutionUtils.getStrideFromConfig(layerConfig, 1, this.conf)[0]).rnnDataFormat(this.dimOrder == KerasLayer.DimOrder.TENSORFLOW ? RNNFormat.NWC : RNNFormat.NCW);
        int[] padding = KerasConvolutionUtils.getPaddingFromBorderModeConfig(layerConfig, 1, this.conf, this.kerasMajorVersion);
        if (this.hasBias) {
            builder.biasInit(0.0);
        }
        if (padding != null) {
            builder.padding(padding[0]);
        }
        if (dilationRate != null) {
            builder.dilation(new int[]{dilationRate[0]});
        }
        if (biasConstraint != null) {
            builder.constrainBias(new LayerConstraint[]{biasConstraint});
        }
        if (weightConstraint != null) {
            builder.constrainWeights(new LayerConstraint[]{weightConstraint});
        }
        if (this.inputShape != null) {
            if (this.dimOrder == KerasLayer.DimOrder.THEANO) {
                builder.nIn(this.inputShape[0]);
            } else {
                builder.nIn(this.inputShape[1]);
            }
        }
        this.layer = builder.build();
        Convolution1DLayer convolution1DLayer = (Convolution1DLayer)this.layer;
        convolution1DLayer.setCnn2dDataFormat(this.dimOrder == KerasLayer.DimOrder.TENSORFLOW ? CNN2DFormat.NHWC : CNN2DFormat.NCHW);
        convolution1DLayer.setDefaultValueOverriden(true);
    }

    public Convolution1DLayer getConvolution1DLayer() {
        return (Convolution1DLayer)this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Convolution layer accepts only one input (received " + inputType.length + ")");
        }
        InputPreProcessor preprocessor = this.getInputPreprocessor(inputType[0]);
        if (preprocessor != null) {
            return this.getConvolution1DLayer().getOutputType(-1, preprocessor.getOutputType(inputType[0]));
        }
        return this.getConvolution1DLayer().getOutputType(-1, inputType[0]);
    }

    @Override
    public InputPreProcessor getInputPreprocessor(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Conv1D layer accepts only one input (received " + inputType.length + ")");
        }
        return InputTypeUtil.getPreprocessorForInputTypeRnnLayers((InputType)inputType[0], (RNNFormat)RNNFormat.NCW, (String)this.layerName);
    }

    @Override
    public void setWeights(Map<String, INDArray> weights) throws InvalidKerasConfigurationException {
        INDArray paramValue;
        this.weights = new HashMap();
        if (weights.containsKey(this.conf.getKERAS_PARAM_NAME_W())) {
            INDArray kerasParamValue = weights.get(this.conf.getKERAS_PARAM_NAME_W());
            switch (this.getDimOrder()) {
                case TENSORFLOW: {
                    paramValue = kerasParamValue;
                    paramValue = paramValue.reshape(new long[]{paramValue.size(0), paramValue.size(1), paramValue.size(2), 1L});
                    break;
                }
                case THEANO: {
                    long k = kerasParamValue.size(0);
                    long nIn = kerasParamValue.size(1);
                    long nOut = kerasParamValue.size(2);
                    paramValue = kerasParamValue.dup('c').reshape(new long[]{nOut, nIn, k, 1L});
                    break;
                }
                default: {
                    throw new InvalidKerasConfigurationException("Unknown keras backend " + (Object)((Object)this.getDimOrder()));
                }
            }
        } else {
            throw new InvalidKerasConfigurationException("Parameter " + this.conf.getKERAS_PARAM_NAME_W() + " does not exist in weights");
        }
        this.weights.put("W", paramValue);
        if (this.hasBias) {
            if (weights.containsKey(this.conf.getKERAS_PARAM_NAME_B())) {
                this.weights.put("b", weights.get(this.conf.getKERAS_PARAM_NAME_B()));
            } else {
                throw new InvalidKerasConfigurationException("Parameter " + this.conf.getKERAS_PARAM_NAME_B() + " does not exist in weights");
            }
        }
        KerasLayerUtils.removeDefaultWeights(weights, this.conf);
    }

    @Override
    public String toString() {
        return "KerasConvolution1D()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KerasConvolution1D)) {
            return false;
        }
        KerasConvolution1D other = (KerasConvolution1D)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KerasConvolution1D;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

