/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.core;

import java.util.Map;
import org.deeplearning4j.nn.conf.graph.ElementWiseVertex;
import org.deeplearning4j.nn.conf.graph.MergeVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasMerge
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasMerge.class);
    private final String LAYER_FIELD_MODE = "mode";
    private final String LAYER_MERGE_MODE_SUM = "sum";
    private final String LAYER_MERGE_MODE_MUL = "mul";
    private final String LAYER_MERGE_MODE_CONCAT = "concat";
    private final String LAYER_MERGE_MODE_AVE = "ave";
    private final String LAYER_MERGE_MODE_COS = "cos";
    private final String LAYER_MERGE_MODE_DOT = "dot";
    private final String LAYER_MERGE_MODE_MAX = "max";
    private ElementWiseVertex.Op mergeMode = null;

    public KerasMerge(Integer kerasVersion) throws UnsupportedKerasConfigurationException {
        super(kerasVersion);
    }

    public KerasMerge(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasMerge(Map<String, Object> layerConfig, ElementWiseVertex.Op mergeMode, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        this.mergeMode = mergeMode;
        if (this.mergeMode == null) {
            this.vertex = new MergeVertex();
            MergeVertex mergeVertex = (MergeVertex)this.vertex;
            if (this.hasMergeAxis(layerConfig)) {
                mergeVertex.setMergeAxis(this.getMergeAxisFromConfig(layerConfig).intValue());
            }
        } else {
            this.vertex = new ElementWiseVertex(mergeMode);
        }
    }

    public KerasMerge(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        this.mergeMode = this.getMergeMode(layerConfig);
        if (this.mergeMode == null) {
            this.vertex = new MergeVertex();
            MergeVertex mergeVertex = (MergeVertex)this.vertex;
            if (this.hasMergeAxis(layerConfig)) {
                mergeVertex.setMergeAxis(this.getMergeAxisFromConfig(layerConfig).intValue());
            }
        } else {
            this.vertex = new ElementWiseVertex(this.mergeMode);
        }
    }

    private ElementWiseVertex.Op getMergeMode(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        String mergeMode;
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, this.conf);
        if (!innerConfig.containsKey("mode")) {
            throw new InvalidKerasConfigurationException("Keras Merge layer config missing mode field");
        }
        ElementWiseVertex.Op op = null;
        switch (mergeMode = (String)innerConfig.get("mode")) {
            case "sum": {
                op = ElementWiseVertex.Op.Add;
                break;
            }
            case "mul": {
                op = ElementWiseVertex.Op.Product;
                break;
            }
            case "concat": {
                break;
            }
            case "ave": {
                op = ElementWiseVertex.Op.Average;
                break;
            }
            case "max": {
                op = ElementWiseVertex.Op.Max;
                break;
            }
            default: {
                throw new UnsupportedKerasConfigurationException("Keras Merge layer mode " + mergeMode + " not supported");
            }
        }
        return op;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) {
        return this.vertex.getOutputType(-1, inputType);
    }

    private boolean hasMergeAxis(Map<String, Object> config) throws InvalidKerasConfigurationException {
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(config, this.conf);
        return innerConfig.containsKey(this.conf.getLAYER_FIELD_CONSTRAINT_DIM());
    }

    private Integer getMergeAxisFromConfig(Map<String, Object> config) throws InvalidKerasConfigurationException {
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(config, this.conf);
        if (innerConfig.containsKey(this.conf.getLAYER_FIELD_CONSTRAINT_DIM())) {
            Integer dim = (Integer)innerConfig.get(this.conf.getLAYER_FIELD_CONSTRAINT_DIM());
            return dim;
        }
        return null;
    }

    public String getLAYER_FIELD_MODE() {
        return this.LAYER_FIELD_MODE;
    }

    public String getLAYER_MERGE_MODE_SUM() {
        return this.LAYER_MERGE_MODE_SUM;
    }

    public String getLAYER_MERGE_MODE_MUL() {
        return this.LAYER_MERGE_MODE_MUL;
    }

    public String getLAYER_MERGE_MODE_CONCAT() {
        return this.LAYER_MERGE_MODE_CONCAT;
    }

    public String getLAYER_MERGE_MODE_AVE() {
        return this.LAYER_MERGE_MODE_AVE;
    }

    public String getLAYER_MERGE_MODE_COS() {
        return this.LAYER_MERGE_MODE_COS;
    }

    public String getLAYER_MERGE_MODE_DOT() {
        return this.LAYER_MERGE_MODE_DOT;
    }

    public String getLAYER_MERGE_MODE_MAX() {
        return this.LAYER_MERGE_MODE_MAX;
    }

    public ElementWiseVertex.Op getMergeMode() {
        return this.mergeMode;
    }

    public void setMergeMode(ElementWiseVertex.Op mergeMode) {
        this.mergeMode = mergeMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KerasMerge)) {
            return false;
        }
        KerasMerge other = (KerasMerge)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$LAYER_FIELD_MODE = this.getLAYER_FIELD_MODE();
        String other$LAYER_FIELD_MODE = other.getLAYER_FIELD_MODE();
        if (this$LAYER_FIELD_MODE == null ? other$LAYER_FIELD_MODE != null : !this$LAYER_FIELD_MODE.equals(other$LAYER_FIELD_MODE)) {
            return false;
        }
        String this$LAYER_MERGE_MODE_SUM = this.getLAYER_MERGE_MODE_SUM();
        String other$LAYER_MERGE_MODE_SUM = other.getLAYER_MERGE_MODE_SUM();
        if (this$LAYER_MERGE_MODE_SUM == null ? other$LAYER_MERGE_MODE_SUM != null : !this$LAYER_MERGE_MODE_SUM.equals(other$LAYER_MERGE_MODE_SUM)) {
            return false;
        }
        String this$LAYER_MERGE_MODE_MUL = this.getLAYER_MERGE_MODE_MUL();
        String other$LAYER_MERGE_MODE_MUL = other.getLAYER_MERGE_MODE_MUL();
        if (this$LAYER_MERGE_MODE_MUL == null ? other$LAYER_MERGE_MODE_MUL != null : !this$LAYER_MERGE_MODE_MUL.equals(other$LAYER_MERGE_MODE_MUL)) {
            return false;
        }
        String this$LAYER_MERGE_MODE_CONCAT = this.getLAYER_MERGE_MODE_CONCAT();
        String other$LAYER_MERGE_MODE_CONCAT = other.getLAYER_MERGE_MODE_CONCAT();
        if (this$LAYER_MERGE_MODE_CONCAT == null ? other$LAYER_MERGE_MODE_CONCAT != null : !this$LAYER_MERGE_MODE_CONCAT.equals(other$LAYER_MERGE_MODE_CONCAT)) {
            return false;
        }
        String this$LAYER_MERGE_MODE_AVE = this.getLAYER_MERGE_MODE_AVE();
        String other$LAYER_MERGE_MODE_AVE = other.getLAYER_MERGE_MODE_AVE();
        if (this$LAYER_MERGE_MODE_AVE == null ? other$LAYER_MERGE_MODE_AVE != null : !this$LAYER_MERGE_MODE_AVE.equals(other$LAYER_MERGE_MODE_AVE)) {
            return false;
        }
        String this$LAYER_MERGE_MODE_COS = this.getLAYER_MERGE_MODE_COS();
        String other$LAYER_MERGE_MODE_COS = other.getLAYER_MERGE_MODE_COS();
        if (this$LAYER_MERGE_MODE_COS == null ? other$LAYER_MERGE_MODE_COS != null : !this$LAYER_MERGE_MODE_COS.equals(other$LAYER_MERGE_MODE_COS)) {
            return false;
        }
        String this$LAYER_MERGE_MODE_DOT = this.getLAYER_MERGE_MODE_DOT();
        String other$LAYER_MERGE_MODE_DOT = other.getLAYER_MERGE_MODE_DOT();
        if (this$LAYER_MERGE_MODE_DOT == null ? other$LAYER_MERGE_MODE_DOT != null : !this$LAYER_MERGE_MODE_DOT.equals(other$LAYER_MERGE_MODE_DOT)) {
            return false;
        }
        String this$LAYER_MERGE_MODE_MAX = this.getLAYER_MERGE_MODE_MAX();
        String other$LAYER_MERGE_MODE_MAX = other.getLAYER_MERGE_MODE_MAX();
        if (this$LAYER_MERGE_MODE_MAX == null ? other$LAYER_MERGE_MODE_MAX != null : !this$LAYER_MERGE_MODE_MAX.equals(other$LAYER_MERGE_MODE_MAX)) {
            return false;
        }
        ElementWiseVertex.Op this$mergeMode = this.getMergeMode();
        ElementWiseVertex.Op other$mergeMode = other.getMergeMode();
        return !(this$mergeMode == null ? other$mergeMode != null : !this$mergeMode.equals(other$mergeMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KerasMerge;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $LAYER_FIELD_MODE = this.getLAYER_FIELD_MODE();
        result = result * 59 + ($LAYER_FIELD_MODE == null ? 43 : $LAYER_FIELD_MODE.hashCode());
        String $LAYER_MERGE_MODE_SUM = this.getLAYER_MERGE_MODE_SUM();
        result = result * 59 + ($LAYER_MERGE_MODE_SUM == null ? 43 : $LAYER_MERGE_MODE_SUM.hashCode());
        String $LAYER_MERGE_MODE_MUL = this.getLAYER_MERGE_MODE_MUL();
        result = result * 59 + ($LAYER_MERGE_MODE_MUL == null ? 43 : $LAYER_MERGE_MODE_MUL.hashCode());
        String $LAYER_MERGE_MODE_CONCAT = this.getLAYER_MERGE_MODE_CONCAT();
        result = result * 59 + ($LAYER_MERGE_MODE_CONCAT == null ? 43 : $LAYER_MERGE_MODE_CONCAT.hashCode());
        String $LAYER_MERGE_MODE_AVE = this.getLAYER_MERGE_MODE_AVE();
        result = result * 59 + ($LAYER_MERGE_MODE_AVE == null ? 43 : $LAYER_MERGE_MODE_AVE.hashCode());
        String $LAYER_MERGE_MODE_COS = this.getLAYER_MERGE_MODE_COS();
        result = result * 59 + ($LAYER_MERGE_MODE_COS == null ? 43 : $LAYER_MERGE_MODE_COS.hashCode());
        String $LAYER_MERGE_MODE_DOT = this.getLAYER_MERGE_MODE_DOT();
        result = result * 59 + ($LAYER_MERGE_MODE_DOT == null ? 43 : $LAYER_MERGE_MODE_DOT.hashCode());
        String $LAYER_MERGE_MODE_MAX = this.getLAYER_MERGE_MODE_MAX();
        result = result * 59 + ($LAYER_MERGE_MODE_MAX == null ? 43 : $LAYER_MERGE_MODE_MAX.hashCode());
        ElementWiseVertex.Op $mergeMode = this.getMergeMode();
        result = result * 59 + ($mergeMode == null ? 43 : $mergeMode.hashCode());
        return result;
    }

    public String toString() {
        return "KerasMerge(LAYER_FIELD_MODE=" + this.getLAYER_FIELD_MODE() + ", LAYER_MERGE_MODE_SUM=" + this.getLAYER_MERGE_MODE_SUM() + ", LAYER_MERGE_MODE_MUL=" + this.getLAYER_MERGE_MODE_MUL() + ", LAYER_MERGE_MODE_CONCAT=" + this.getLAYER_MERGE_MODE_CONCAT() + ", LAYER_MERGE_MODE_AVE=" + this.getLAYER_MERGE_MODE_AVE() + ", LAYER_MERGE_MODE_COS=" + this.getLAYER_MERGE_MODE_COS() + ", LAYER_MERGE_MODE_DOT=" + this.getLAYER_MERGE_MODE_DOT() + ", LAYER_MERGE_MODE_MAX=" + this.getLAYER_MERGE_MODE_MAX() + ", mergeMode=" + this.getMergeMode() + ")";
    }
}

