/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.custom;

import java.util.Map;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.LocalResponseNormalization;
import org.deeplearning4j.nn.modelimport.keras.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.UnsupportedKerasConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasLRN
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasLRN.class);

    public KerasLRN(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasLRN(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        Map<String, Object> lrnParams = KerasLRN.getInnerLayerConfigFromConfig(layerConfig);
        LocalResponseNormalization.Builder builder = ((LocalResponseNormalization.Builder)((LocalResponseNormalization.Builder)new LocalResponseNormalization.Builder().name(this.layerName)).dropOut(this.dropout)).alpha(((Double)lrnParams.get("alpha")).doubleValue()).beta(((Double)lrnParams.get("beta")).doubleValue()).k((double)((Integer)lrnParams.get("k")).intValue()).n((double)((Integer)lrnParams.get("n")).intValue());
        this.layer = builder.build();
        this.vertex = null;
    }

    public LocalResponseNormalization getLocalResponseNormalization() {
        return (LocalResponseNormalization)this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras LRN layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getLocalResponseNormalization().getOutputType(-1, inputType[0]);
    }
}

