/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.DenseLayer;
import org.deeplearning4j.nn.modelimport.keras.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.UnsupportedKerasConfigurationException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasDense
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasDense.class);
    public static final int NUM_TRAINABLE_PARAMS = 2;
    public static final String KERAS_PARAM_NAME_W = "W";
    public static final String KERAS_PARAM_NAME_B = "b";

    public KerasDense(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasDense(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        this.layer = ((DenseLayer.Builder)((DenseLayer.Builder)((DenseLayer.Builder)((DenseLayer.Builder)((DenseLayer.Builder)((DenseLayer.Builder)((DenseLayer.Builder)((DenseLayer.Builder)new DenseLayer.Builder().name(this.layerName)).nOut(KerasDense.getNOutFromConfig(layerConfig))).dropOut(this.dropout)).activation(this.getActivationFromConfig(layerConfig))).weightInit(this.getWeightInitFromConfig(layerConfig, enforceTrainingConfig))).biasInit(0.0)).l1(this.weightL1Regularization)).l2(this.weightL2Regularization)).build();
    }

    public DenseLayer getDenseLayer() {
        return (DenseLayer)this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        InputPreProcessor preprocessor = this.getInputPreprocessor(inputType[0]);
        if (preprocessor != null) {
            return this.getDenseLayer().getOutputType(-1, preprocessor.getOutputType(inputType[0]));
        }
        return this.getDenseLayer().getOutputType(-1, inputType[0]);
    }

    @Override
    public int getNumParams() {
        return 2;
    }

    @Override
    public void setWeights(Map<String, INDArray> weights) throws InvalidKerasConfigurationException {
        this.weights = new HashMap();
        if (!weights.containsKey(KERAS_PARAM_NAME_W)) {
            throw new InvalidKerasConfigurationException("Parameter W does not exist in weights");
        }
        this.weights.put(KERAS_PARAM_NAME_W, weights.get(KERAS_PARAM_NAME_W));
        if (!weights.containsKey(KERAS_PARAM_NAME_B)) {
            throw new InvalidKerasConfigurationException("Parameter b does not exist in weights");
        }
        this.weights.put(KERAS_PARAM_NAME_B, weights.get(KERAS_PARAM_NAME_B));
        if (weights.size() > 2) {
            Set<String> paramNames = weights.keySet();
            paramNames.remove(KERAS_PARAM_NAME_W);
            paramNames.remove(KERAS_PARAM_NAME_B);
            String unknownParamNames = paramNames.toString();
            log.warn("Attemping to set weights for unknown parameters: " + unknownParamNames.substring(1, unknownParamNames.length() - 1));
        }
    }
}

