/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.graph.data.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.deeplearning4j.graph.api.Vertex;
import org.deeplearning4j.graph.data.VertexLoader;
import org.deeplearning4j.graph.exception.ParseException;

public class DelimitedVertexLoader
implements VertexLoader<String> {
    private final String delimiter;
    private final String[] ignoreLinesPrefix;

    public DelimitedVertexLoader(String delimiter) {
        this(delimiter, null);
    }

    public DelimitedVertexLoader(String delimiter, String ... ignoreLinesPrefix) {
        this.delimiter = delimiter;
        this.ignoreLinesPrefix = ignoreLinesPrefix;
    }

    @Override
    public List<Vertex<String>> loadVertices(String path) throws IOException {
        ArrayList<Vertex<String>> vertices = new ArrayList<Vertex<String>>();
        int lineCount = 0;
        try (BufferedReader br = new BufferedReader(new FileReader(new File(path)));){
            String line;
            while ((line = br.readLine()) != null) {
                int idx;
                ++lineCount;
                if (this.ignoreLinesPrefix != null) {
                    boolean skipLine = false;
                    for (String s : this.ignoreLinesPrefix) {
                        if (!line.startsWith(s)) continue;
                        skipLine = true;
                        break;
                    }
                    if (skipLine) continue;
                }
                if ((idx = line.indexOf(this.delimiter)) == -1) {
                    throw new ParseException("Error parsing line (could not find delimiter): " + line);
                }
                String first = line.substring(0, idx);
                String second = line.substring(idx + 1);
                vertices.add(new Vertex<String>(Integer.parseInt(first), second));
            }
        }
        return vertices;
    }
}

