/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.base;

import java.io.File;
import java.io.IOException;
import org.deeplearning4j.common.resources.DL4JResources;
import org.deeplearning4j.common.resources.ResourceType;
import org.eclipse.deeplearning4j.resources.DataSetResource;
import org.eclipse.deeplearning4j.resources.ResourceDataSets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MnistFetcher {
    private static final Logger log = LoggerFactory.getLogger(MnistFetcher.class);
    protected static final String LOCAL_DIR_NAME = "MNIST";
    protected File fileDir;
    private DataSetResource mnistTrain = ResourceDataSets.mnistTrain();
    private DataSetResource mnistTest = ResourceDataSets.mnistTest();
    private DataSetResource mnistTrainLabels = ResourceDataSets.mnistTrainLabels();
    private DataSetResource mnistTestLabels = ResourceDataSets.mnistTestLabels();

    public MnistFetcher(File tempDir) {
        this.fileDir = tempDir;
    }

    public String getName() {
        return LOCAL_DIR_NAME;
    }

    public File getBaseDir() {
        return DL4JResources.getDirectory((ResourceType)ResourceType.DATASET, (String)this.getName());
    }

    public File downloadAndUntar() throws IOException {
        if (this.fileDir != null) {
            return this.fileDir;
        }
        File baseDir = this.getBaseDir();
        if (!baseDir.isDirectory() && !baseDir.mkdir()) {
            throw new IOException("Could not mkdir " + baseDir);
        }
        log.info("Downloading {}...", (Object)this.getName());
        this.mnistTrain.download(true, 3, 200000, 20000);
        this.mnistTest.download(true, 3, 200000, 20000);
        this.mnistTrainLabels.download(true, 3, 200000, 20000);
        this.mnistTestLabels.download(true, 3, 200000, 20000);
        this.fileDir = baseDir;
        return this.fileDir;
    }

    public File getFileDir() {
        return this.fileDir;
    }

    public DataSetResource getMnistTrain() {
        return this.mnistTrain;
    }

    public DataSetResource getMnistTest() {
        return this.mnistTest;
    }

    public DataSetResource getMnistTrainLabels() {
        return this.mnistTrainLabels;
    }

    public DataSetResource getMnistTestLabels() {
        return this.mnistTestLabels;
    }

    public void setFileDir(File fileDir) {
        this.fileDir = fileDir;
    }

    public void setMnistTrain(DataSetResource mnistTrain) {
        this.mnistTrain = mnistTrain;
    }

    public void setMnistTest(DataSetResource mnistTest) {
        this.mnistTest = mnistTest;
    }

    public void setMnistTrainLabels(DataSetResource mnistTrainLabels) {
        this.mnistTrainLabels = mnistTrainLabels;
    }

    public void setMnistTestLabels(DataSetResource mnistTestLabels) {
        this.mnistTestLabels = mnistTestLabels;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MnistFetcher)) {
            return false;
        }
        MnistFetcher other = (MnistFetcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        File this$fileDir = this.getFileDir();
        File other$fileDir = other.getFileDir();
        if (this$fileDir == null ? other$fileDir != null : !((Object)this$fileDir).equals(other$fileDir)) {
            return false;
        }
        DataSetResource this$mnistTrain = this.getMnistTrain();
        DataSetResource other$mnistTrain = other.getMnistTrain();
        if (this$mnistTrain == null ? other$mnistTrain != null : !this$mnistTrain.equals(other$mnistTrain)) {
            return false;
        }
        DataSetResource this$mnistTest = this.getMnistTest();
        DataSetResource other$mnistTest = other.getMnistTest();
        if (this$mnistTest == null ? other$mnistTest != null : !this$mnistTest.equals(other$mnistTest)) {
            return false;
        }
        DataSetResource this$mnistTrainLabels = this.getMnistTrainLabels();
        DataSetResource other$mnistTrainLabels = other.getMnistTrainLabels();
        if (this$mnistTrainLabels == null ? other$mnistTrainLabels != null : !this$mnistTrainLabels.equals(other$mnistTrainLabels)) {
            return false;
        }
        DataSetResource this$mnistTestLabels = this.getMnistTestLabels();
        DataSetResource other$mnistTestLabels = other.getMnistTestLabels();
        return !(this$mnistTestLabels == null ? other$mnistTestLabels != null : !this$mnistTestLabels.equals(other$mnistTestLabels));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MnistFetcher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $fileDir = this.getFileDir();
        result = result * 59 + ($fileDir == null ? 43 : ((Object)$fileDir).hashCode());
        DataSetResource $mnistTrain = this.getMnistTrain();
        result = result * 59 + ($mnistTrain == null ? 43 : $mnistTrain.hashCode());
        DataSetResource $mnistTest = this.getMnistTest();
        result = result * 59 + ($mnistTest == null ? 43 : $mnistTest.hashCode());
        DataSetResource $mnistTrainLabels = this.getMnistTrainLabels();
        result = result * 59 + ($mnistTrainLabels == null ? 43 : $mnistTrainLabels.hashCode());
        DataSetResource $mnistTestLabels = this.getMnistTestLabels();
        result = result * 59 + ($mnistTestLabels == null ? 43 : $mnistTestLabels.hashCode());
        return result;
    }

    public String toString() {
        return "MnistFetcher(fileDir=" + this.getFileDir() + ", mnistTrain=" + this.getMnistTrain() + ", mnistTest=" + this.getMnistTest() + ", mnistTrainLabels=" + this.getMnistTrainLabels() + ", mnistTestLabels=" + this.getMnistTestLabels() + ")";
    }

    public MnistFetcher() {
    }
}

