/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.twowaysql.node;

import java.lang.reflect.Array;
import java.util.Collection;
import org.dbflute.twowaysql.context.CommandContext;
import org.dbflute.twowaysql.factory.NodeAdviceFactory;
import org.dbflute.twowaysql.node.BoundValue;
import org.dbflute.twowaysql.node.LoopInfo;
import org.dbflute.twowaysql.node.ParameterCommentType;
import org.dbflute.twowaysql.node.VariableNode;

public class BindVariableNode
extends VariableNode {
    public BindVariableNode(String expression, String testValue, String specifiedSql, boolean blockNullParameter, NodeAdviceFactory nodeAdviceFactory) {
        super(expression, testValue, specifiedSql, blockNullParameter, nodeAdviceFactory);
    }

    @Override
    protected void doProcess(CommandContext ctx, BoundValue boundValue, LoopInfo loopInfo) {
        Object finalValue = boundValue.getTargetValue();
        Class<?> finalType = boundValue.getTargetType();
        if (this.isInScope()) {
            if (finalValue == null) {
                this.throwBindOrEmbeddedCommentParameterNullValueException(boundValue);
            }
            if (Collection.class.isAssignableFrom(finalType)) {
                this.bindArray(ctx, ((Collection)finalValue).toArray());
            } else if (finalType.isArray()) {
                this.bindArray(ctx, finalValue);
            } else {
                this.throwBindOrEmbeddedCommentInScopeNotListException(boundValue);
            }
        } else {
            ctx.addSql("?", finalValue, finalType);
            if (this.isAcceptableLikeSearch(loopInfo)) {
                this.setupRearOption(ctx, boundValue);
            }
        }
    }

    protected void bindArray(CommandContext ctx, Object array) {
        if (array == null) {
            return;
        }
        int length = Array.getLength(array);
        if (length == 0) {
            this.throwBindOrEmbeddedCommentParameterEmptyListException();
        }
        Class<?> clazz = null;
        for (int i = 0; i < length; ++i) {
            Object currentElement = Array.get(array, i);
            if (currentElement == null) continue;
            clazz = currentElement.getClass();
            break;
        }
        if (clazz == null) {
            this.throwBindOrEmbeddedCommentParameterNullOnlyListException();
        }
        ctx.addSql("(");
        int validCount = 0;
        for (int i = 0; i < length; ++i) {
            Object currentElement = Array.get(array, i);
            if (currentElement == null) continue;
            if (validCount > 0) {
                ctx.addSql(", ");
            }
            ctx.addSql("?", currentElement, clazz);
            ++validCount;
        }
        ctx.addSql(")");
    }

    @Override
    protected ParameterCommentType getCommentType() {
        return ParameterCommentType.BIND;
    }
}

