/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.s2dao.rshandler;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import org.dbflute.helper.StringKeyMap;
import org.dbflute.jdbc.ValueType;
import org.dbflute.s2dao.jdbc.TnResultSetHandler;
import org.dbflute.s2dao.valuetype.TnValueTypes;
import org.dbflute.util.DfCollectionUtil;

public abstract class TnAbstractMapResultSetHandler
implements TnResultSetHandler {
    protected Map<String, ValueType> createPropertyTypeMap(ResultSetMetaData rsmd) throws SQLException {
        int count = rsmd.getColumnCount();
        Map<String, ValueType> propertyTypeMap = this.newPropertyTypeMap();
        for (int i = 0; i < count; ++i) {
            String propertyName = rsmd.getColumnLabel(i + 1);
            int columnType = rsmd.getColumnType(i + 1);
            ValueType valueType = this.getValueType(columnType);
            propertyTypeMap.put(propertyName, valueType);
        }
        return propertyTypeMap;
    }

    protected Map<String, ValueType> newPropertyTypeMap() {
        return DfCollectionUtil.newLinkedHashMap();
    }

    protected ValueType getValueType(int columnType) {
        return TnValueTypes.getValueType(columnType);
    }

    protected Map<String, Object> createRow(ResultSet rs, Map<String, ValueType> propertyTypeMap) throws SQLException {
        StringKeyMap<Object> row = this.newRowMap();
        Set<Map.Entry<String, ValueType>> entrySet = propertyTypeMap.entrySet();
        int index = 0;
        for (Map.Entry<String, ValueType> entry : entrySet) {
            String propertyName = entry.getKey();
            ValueType valueType = entry.getValue();
            Object value = valueType.getValue(rs, index + 1);
            row.put(propertyName, value);
            ++index;
        }
        return row;
    }

    protected StringKeyMap<Object> newRowMap() {
        return StringKeyMap.createAsFlexibleOrdered();
    }
}

