/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.s2dao.metadata.impl;

import java.util.ArrayList;
import java.util.List;
import org.dbflute.Entity;
import org.dbflute.dbmeta.DBMeta;
import org.dbflute.dbmeta.info.ColumnInfo;
import org.dbflute.dbmeta.info.ForeignInfo;
import org.dbflute.dbmeta.info.PrimaryInfo;
import org.dbflute.exception.DBMetaNotFoundException;
import org.dbflute.helper.beans.DfPropertyAccessor;
import org.dbflute.helper.beans.DfPropertyDesc;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.s2dao.metadata.TnBeanMetaData;
import org.dbflute.s2dao.metadata.TnPropertyType;
import org.dbflute.s2dao.metadata.TnRelationPropertyType;
import org.dbflute.s2dao.metadata.impl.TnPropertyTypeImpl;

public class TnRelationPropertyTypeImpl
extends TnPropertyTypeImpl
implements TnRelationPropertyType {
    protected final int _relationNo;
    protected final String _relationNoSuffixPart;
    protected final String[] _myKeys;
    protected final String[] _yourKeys;
    protected final TnBeanMetaData _myBeanMetaData;
    protected final TnBeanMetaData _yourBeanMetaData;
    protected final List<TnPropertyType> _uniquePropertyTypeList;
    protected final boolean _hasSimpleUniqueKey;
    protected final boolean _hasCompoundUniqueKey;
    protected final TnPropertyType _simpleUniquePropertyType;
    protected final DfPropertyAccessor _propertyAccessor;

    public TnRelationPropertyTypeImpl(DfPropertyDesc propertyDesc, int relationNo, String[] myKeys, String[] yourKeys, TnBeanMetaData myBeanMetaData, TnBeanMetaData yourBeanMetaData) {
        super(propertyDesc);
        this._relationNo = relationNo;
        this._relationNoSuffixPart = this.buildRelationNoSuffixPart(relationNo);
        this._myKeys = myKeys;
        this._yourKeys = yourKeys;
        this._myBeanMetaData = myBeanMetaData;
        this._yourBeanMetaData = yourBeanMetaData;
        this._uniquePropertyTypeList = this.deriveUniqueKeys(yourKeys, yourBeanMetaData);
        this._hasSimpleUniqueKey = this._uniquePropertyTypeList.size() == 1;
        this._hasCompoundUniqueKey = this._uniquePropertyTypeList.size() >= 2;
        this._simpleUniquePropertyType = this._hasSimpleUniqueKey ? this._uniquePropertyTypeList.get(0) : null;
        this._propertyAccessor = this.createPropertyAccessor(propertyDesc, myBeanMetaData);
    }

    protected String buildRelationNoSuffixPart(int relationNo) {
        return "_" + relationNo;
    }

    protected List<TnPropertyType> deriveUniqueKeys(String[] yourKeys, TnBeanMetaData yourBeanMetaData) {
        ArrayList<TnPropertyType> uniquePropertyTypeList;
        DBMeta dbmeta = yourBeanMetaData.getDBMeta();
        if (dbmeta != null && dbmeta.hasPrimaryKey()) {
            PrimaryInfo primaryInfo = dbmeta.getPrimaryInfo();
            List<ColumnInfo> primaryColumnList = primaryInfo.getPrimaryColumnList();
            uniquePropertyTypeList = new ArrayList(primaryColumnList.size());
            for (ColumnInfo pk : primaryColumnList) {
                TnPropertyType pt = yourBeanMetaData.getPropertyTypeByColumnName(pk.getColumnDbName());
                uniquePropertyTypeList.add(pt);
            }
        } else {
            uniquePropertyTypeList = new ArrayList<TnPropertyType>(yourKeys.length);
            for (String yourKey : yourKeys) {
                TnPropertyType pt = yourBeanMetaData.getPropertyTypeByColumnName(yourKey);
                uniquePropertyTypeList.add(pt);
            }
        }
        return uniquePropertyTypeList;
    }

    protected DfPropertyAccessor createPropertyAccessor(final DfPropertyDesc propertyDesc, TnBeanMetaData myBeanMetaData) {
        DBMeta dbmeta = myBeanMetaData.getDBMeta();
        this.assertDBMetaExists(dbmeta, myBeanMetaData);
        final String propertyName = propertyDesc.getPropertyName();
        final ForeignInfo foreignInfo = dbmeta.hasForeign(propertyName) ? dbmeta.findForeignInfo(propertyName) : null;
        return new DfPropertyAccessor(){

            @Override
            public String getPropertyName() {
                return foreignInfo != null ? foreignInfo.getForeignPropertyName() : propertyName;
            }

            @Override
            public Class<?> getPropertyType() {
                return foreignInfo != null ? foreignInfo.getPropertyAccessType() : propertyDesc.getPropertyType();
            }

            @Override
            public Class<?> getGenericType() {
                return propertyDesc.getGenericType();
            }

            @Override
            public Object getValue(Object target) {
                if (foreignInfo != null && target instanceof Entity) {
                    return foreignInfo.read((Entity)target);
                }
                return propertyDesc.getValue(target);
            }

            @Override
            public void setValue(Object target, Object value) {
                if (foreignInfo != null && target instanceof Entity) {
                    foreignInfo.write((Entity)target, value);
                } else {
                    propertyDesc.setValue(target, value);
                }
            }

            @Override
            public boolean isReadable() {
                return propertyDesc.isReadable();
            }

            @Override
            public boolean isWritable() {
                return propertyDesc.isWritable();
            }
        };
    }

    protected void assertDBMetaExists(DBMeta dbmeta, TnBeanMetaData myBeanMetaData) {
        if (dbmeta == null) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("Not found the DB meta for the entity");
            br.addItem("Advice");
            br.addElement("Basically no way!");
            br.addElement("So confirm your DBFlute environment.");
            br.addElement(" e.g. DBMetaInstanceHandler, table name's case");
            br.addItem("Corresponding Table");
            br.addElement(myBeanMetaData.getTableName());
            br.addElement(myBeanMetaData.getBeanClass());
            String msg = br.buildExceptionMessage();
            throw new DBMetaNotFoundException(msg);
        }
    }

    @Override
    public int getRelationNo() {
        return this._relationNo;
    }

    @Override
    public String getRelationNoSuffixPart() {
        return this._relationNoSuffixPart;
    }

    @Override
    public int getKeySize() {
        if (this._myKeys.length > 0) {
            return this._myKeys.length;
        }
        return this._yourBeanMetaData.getPrimaryKeySize();
    }

    @Override
    public String getMyKey(int index) {
        if (this._myKeys.length > 0) {
            return this._myKeys[index];
        }
        return this._yourBeanMetaData.getPrimaryKeyDbName(index);
    }

    @Override
    public String getYourKey(int index) {
        if (this._yourKeys.length > 0) {
            return this._yourKeys[index];
        }
        return this._yourBeanMetaData.getPrimaryKeyDbName(index);
    }

    @Override
    public boolean isYourKey(String columnName) {
        for (int i = 0; i < this.getKeySize(); ++i) {
            if (!columnName.equalsIgnoreCase(this.getYourKey(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public TnBeanMetaData getMyBeanMetaData() {
        return this._myBeanMetaData;
    }

    @Override
    public TnBeanMetaData getYourBeanMetaData() {
        return this._yourBeanMetaData;
    }

    @Override
    public List<TnPropertyType> getUniquePropertyTypeList() {
        return this._uniquePropertyTypeList;
    }

    @Override
    public boolean hasSimpleUniqueKey() {
        return this._hasSimpleUniqueKey;
    }

    @Override
    public boolean hasCompoundUniqueKey() {
        return this._hasCompoundUniqueKey;
    }

    @Override
    public TnPropertyType getSimpleUniquePropertyType() {
        return this._simpleUniquePropertyType;
    }

    @Override
    public DfPropertyAccessor getPropertyAccessor() {
        return this._propertyAccessor;
    }
}

