/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.s2dao.metadata.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dbflute.dbmeta.DBMeta;
import org.dbflute.dbmeta.name.ColumnSqlName;
import org.dbflute.helper.StringKeyMap;
import org.dbflute.helper.beans.DfBeanDesc;
import org.dbflute.helper.beans.DfPropertyDesc;
import org.dbflute.helper.beans.exception.DfBeanPropertyNotFoundException;
import org.dbflute.helper.beans.factory.DfBeanDescFactory;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.s2dao.identity.TnIdentifierGenerator;
import org.dbflute.s2dao.identity.TnIdentifierGeneratorFactory;
import org.dbflute.s2dao.metadata.TnBeanAnnotationReader;
import org.dbflute.s2dao.metadata.TnBeanMetaData;
import org.dbflute.s2dao.metadata.TnModifiedPropertySupport;
import org.dbflute.s2dao.metadata.TnPropertyType;
import org.dbflute.s2dao.metadata.TnPropertyTypeFactory;
import org.dbflute.s2dao.metadata.TnRelationPropertyType;
import org.dbflute.s2dao.metadata.TnRelationPropertyTypeFactory;

public class TnBeanMetaDataImpl
implements TnBeanMetaData {
    protected final Class<?> _beanClass;
    protected final DBMeta _dbmeta;
    protected String _tableName;
    protected final StringKeyMap<TnPropertyType> _propertyTypeMap = StringKeyMap.createAsCaseInsensitive();
    protected final List<TnPropertyType> _propertyTypeList = new ArrayList<TnPropertyType>();
    protected TnBeanAnnotationReader _beanAnnotationReader;
    protected TnPropertyTypeFactory _propertyTypeFactory;
    protected TnPropertyType[] _primaryKeys;
    protected final Map<String, TnPropertyType> _columnPropertyTypeMap = StringKeyMap.createAsCaseInsensitive();
    protected final List<TnRelationPropertyType> _relationPropertyTypes = new ArrayList<TnRelationPropertyType>();
    protected final List<TnIdentifierGenerator> _identifierGeneratorList = new ArrayList<TnIdentifierGenerator>();
    protected final Map<String, TnIdentifierGenerator> _identifierGeneratorsByPropertyName = StringKeyMap.createAsCaseInsensitive();
    protected String _versionNoPropertyName;
    protected String _timestampPropertyName;
    protected TnModifiedPropertySupport _modifiedPropertySupport;
    protected TnRelationPropertyTypeFactory _relationPropertyTypeFactory;

    public TnBeanMetaDataImpl(Class<?> beanClass, DBMeta dbmeta) {
        this._beanClass = beanClass;
        this._dbmeta = dbmeta;
    }

    public void initialize() {
        DfBeanDesc beanDesc = DfBeanDescFactory.getBeanDesc(this.getBeanClass());
        this.setupTableName(beanDesc);
        this.setupProperty();
        this.setupPrimaryKey();
    }

    protected void setupTableName(DfBeanDesc beanDesc) {
        String ta = this._beanAnnotationReader.getTableAnnotation();
        this._tableName = ta != null ? ta : "df:Unknown";
    }

    protected void setupProperty() {
        TnPropertyType[] propertyTypes = this._propertyTypeFactory.createBeanPropertyTypes();
        for (int i = 0; i < propertyTypes.length; ++i) {
            TnPropertyType pt = propertyTypes[i];
            this.addPropertyType(pt);
            this._columnPropertyTypeMap.put(pt.getColumnDbName(), pt);
        }
        TnRelationPropertyType[] rptTypes = this._relationPropertyTypeFactory.createRelationPropertyTypes();
        for (int i = 0; i < rptTypes.length; ++i) {
            TnRelationPropertyType rpt = rptTypes[i];
            this.addRelationPropertyType(rpt);
        }
    }

    protected void addPropertyType(TnPropertyType propertyType) {
        this._propertyTypeMap.put(propertyType.getPropertyName(), propertyType);
        this._propertyTypeList.add(propertyType);
    }

    protected void setupPrimaryKey() {
        ArrayList<TnPropertyType> keys = new ArrayList<TnPropertyType>();
        for (TnPropertyType pt : this._propertyTypeList) {
            if (!pt.isPrimaryKey()) continue;
            keys.add(pt);
            this.setupIdentifierGenerator(pt);
        }
        this._primaryKeys = keys.toArray(new TnPropertyType[keys.size()]);
    }

    protected void setupIdentifierGenerator(TnPropertyType pt) {
        DfPropertyDesc pd = pt.getPropertyDesc();
        String propertyName = pt.getPropertyName();
        String idType = this._beanAnnotationReader.getId(pd);
        TnIdentifierGenerator generator = TnIdentifierGeneratorFactory.createIdentifierGenerator(pt, idType);
        this._identifierGeneratorList.add(generator);
        this._identifierGeneratorsByPropertyName.put(propertyName, generator);
    }

    protected void addRelationPropertyType(TnRelationPropertyType rpt) {
        for (int i = this._relationPropertyTypes.size(); i <= rpt.getRelationNo(); ++i) {
            this._relationPropertyTypes.add(null);
        }
        this._relationPropertyTypes.set(rpt.getRelationNo(), rpt);
    }

    @Override
    public Class<?> getBeanClass() {
        return this._beanClass;
    }

    @Override
    public DBMeta getDBMeta() {
        return this._dbmeta;
    }

    @Override
    public String getTableName() {
        return this._tableName;
    }

    @Override
    public List<TnPropertyType> getPropertyTypeList() {
        return this._propertyTypeList;
    }

    @Override
    public TnPropertyType getPropertyType(String propertyName) {
        TnPropertyType propertyType = this._propertyTypeMap.get(propertyName);
        if (propertyType == null) {
            String msg = "The propertyName was not found in the map:";
            msg = msg + " propertyName=" + propertyName + " propertyTypeMap=" + this._propertyTypeMap;
            throw new IllegalStateException(msg);
        }
        return propertyType;
    }

    @Override
    public boolean hasPropertyType(String propertyName) {
        return this._propertyTypeMap.get(propertyName) != null;
    }

    @Override
    public TnPropertyType getPropertyTypeByColumnName(String columnName) {
        TnPropertyType propertyType = this._columnPropertyTypeMap.get(columnName);
        if (propertyType == null) {
            this.throwBeanMetaPropertyTypeByColumnNameNotFoundException(columnName);
        }
        return propertyType;
    }

    protected void throwBeanMetaPropertyTypeByColumnNameNotFoundException(String columnName) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The column was not found in the table.");
        br.addItem("Bean Class");
        br.addElement(this._beanClass);
        br.addItem("Column");
        br.addElement(this._tableName + "." + columnName);
        br.addItem("DBMeta");
        br.addElement(this._dbmeta);
        br.addItem("Mapping");
        Set<Map.Entry<String, TnPropertyType>> entrySet = this._columnPropertyTypeMap.entrySet();
        for (Map.Entry<String, TnPropertyType> entry : entrySet) {
            br.addElement(entry.getKey() + ": " + entry.getValue());
        }
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg);
    }

    @Override
    public TnPropertyType getPropertyTypeByAliasName(String alias) {
        if (this.hasPropertyTypeByColumnName(alias)) {
            return this.getPropertyTypeByColumnName(alias);
        }
        int index = alias.lastIndexOf(95);
        if (index < 0) {
            String msg = "The alias was not found in the table: table=" + this._tableName + " alias=" + alias;
            throw new IllegalStateException(msg);
        }
        String columnName = alias.substring(0, index);
        String relnoStr = alias.substring(index + 1);
        int relno = -1;
        try {
            relno = Integer.parseInt(relnoStr);
        }
        catch (Throwable t) {
            String msg = "The alias was not found in the table: table=" + this._tableName + " alias=" + alias;
            throw new IllegalStateException(msg, t);
        }
        TnRelationPropertyType rpt = this.getRelationPropertyType(relno);
        if (!rpt.getYourBeanMetaData().hasPropertyTypeByColumnName(columnName)) {
            String msg = "The alias was not found in the table: table=" + this._tableName + " alias=" + alias;
            throw new IllegalStateException(msg);
        }
        return rpt.getYourBeanMetaData().getPropertyTypeByColumnName(columnName);
    }

    @Override
    public boolean hasPropertyTypeByColumnName(String columnName) {
        return this._columnPropertyTypeMap.get(columnName) != null;
    }

    @Override
    public boolean hasPropertyTypeByAliasName(String alias) {
        if (this.hasPropertyTypeByColumnName(alias)) {
            return true;
        }
        int index = alias.lastIndexOf(95);
        if (index < 0) {
            return false;
        }
        String columnName = alias.substring(0, index);
        String relnoStr = alias.substring(index + 1);
        int relno = -1;
        try {
            relno = Integer.parseInt(relnoStr);
        }
        catch (Throwable t) {
            return false;
        }
        if (relno >= this.getRelationPropertyTypeSize()) {
            return false;
        }
        TnRelationPropertyType rpt = this.getRelationPropertyType(relno);
        return rpt.getYourBeanMetaData().hasPropertyTypeByColumnName(columnName);
    }

    @Override
    public String convertFullColumnName(String alias) {
        if (this.hasPropertyTypeByColumnName(alias)) {
            return this._tableName + "." + alias;
        }
        int index = alias.lastIndexOf(95);
        if (index < 0) {
            String msg = "The alias was not found in the table: table=" + this._tableName + " alias=" + alias;
            throw new IllegalStateException(msg);
        }
        String columnName = alias.substring(0, index);
        String relnoStr = alias.substring(index + 1);
        int relno = -1;
        try {
            relno = Integer.parseInt(relnoStr);
        }
        catch (Throwable t) {
            String msg = "The alias was not found in the table: table=" + this._tableName + " alias=" + alias;
            throw new IllegalStateException(msg, t);
        }
        TnRelationPropertyType rpt = this.getRelationPropertyType(relno);
        if (!rpt.getYourBeanMetaData().hasPropertyTypeByColumnName(columnName)) {
            String msg = "The alias was not found in the table: table=" + this._tableName + " alias=" + alias;
            throw new IllegalStateException(msg);
        }
        return rpt.getPropertyName() + "." + columnName;
    }

    @Override
    public TnPropertyType getVersionNoPropertyType() throws DfBeanPropertyNotFoundException {
        return this.getPropertyType(this.getVersionNoPropertyName());
    }

    @Override
    public TnPropertyType getTimestampPropertyType() throws DfBeanPropertyNotFoundException {
        return this.getPropertyType(this.getTimestampPropertyName());
    }

    @Override
    public String getVersionNoPropertyName() {
        return this._versionNoPropertyName;
    }

    @Override
    public String getTimestampPropertyName() {
        return this._timestampPropertyName;
    }

    @Override
    public boolean hasVersionNoPropertyType() {
        return this.hasPropertyType(this.getVersionNoPropertyName());
    }

    @Override
    public boolean hasTimestampPropertyType() {
        return this.hasPropertyType(this.getTimestampPropertyName());
    }

    @Override
    public List<TnRelationPropertyType> getRelationPropertyTypeList() {
        return this._relationPropertyTypes;
    }

    @Override
    public int getRelationPropertyTypeSize() {
        return this._relationPropertyTypes.size();
    }

    @Override
    public TnRelationPropertyType getRelationPropertyType(int index) {
        return this._relationPropertyTypes.get(index);
    }

    @Override
    public TnRelationPropertyType getRelationPropertyType(String propertyName) throws DfBeanPropertyNotFoundException {
        for (int i = 0; i < this.getRelationPropertyTypeSize(); ++i) {
            TnRelationPropertyType rpt = this._relationPropertyTypes.get(i);
            if (rpt == null || !rpt.getPropertyName().equalsIgnoreCase(propertyName)) continue;
            return rpt;
        }
        throw new DfBeanPropertyNotFoundException(this.getBeanClass(), propertyName);
    }

    @Override
    public int getPrimaryKeySize() {
        return this._primaryKeys.length;
    }

    @Override
    public String getPrimaryKeyDbName(int index) {
        return this._primaryKeys[index].getColumnDbName();
    }

    @Override
    public ColumnSqlName getPrimaryKeySqlName(int index) {
        return this._primaryKeys[index].getColumnSqlName();
    }

    @Override
    public int getIdentifierGeneratorSize() {
        return this._identifierGeneratorList.size();
    }

    @Override
    public TnIdentifierGenerator getIdentifierGenerator(int index) {
        return this._identifierGeneratorList.get(index);
    }

    @Override
    public TnIdentifierGenerator getIdentifierGenerator(String propertyName) {
        return this._identifierGeneratorsByPropertyName.get(propertyName);
    }

    @Override
    public Set<String> getModifiedPropertyNames(Object bean) {
        return this.getModifiedPropertySupport().getModifiedPropertyNames(bean);
    }

    public void setVersionNoPropertyName(String versionNoPropertyName) {
        this._versionNoPropertyName = versionNoPropertyName;
    }

    public void setTimestampPropertyName(String timestampPropertyName) {
        this._timestampPropertyName = timestampPropertyName;
    }

    public void setBeanAnnotationReader(TnBeanAnnotationReader beanAnnotationReader) {
        this._beanAnnotationReader = beanAnnotationReader;
    }

    public void setPropertyTypeFactory(TnPropertyTypeFactory propertyTypeFactory) {
        this._propertyTypeFactory = propertyTypeFactory;
    }

    public void setRelationPropertyTypeFactory(TnRelationPropertyTypeFactory relationPropertyTypeFactory) {
        this._relationPropertyTypeFactory = relationPropertyTypeFactory;
    }

    public TnModifiedPropertySupport getModifiedPropertySupport() {
        return this._modifiedPropertySupport;
    }

    public void setModifiedPropertySupport(TnModifiedPropertySupport propertyModifiedSupport) {
        this._modifiedPropertySupport = propertyModifiedSupport;
    }
}

