/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.s2dao.identity;

import javax.sql.DataSource;
import org.dbflute.bhv.core.context.ResourceContext;
import org.dbflute.dbmeta.DBMeta;
import org.dbflute.dbway.DBDef;
import org.dbflute.dbway.WayOfSQLServer;
import org.dbflute.dbway.WayOfSybase;
import org.dbflute.jdbc.StatementFactory;
import org.dbflute.s2dao.identity.TnIdentityAdjustmentSqlHandler;

public class TnIdentityGenerationHandler {
    public void disableIdentityGeneration(String tableDbName, DataSource dataSource, StatementFactory statementFactory) {
        if (this.isDatabaseSQLServer()) {
            String tableSqlName = this.findDBMeta(tableDbName).getTableSqlName().toString();
            String disableSql = this.getWayOfSQLServer().buildIdentityDisableSql(tableSqlName);
            this.doExecuteIdentityAdjustment(disableSql, dataSource, statementFactory);
        } else if (this.isDatabaseSybase()) {
            String tableSqlName = this.findDBMeta(tableDbName).getTableSqlName().toString();
            String disableSql = this.getWayOfSybase().buildIdentityDisableSql(tableSqlName);
            this.doExecuteIdentityAdjustment(disableSql, dataSource, statementFactory);
        }
    }

    public void enableIdentityGeneration(String tableDbName, DataSource dataSource, StatementFactory statementFactory) {
        if (this.isDatabaseSQLServer()) {
            String tableSqlName = this.findDBMeta(tableDbName).getTableSqlName().toString();
            String enableSql = this.getWayOfSQLServer().buildIdentityEnableSql(tableSqlName);
            this.doExecuteIdentityAdjustment(enableSql, dataSource, statementFactory);
        } else if (this.isDatabaseSybase()) {
            String tableSqlName = this.findDBMeta(tableDbName).getTableSqlName().toString();
            String enableSql = this.getWayOfSybase().buildIdentityEnableSql(tableSqlName);
            this.doExecuteIdentityAdjustment(enableSql, dataSource, statementFactory);
        }
    }

    protected DBMeta findDBMeta(String tableDbName) {
        return ResourceContext.dbmetaProvider().provideDBMeta(tableDbName);
    }

    protected boolean isDatabaseSQLServer() {
        return ResourceContext.isCurrentDBDef(DBDef.SQLServer);
    }

    protected boolean isDatabaseSybase() {
        return ResourceContext.isCurrentDBDef(DBDef.Sybase);
    }

    protected WayOfSQLServer getWayOfSQLServer() {
        return (WayOfSQLServer)ResourceContext.currentDBDef().dbway();
    }

    protected WayOfSybase getWayOfSybase() {
        return (WayOfSybase)ResourceContext.currentDBDef().dbway();
    }

    protected void doExecuteIdentityAdjustment(String sql, DataSource dataSource, StatementFactory statementFactory) {
        TnIdentityAdjustmentSqlHandler handler = this.createIdentityAdjustmentSqlHandler(sql, dataSource, statementFactory);
        handler.execute(new Object[0]);
    }

    protected TnIdentityAdjustmentSqlHandler createIdentityAdjustmentSqlHandler(String sql, DataSource dataSource, StatementFactory statementFactory) {
        return new TnIdentityAdjustmentSqlHandler(dataSource, statementFactory, sql);
    }
}

