/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.optional;

import java.io.Serializable;
import java.util.Optional;
import org.dbflute.optional.OptionalThing;
import org.dbflute.optional.OptionalThingConsumer;
import org.dbflute.optional.OptionalThingExceptionThrower;
import org.dbflute.optional.OptionalThingFunction;
import org.dbflute.optional.OptionalThingIfPresentAfter;
import org.dbflute.optional.OptionalThingPredicate;
import org.dbflute.optional.OptionalThingSupplier;

public abstract class BaseOptional<OBJ>
implements OptionalThing<OBJ>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final OptionalThingIfPresentAfter IF_PRESENT_AFTER_EMPTY = noArgLambda -> {};
    protected static final OptionalThingIfPresentAfter IF_PRESENT_AFTER_NONE_FIRE = noArgLambda -> {
        if (noArgLambda == null) {
            String msg = "The argument 'noArgLambda' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        noArgLambda.process();
    };
    protected final OBJ _obj;
    protected final OptionalThingExceptionThrower _thrower;

    public BaseOptional(OBJ obj, OptionalThingExceptionThrower thrower) {
        this._obj = obj;
        if (thrower == null) {
            String msg = "The argument 'thrower' should not be null: obj=" + obj;
            throw new IllegalArgumentException(msg);
        }
        this._thrower = thrower;
    }

    protected boolean exists() {
        return this._obj != null;
    }

    protected void callbackAlwaysPresent(OptionalThingConsumer<OBJ> objLambda) {
        if (objLambda == null) {
            String msg = "The argument 'objLambda' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (this._obj == null) {
            this._thrower.throwNotFoundException();
        }
        objLambda.accept(this._obj);
    }

    protected OptionalThingIfPresentAfter callbackIfPresent(OptionalThingConsumer<OBJ> consumer) {
        if (consumer == null) {
            String msg = "The argument 'consumer' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (this.exists()) {
            consumer.accept(this._obj);
            return IF_PRESENT_AFTER_EMPTY;
        }
        return IF_PRESENT_AFTER_NONE_FIRE;
    }

    protected OBJ directlyGet() {
        if (!this.exists()) {
            this._thrower.throwNotFoundException();
        }
        return this._obj;
    }

    protected OBJ directlyGetOrElse(OBJ other) {
        return this.exists() ? this._obj : other;
    }

    protected OBJ directlyGetOrElseGet(OptionalThingSupplier<OBJ> supplier) {
        if (supplier == null) {
            String msg = "The argument 'supplier' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        return this.exists() ? this._obj : supplier.get();
    }

    protected <CAUSE extends Throwable> OBJ directlyGetOrElseThrow(OptionalThingSupplier<? extends CAUSE> supplier) throws CAUSE {
        if (supplier == null) {
            String msg = "The argument 'supplier' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (this.exists()) {
            return this.directlyGet();
        }
        throw (Throwable)supplier.get();
    }

    protected <CAUSE extends Throwable, TRANSLATED extends Throwable> OBJ directlyGetOrElseTranslatingThrow(OptionalThingFunction<CAUSE, TRANSLATED> translator) throws TRANSLATED {
        if (translator == null) {
            String msg = "The argument 'supplier' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        try {
            return this.directlyGet();
        }
        catch (Throwable e) {
            Throwable cause = e;
            throw (Throwable)translator.apply(cause);
        }
    }

    protected OptionalThing<OBJ> callbackFilter(OptionalThingPredicate<OBJ> mapper) {
        if (mapper == null) {
            String msg = "The argument 'mapper' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (this.exists()) {
            if (mapper.test(this._obj)) {
                return this;
            }
            return this.createOptionalFilteredObject(null);
        }
        return this.createOptionalFilteredObject(null);
    }

    protected abstract <ARG> OptionalThing<ARG> createOptionalFilteredObject(ARG var1);

    protected <RESULT> OptionalThing<RESULT> callbackMapping(OptionalThingFunction<? super OBJ, ? extends RESULT> mapper) {
        if (mapper == null) {
            String msg = "The argument 'mapper' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        Object result = this.exists() ? (Object)mapper.apply((OBJ)this._obj) : null;
        return this.createOptionalMappedObject(result);
    }

    protected abstract <ARG> OptionalThing<ARG> createOptionalMappedObject(ARG var1);

    protected <RESULT> OptionalThing<RESULT> callbackFlatMapping(OptionalThingFunction<? super OBJ, OptionalThing<RESULT>> mapper) {
        if (mapper == null) {
            String msg = "The argument 'mapper' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (this.exists()) {
            OptionalThing<RESULT> applied = mapper.apply(this._obj);
            if (applied == null) {
                String msg = "The function of your flatMap returned null: function=" + mapper;
                throw new IllegalStateException(msg);
            }
            return applied;
        }
        return this.createOptionalFlatMappedObject(null);
    }

    protected abstract <ARG> OptionalThing<ARG> createOptionalFlatMappedObject(ARG var1);

    @Override
    public Optional<OBJ> toOptional() {
        return Optional.ofNullable(this.directlyGetOrElse(null));
    }

    public int hashCode() {
        return this._obj != null ? this._obj.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (this.getClass().isInstance(obj)) {
            BaseOptional other = (BaseOptional)obj;
            if (this._obj != null) {
                return this._obj.equals(other.directlyGet());
            }
            return !other.exists();
        }
        return false;
    }

    public String toString() {
        return "opt:{" + (this._obj != null ? this._obj.toString() : "null") + "}";
    }
}

