/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.infra.doc.hacomment;

import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dbflute.helper.HandyDate;

public class DfHacoMapPropertyPart {
    protected final String hacomment;
    protected final String diffComment;
    protected final List<String> authorList;
    protected final String pieceCode;
    protected final String pieceOwner;
    protected final LocalDateTime pieceDatetime;
    protected final List<String> previousPieceList;

    public DfHacoMapPropertyPart(String hacomment, String diffComment, List<String> authorList, String pieceCode, String pieceOwner, LocalDateTime pieceDatetime, List<String> previousPieceList) {
        this.hacomment = hacomment;
        this.diffComment = diffComment;
        this.authorList = authorList;
        this.pieceCode = pieceCode;
        this.pieceOwner = pieceOwner;
        this.pieceDatetime = pieceDatetime;
        this.previousPieceList = previousPieceList;
    }

    public DfHacoMapPropertyPart(Map<String, Object> propertyMap) {
        this.hacomment = (String)propertyMap.get("hacomment");
        this.diffComment = (String)propertyMap.get("diffComment");
        this.authorList = ((List)propertyMap.get("authorList")).stream().filter(obj -> obj instanceof String).map(obj -> (String)obj).collect(Collectors.toList());
        this.pieceCode = (String)propertyMap.get("pieceCode");
        this.pieceOwner = (String)propertyMap.get("pieceOwner");
        this.pieceDatetime = new HandyDate((String)propertyMap.get("pieceDatetime")).getLocalDateTime();
        this.previousPieceList = ((List)propertyMap.get("previousPieceList")).stream().map(obj -> (String)obj).collect(Collectors.toList());
    }

    public Map<String, Object> convertToMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("hacomment", this.hacomment);
        map.put("diffComment", this.diffComment);
        map.put("authorList", this.authorList);
        map.put("pieceCode", this.pieceCode);
        map.put("pieceOwner", this.pieceOwner);
        map.put("pieceDatetime", this.pieceDatetime);
        map.put("previousPieceList", this.previousPieceList);
        return map;
    }

    public String getHacomment() {
        return this.hacomment;
    }

    public String getDiffComment() {
        return this.diffComment;
    }

    public List<String> getAuthorList() {
        return this.authorList;
    }

    public String getPieceCode() {
        return this.pieceCode;
    }

    public String getPieceOwner() {
        return this.pieceOwner;
    }

    public LocalDateTime getPieceDatetime() {
        return this.pieceDatetime;
    }

    public List<String> getPreviousPieceList() {
        return this.previousPieceList;
    }
}

